/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util.config;

import com.blackgear.platform.Platform;
import com.blackgear.platform.core.events.ServerLifecycleEvents;
import com.blackgear.platform.core.mixin.core.access.LevelResourceAccessor;
import com.blackgear.platform.core.network.listener.ServerListenerEvents;
import com.blackgear.platform.core.util.config.ConfigTracker;
import com.blackgear.platform.core.util.config.ModConfig;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.FolderName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigLoader {
    public static final Logger LOGGER = LogManager.getLogger();
    static final FolderName SERVERCONFIG = LevelResourceAccessor.createLevelResource("serverconfig");
    public static final ResourceLocation CONFIG_SYNC = Platform.resource("config_sync");

    private static Path getServerConfigPath(MinecraftServer server) {
        Path config = server.func_240776_a_(SERVERCONFIG);
        ConfigLoader.getOrCreateDirectory(config, "serverconfig");
        return config;
    }

    public static void bootstrap() {
        ServerLifecycleEvents.STARTING.register(server -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigPath(server)));
        ServerLifecycleEvents.STOPPING.register(server -> ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigPath(server)));
        ServerListenerEvents.JOIN.register((handler, sender, server) -> {
            ServerPlayerEntity player = handler.field_147369_b;
            if (server.func_213199_b(player.func_146103_bH())) {
                return;
            }
            ConfigTracker.INSTANCE.configSets().get((Object)ModConfig.Type.SERVER).forEach(config -> {
                try {
                    String name = config.getFileName();
                    byte[] data = Files.readAllBytes(config.getFullPath());
                    PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                    buf.func_180714_a(name);
                    buf.func_179250_a(data);
                    sender.sendPacket(CONFIG_SYNC, buf);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        });
    }

    private static void getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            ConfigLoader.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            LOGGER.debug("Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                if (exception instanceof FileAlreadyExistsException) {
                    LOGGER.fatal("Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    LOGGER.fatal("Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)exception);
                }
                throw new RuntimeException("Problem creating directory", exception);
            }
            LOGGER.debug("Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        } else {
            LOGGER.debug("Found existing {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
    }
}

