/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.events;

import com.blackgear.cavesandcliffs.common.item.SpyglassItem;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class SpyglassRenderEvent {
    private static final ResourceLocation SPYGLASS_SCOPE = new ResourceLocation("cavesandcliffs", "textures/misc/spyglass_scope.png");
    private static final Minecraft instance = Minecraft.func_71410_x();
    private static float spyglassScale;
    static double defaultLevel;
    static Double currentLevel;
    static Double defaultMouseSensitivity;

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent event) {
        int scaledWidth = event.getWindow().func_198107_o();
        int scaledHeight = event.getWindow().func_198087_p();
        ClientPlayerEntity player = SpyglassRenderEvent.instance.field_71439_g;
        if (player == null) {
            return;
        }
        if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
            float tickLength = instance.func_193989_ak();
            spyglassScale = MathHelper.func_219799_g((float)(0.5f * tickLength), (float)spyglassScale, (float)1.125f);
            if (SpyglassRenderEvent.instance.field_71474_y.func_243230_g().func_243192_a()) {
                if (SpyglassItem.isUsingSpyglass((LivingEntity)player)) {
                    SpyglassRenderEvent.renderSpyglassOverlay(scaledWidth, scaledHeight);
                } else {
                    spyglassScale = 0.5f;
                }
            }
        }
    }

    private static void renderSpyglassOverlay(int scaledWidth, int scaledHeight) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        instance.func_110434_K().func_110577_a(SPYGLASS_SCOPE);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float screenSize = Math.min(scaledWidth, scaledHeight);
        float scaledScreenSize = Math.min((float)scaledWidth / screenSize, (float)scaledHeight / screenSize) * spyglassScale;
        float horizontalScreenSize = screenSize * scaledScreenSize;
        float verticalScreenSize = screenSize * scaledScreenSize;
        float modifiedWidth = ((float)scaledWidth - horizontalScreenSize) / 2.0f;
        float modifiedHeight = ((float)scaledHeight - verticalScreenSize) / 2.0f;
        float totalWidth = modifiedWidth + horizontalScreenSize;
        float totalHeight = modifiedHeight + verticalScreenSize;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)modifiedWidth, (double)totalHeight, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)totalWidth, (double)totalHeight, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)totalWidth, (double)modifiedHeight, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)modifiedWidth, (double)modifiedHeight, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableTexture();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_(0.0, (double)scaledHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)scaledWidth, (double)scaledHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)scaledWidth, (double)totalHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_(0.0, (double)totalHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_(0.0, (double)modifiedHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)scaledWidth, (double)modifiedHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)scaledWidth, 0.0, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_(0.0, 0.0, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_(0.0, (double)totalHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)modifiedWidth, (double)totalHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)modifiedWidth, (double)modifiedHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_(0.0, (double)modifiedHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)totalWidth, (double)totalHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)scaledWidth, (double)totalHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)scaledWidth, (double)modifiedHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_225582_a_((double)totalWidth, (double)modifiedHeight, -90.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public static void onHandRender(RenderHandEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && SpyglassItem.isUsingSpyglass((LivingEntity)player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void getFOVModifier(FOVUpdateEvent event) {
        PlayerEntity player = event.getEntity();
        float currentFov = event.getNewfov();
        if (Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
            event.setNewfov((float)SpyglassRenderEvent.changeFov(player, currentFov));
        }
    }

    public static double changeFov(PlayerEntity player, double fov) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        if (currentLevel == null) {
            currentLevel = defaultLevel;
        }
        if (!SpyglassItem.isUsingSpyglass((LivingEntity)player)) {
            currentLevel = defaultLevel;
            if (defaultMouseSensitivity != null) {
                settings.field_74341_c = defaultMouseSensitivity;
                defaultMouseSensitivity = null;
            }
            return fov;
        }
        if (defaultMouseSensitivity == null) {
            defaultMouseSensitivity = settings.field_74341_c;
        }
        settings.field_74341_c = defaultMouseSensitivity * (0.1 / currentLevel / 0.1);
        return fov / currentLevel;
    }

    static {
        defaultLevel = 3.0;
    }
}

