/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AbstractLichenBlock
extends Block {
    private static final VoxelShape UP_SHAPE = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, BooleanProperty> FACING_PROPERTIES = SixWayBlock.field_196491_B;
    private static final Map<Direction, VoxelShape> SHAPES_FOR_DIRECTIONS = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), shapes -> {
        shapes.put(Direction.NORTH, SOUTH_SHAPE);
        shapes.put(Direction.EAST, WEST_SHAPE);
        shapes.put(Direction.SOUTH, NORTH_SHAPE);
        shapes.put(Direction.WEST, EAST_SHAPE);
        shapes.put(Direction.UP, UP_SHAPE);
        shapes.put(Direction.DOWN, DOWN_SHAPE);
    });
    protected static final Direction[] DIRECTIONS = Direction.values();
    private final ImmutableMap<BlockState, VoxelShape> shapes;
    private final boolean hasAllHorizontalDirections;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    public AbstractLichenBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j(AbstractLichenBlock.withAllDirections((StateContainer<Block, BlockState>)this.field_176227_L));
        this.shapes = BlockUtils.getShapesForStates(this, AbstractLichenBlock::getShapeForState);
        this.hasAllHorizontalDirections = Direction.Plane.HORIZONTAL.func_239636_a_().allMatch(this::canHaveDirection);
        this.canMirrorX = Direction.Plane.HORIZONTAL.func_239636_a_().filter(Direction.Axis.X).filter(this::canHaveDirection).count() % 2L == 0L;
        this.canMirrorZ = Direction.Plane.HORIZONTAL.func_239636_a_().filter(Direction.Axis.Z).filter(this::canHaveDirection).count() % 2L == 0L;
    }

    protected boolean canHaveDirection(Direction direction) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        for (Direction direction : DIRECTIONS) {
            if (!this.canHaveDirection(direction)) continue;
            builder.func_206894_a(new Property[]{AbstractLichenBlock.getProperty(direction)});
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!AbstractLichenBlock.hasAnyDirection(stateIn)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return AbstractLichenBlock.hasDirection(stateIn, facing) && !AbstractLichenBlock.canGrowOn((IBlockReader)worldIn, facing, facingPos, facingState) ? AbstractLichenBlock.disableDirection(stateIn, AbstractLichenBlock.getProperty(facing)) : stateIn;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.shapes.get((Object)state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        boolean isValidPosition = false;
        for (Direction direction : DIRECTIONS) {
            if (!AbstractLichenBlock.hasDirection(state, direction)) continue;
            BlockPos blockPos = pos.func_177972_a(direction);
            if (!AbstractLichenBlock.canGrowOn((IBlockReader)worldIn, direction, blockPos, worldIn.func_180495_p(blockPos))) {
                return false;
            }
            isValidPosition = true;
        }
        return isValidPosition;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return AbstractLichenBlock.isNotFullBlock(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        return Arrays.stream(context.func_196009_e()).map(direction -> this.withDirection(state, (IBlockReader)world, pos, (Direction)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public BlockState withDirection(BlockState state, IBlockReader worldIn, BlockPos pos, Direction direction) {
        BlockState blockState;
        if (!this.canHaveDirection(direction)) {
            return null;
        }
        if (state.func_203425_a((Block)this)) {
            if (AbstractLichenBlock.hasDirection(state, direction)) {
                return null;
            }
            blockState = state;
        } else {
            blockState = this.isWaterlogged() && BlockUtils.isFluidEqualAndStill(state.func_204520_s(), (Fluid)Fluids.field_204546_a) ? (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)) : this.func_176223_P();
        }
        BlockPos blockPos = pos.func_177972_a(direction);
        return AbstractLichenBlock.canGrowOn(worldIn, direction, blockPos, worldIn.func_180495_p(blockPos)) ? (BlockState)blockState.func_206870_a((Property)AbstractLichenBlock.getProperty(direction), (Comparable)Boolean.valueOf(true)) : null;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        if (!this.hasAllHorizontalDirections) {
            return state;
        }
        return this.mirror(state, arg_0 -> ((Rotation)rot).func_185831_a(arg_0));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        if (mirrorIn == Mirror.FRONT_BACK && !this.canMirrorX) {
            return state;
        }
        if (mirrorIn == Mirror.LEFT_RIGHT && !this.canMirrorZ) {
            return state;
        }
        return this.mirror(state, arg_0 -> ((Mirror)mirrorIn).func_185803_b(arg_0));
    }

    private BlockState mirror(BlockState state, Function<Direction, Direction> mirror) {
        BlockState blockState = state;
        for (Direction direction : DIRECTIONS) {
            if (!this.canHaveDirection(direction)) continue;
            blockState = (BlockState)blockState.func_206870_a((Property)AbstractLichenBlock.getProperty(mirror.apply(direction)), state.func_177229_b((Property)AbstractLichenBlock.getProperty(direction)));
        }
        return blockState;
    }

    public boolean trySpreadRandomly(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        List<Direction> directions = Arrays.asList(DIRECTIONS);
        Collections.shuffle(directions, random);
        return directions.stream().filter(from -> AbstractLichenBlock.hasDirection(state, from)).anyMatch(to -> this.trySpreadRandomly(state, (IWorld)world, pos, (Direction)to, random, false));
    }

    public boolean trySpreadRandomly(BlockState state, IWorld worldIn, BlockPos pos, Direction from, Random random, boolean postProcess) {
        List<Direction> directions = Arrays.asList(DIRECTIONS);
        Collections.shuffle(directions, random);
        return directions.stream().anyMatch(direction -> this.trySpreadTo(state, worldIn, pos, from, (Direction)direction, postProcess));
    }

    public boolean trySpreadTo(BlockState state, IWorld worldIn, BlockPos pos, Direction from, Direction to, boolean postProcess) {
        Optional<Pair<BlockPos, Direction>> spreadLocation = this.getSpreadLocation(state, (IBlockReader)worldIn, pos, from, to);
        if (spreadLocation.isPresent()) {
            Pair<BlockPos, Direction> location = spreadLocation.get();
            return this.addDirection(worldIn, (BlockPos)location.getFirst(), (Direction)location.getSecond(), postProcess);
        }
        return false;
    }

    protected boolean canSpread(BlockState state, IBlockReader worldIn, BlockPos pos, Direction from) {
        return Stream.of(DIRECTIONS).anyMatch(to -> this.getSpreadLocation(state, worldIn, pos, from, (Direction)to).isPresent());
    }

    private Optional<Pair<BlockPos, Direction>> getSpreadLocation(BlockState state, IBlockReader worldIn, BlockPos pos, Direction from, Direction to) {
        if (to.func_176740_k() != from.func_176740_k() && AbstractLichenBlock.hasDirection(state, from) && !AbstractLichenBlock.hasDirection(state, to)) {
            Direction direction;
            if (this.canSpreadTo(worldIn, pos, to)) {
                return Optional.of(Pair.of((Object)pos, (Object)to));
            }
            BlockPos toPos = pos.func_177972_a(to);
            if (this.canSpreadTo(worldIn, toPos, from)) {
                return Optional.of(Pair.of((Object)toPos, (Object)from));
            }
            BlockPos fromPos = toPos.func_177972_a(from);
            return this.canSpreadTo(worldIn, fromPos, direction = to.func_176734_d()) ? Optional.of(Pair.of((Object)fromPos, (Object)direction)) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean canSpreadTo(IBlockReader worldIn, BlockPos pos, Direction direction) {
        BlockState state = worldIn.func_180495_p(pos);
        if (!this.canGrowIn(state)) {
            return false;
        }
        BlockState directionalState = this.withDirection(state, worldIn, pos, direction);
        return directionalState != null;
    }

    private boolean addDirection(IWorld worldIn, BlockPos pos, Direction direction, boolean postProcess) {
        BlockState state = worldIn.func_180495_p(pos);
        BlockState directionalState = this.withDirection(state, (IBlockReader)worldIn, pos, direction);
        if (directionalState != null) {
            if (postProcess) {
                worldIn.func_217349_x(pos).func_201594_d(pos);
            }
            return worldIn.func_180501_a(pos, directionalState, 2);
        }
        return false;
    }

    private boolean canGrowIn(BlockState state) {
        return state.func_196958_f() || state.func_203425_a((Block)this) || state.func_203425_a(Blocks.field_150355_j) && state.func_204520_s().func_206889_d();
    }

    private static boolean hasDirection(BlockState state, Direction direction) {
        BooleanProperty property = AbstractLichenBlock.getProperty(direction);
        return state.func_235901_b_((Property)property) && (Boolean)state.func_177229_b((Property)property) != false;
    }

    private static boolean canGrowOn(IBlockReader worldIn, Direction direction, BlockPos pos, BlockState state) {
        return Block.func_208061_a((VoxelShape)state.func_196952_d(worldIn, pos), (Direction)direction.func_176734_d());
    }

    private boolean isWaterlogged() {
        return this.field_176227_L.func_177623_d().contains(BlockStateProperties.field_208198_y);
    }

    private static BlockState disableDirection(BlockState state, BooleanProperty direction) {
        BlockState blockState = (BlockState)state.func_206870_a((Property)direction, (Comparable)Boolean.valueOf(false));
        return AbstractLichenBlock.hasAnyDirection(blockState) ? blockState : Blocks.field_150350_a.func_176223_P();
    }

    public static BooleanProperty getProperty(Direction direction) {
        return FACING_PROPERTIES.get(direction);
    }

    private static BlockState withAllDirections(StateContainer<Block, BlockState> stateContainer) {
        BlockState state = (BlockState)stateContainer.func_177621_b();
        for (BooleanProperty property : FACING_PROPERTIES.values()) {
            if (!state.func_235901_b_((Property)property)) continue;
            state = (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    private static VoxelShape getShapeForState(BlockState state) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (Direction direction : DIRECTIONS) {
            if (!AbstractLichenBlock.hasDirection(state, direction)) continue;
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPES_FOR_DIRECTIONS.get(direction));
        }
        return shape.func_197766_b() ? VoxelShapes.func_197868_b() : shape;
    }

    protected static boolean hasAnyDirection(BlockState state) {
        return Arrays.stream(DIRECTIONS).anyMatch(direction -> AbstractLichenBlock.hasDirection(state, direction));
    }

    private static boolean isNotFullBlock(BlockState state) {
        return Arrays.stream(DIRECTIONS).anyMatch(direction -> !AbstractLichenBlock.hasDirection(state, direction));
    }
}

