/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.AbstractPlantPartBlock;
import com.blackgear.cavesandcliffs.common.blocks.AbstractPlantStemBlock;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractPlantBlock
extends AbstractPlantPartBlock
implements IGrowable {
    public AbstractPlantBlock(AbstractBlock.Properties properties, Direction growthDirection, VoxelShape shape, boolean scheduleFluidTicks) {
        super(properties, growthDirection, shape, scheduleFluidTicks);
    }

    protected BlockState copyState(BlockState from, BlockState to) {
        return to;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == this.growthDirection.func_176734_d() && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        AbstractPlantStemBlock abstractPlantStemBlock = this.getStem();
        if (facing == this.growthDirection && !facingState.func_203425_a((Block)this) && !facingState.func_177230_c().equals((Object)abstractPlantStemBlock)) {
            return this.copyState(stateIn, abstractPlantStemBlock.gerRandomGrowthState(worldIn));
        }
        if (this.scheduleFluidTicks) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.getStem());
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        Optional<BlockPos> optional = this.getStemHeadPos(worldIn, pos, state.func_177230_c());
        return optional.isPresent() && this.getStem().chooseStemState(worldIn.func_180495_p(optional.get().func_177972_a(this.growthDirection)));
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        Optional<BlockPos> optional = this.getStemHeadPos((IBlockReader)worldIn, pos, state.func_177230_c());
        if (optional.isPresent()) {
            BlockState blockstate = worldIn.func_180495_p(optional.get());
            ((AbstractPlantStemBlock)blockstate.func_177230_c()).func_225535_a_(worldIn, rand, optional.get(), blockstate);
        }
    }

    private Optional<BlockPos> getStemHeadPos(IBlockReader readerIn, BlockPos pos, Block block) {
        return BlockUtils.isTopConnectedTo(readerIn, pos, block, this.growthDirection, this.getStem());
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        boolean replaceable = super.func_196253_a(state, useContext);
        return (!replaceable || useContext.func_195996_i().func_77973_b() != this.getStem().func_199767_j()) && replaceable;
    }

    @Override
    protected Block getPlant() {
        return this;
    }
}

