/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.AbstractPlantStemBlock;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractPlantPartBlock
extends Block {
    protected final Direction growthDirection;
    protected final boolean scheduleFluidTicks;
    protected final VoxelShape shape;

    public AbstractPlantPartBlock(AbstractBlock.Properties properties, Direction growthDirection, VoxelShape shape, boolean scheduleFluidTicks) {
        super(properties);
        this.growthDirection = growthDirection;
        this.shape = shape;
        this.scheduleFluidTicks = scheduleFluidTicks;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(this.growthDirection));
        return !blockstate.func_203425_a((Block)this.getStem()) && !blockstate.func_203425_a(this.getPlant()) ? this.gerRandomGrowthState((IWorld)context.func_195991_k()) : this.getPlant().func_176223_P();
    }

    public BlockState gerRandomGrowthState(IWorld worldIn) {
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockPos = pos.func_177972_a(this.growthDirection.func_176734_d());
        BlockState blockState = worldIn.func_180495_p(blockPos);
        if (!this.canAttachTo(blockState)) {
            return false;
        }
        return blockState.func_203425_a((Block)this.getStem()) || blockState.func_203425_a(this.getPlant()) || blockState.func_224755_d((IBlockReader)worldIn, blockPos, this.growthDirection);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    protected boolean canAttachTo(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shape;
    }

    protected abstract AbstractPlantStemBlock getStem();

    protected abstract Block getPlant();
}

