/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public interface IDegradable<T extends Enum<T>> {
    public Optional<BlockState> getDegradationResult(BlockState var1);

    public float getDegradationChanceMultiplier();

    default public void tickDegradation(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (random.nextFloat() < 0.05688889f) {
            this.tryDegrade(state, world, pos, random);
        }
    }

    public T getDegradationLevel();

    default public void tryDegrade(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        BlockPos blockPos;
        int distance;
        int degradationLevel = ((Enum)this.getDegradationLevel()).ordinal();
        int ticks = 0;
        int age = 0;
        Iterator iterator = BlockPos.func_239583_a_((BlockPos)pos, (int)4, (int)4, (int)4).iterator();
        while (iterator.hasNext() && (distance = (blockPos = (BlockPos)iterator.next()).func_218139_n((Vector3i)pos)) <= 4) {
            BlockState blockState;
            Block block;
            if (blockPos != pos && (block = (blockState = world.func_180495_p(blockPos)).func_177230_c()) instanceof IDegradable) {
                T level = ((IDegradable)block).getDegradationLevel();
                if (this.getDegradationLevel().getClass() == level.getClass()) {
                    int stateLevel = ((Enum)level).ordinal();
                    if (stateLevel < degradationLevel) {
                        return;
                    }
                    if (stateLevel > degradationLevel) {
                        ++age;
                    } else {
                        ++ticks;
                    }
                }
            }
            float time = (float)(age + 1) / (float)(age + ticks + 1);
            float chance = time * time * this.getDegradationChanceMultiplier();
            if (!(random.nextFloat() < chance)) continue;
            this.getDegradationResult(state).ifPresent(stateIn -> world.func_175656_a(pos, stateIn));
        }
    }
}

