/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity;

import com.blackgear.cavesandcliffs.common.entity.AquaticLookControl;
import com.blackgear.cavesandcliffs.common.entity.AquaticMoveControl;
import com.blackgear.cavesandcliffs.common.entity.AxolotlTasks;
import com.blackgear.cavesandcliffs.common.entity.IAngledModelEntity;
import com.blackgear.cavesandcliffs.common.entity.IBucketable;
import com.blackgear.cavesandcliffs.common.util.EntityHelper;
import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.other.tags.CCBItemTags;
import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBMemoryModuleTypes;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBSensorTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AxolotlEntity
extends AnimalEntity
implements IAngledModelEntity,
IBucketable {
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super AxolotlEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_234132_n_, (Object)SensorType.field_221002_f, (Object)CCBSensorTypes.AXOLOTL_ATTACKABLES.get(), (Object)CCBSensorTypes.AXOLOTL_TEMPTATIONS.get());
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_MODULES = ImmutableList.of((Object)MemoryModuleType.field_220953_n, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220949_j, (Object)MemoryModuleType.field_234102_l_, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleType.field_234104_p_, (Object)MemoryModuleType.field_234075_I_, (Object[])new MemoryModuleType[]{MemoryModuleType.field_220958_s, (MemoryModuleType)CCBMemoryModuleTypes.PLAY_DEAD_TICKS.get(), (MemoryModuleType)CCBMemoryModuleTypes.NEAREST_ATTACKABLE.get(), (MemoryModuleType)CCBMemoryModuleTypes.TEMPTING_PLAYER.get(), (MemoryModuleType)CCBMemoryModuleTypes.TEMPTATION_COOLDOWN_TICKS.get(), (MemoryModuleType)CCBMemoryModuleTypes.IS_TEMPTED.get(), (MemoryModuleType)CCBMemoryModuleTypes.HAS_HUNTING_COOLDOWN.get()});
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(AxolotlEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> PLAYING_DEAD = EntityDataManager.func_187226_a(AxolotlEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(AxolotlEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final Map<String, Vector3f> modelAngles = Maps.newHashMap();

    public AxolotlEntity(EntityType<? extends AxolotlEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new AxolotlMoveControl(this);
        this.field_70749_g = new AxolotlLookControl((MobEntity)this, 20);
        this.field_70138_W = 1.0f;
    }

    @Override
    public Map<String, Vector3f> getModelAngles() {
        return this.modelAngles;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(PLAYING_DEAD, (Object)false);
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant().getId());
        compound.func_74757_a("FromBucket", this.isFromBucket());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(Variant.VARIANTS[compound.func_74762_e("Variant")]);
        this.setFromBucket(compound.func_74767_n("FromBucket"));
    }

    public void func_70642_aH() {
        if (!this.isPlayingDead()) {
            super.func_70642_aH();
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        boolean shouldSpawn = false;
        if (reason == SpawnReason.BUCKET) {
            return spawnDataIn;
        }
        if (spawnDataIn instanceof AxolotlData) {
            if (((AxolotlData)((Object)spawnDataIn)).func_226257_a_() >= 2) {
                shouldSpawn = true;
            }
        } else {
            spawnDataIn = new AxolotlData(Variant.getRandomNatural(this.field_70170_p.func_201674_k()), Variant.getRandomNatural(this.field_70170_p.func_201674_k()));
        }
        this.setVariant(((AxolotlData)((Object)spawnDataIn)).getRandomVariant(this.field_70170_p.func_201674_k()));
        if (shouldSpawn) {
            this.func_70873_a(-24000);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        super.func_70030_z();
        if (!this.func_175446_cd()) {
            this.tickAir(air);
        }
    }

    protected void tickAir(int air) {
        if (this.func_70089_S() && !this.func_70026_G()) {
            this.func_70050_g(air - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_205132_u, 2.0f);
            }
        } else {
            this.func_70050_g(this.func_205010_bg());
        }
    }

    public void hydrateFromPotion() {
        int localAir = this.func_70086_ai() + 1800;
        this.func_70050_g(Math.min(localAir, this.func_205010_bg()));
    }

    public int func_205010_bg() {
        return 6000;
    }

    public Variant getVariant() {
        return Variant.VARIANTS[(Integer)this.field_70180_af.func_187225_a(VARIANT)];
    }

    private void setVariant(Variant variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant.getId());
    }

    private static boolean shouldBabyBeDifferent(Random rand) {
        return rand.nextInt(1200) == 0;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public void setPlayingDead(boolean isPlayingDead) {
        this.field_70180_af.func_187227_b(PLAYING_DEAD, (Object)isPlayingDead);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.field_70180_af.func_187225_a(PLAYING_DEAD);
    }

    @Override
    public boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean fromBucket) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)fromBucket);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity entity) {
        AxolotlEntity axolotl = (AxolotlEntity)((EntityType)CCBEntityTypes.AXOLOTL.get()).func_200721_a((World)world);
        if (axolotl != null) {
            Variant variant = AxolotlEntity.shouldBabyBeDifferent(this.field_70146_Z) ? Variant.getRandomUnnatural(this.field_70146_Z) : (this.field_70146_Z.nextBoolean() ? this.getVariant() : ((AxolotlEntity)entity).getVariant());
            axolotl.setVariant(variant);
            axolotl.func_110163_bv();
        }
        return axolotl;
    }

    public double squaredAttackRange(LivingEntity target) {
        return 1.5 + (double)target.func_213311_cf() * 2.0;
    }

    public boolean func_70877_b(ItemStack stack) {
        return CCBItemTags.AXOLOTL_TEMPT_ITEMS.func_230235_a_((Object)stack.func_77973_b());
    }

    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("axolotlBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("axolotlActivityUpdate");
        AxolotlTasks.updateActivities(this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.func_175446_cd()) {
            Optional playDeadTicks = this.func_213375_cj().func_218207_c((MemoryModuleType)CCBMemoryModuleTypes.PLAY_DEAD_TICKS.get());
            this.setPlayingDead(playDeadTicks.isPresent() && (Integer)playDeadTicks.get() > 0);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAxolotlAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 14.0).func_233815_a_(Attributes.field_233821_d_, 1.0).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new AxolotlSwimNavigation(this, worldIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean canAttackEntity = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
        if (canAttackEntity) {
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_184185_a((SoundEvent)CCBSoundEvents.ENTITY_AXOLOTL_ATTACK.get(), 1.0f, 1.0f);
        }
        return canAttackEntity;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        float health = this.func_110143_aJ();
        if (!(this.field_70170_p.func_201670_d() || this.func_175446_cd() || this.field_70170_p.func_201674_k().nextInt(3) != 0 || !((float)this.field_70170_p.field_73012_v.nextInt(3) < amount) && !(health / this.func_110138_aP() < 0.5f) || !(amount < health) || !this.func_70090_H() || source.func_76364_f() == null && source.func_76346_g() == null || this.isPlayingDead())) {
            this.field_213378_br.func_218205_a((MemoryModuleType)CCBMemoryModuleTypes.PLAY_DEAD_TICKS.get(), (Object)200);
        }
        return super.func_70097_a(source, amount);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.655f;
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_70877_b(stack)) {
            int age = this.func_70874_b();
            if (!this.field_70170_p.func_201670_d() && age == 0 && this.func_204701_dC()) {
                this.consumeItemFromStack(player, stack, hand);
                this.func_146082_f(player);
                return ActionResultType.SUCCESS;
            }
            if (this.func_70631_g_()) {
                this.consumeItemFromStack(player, stack, hand);
                this.func_175501_a((int)((float)(-age / 20) * 0.1f), true);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.field_70170_p.func_201670_d()) {
                return ActionResultType.CONSUME;
            }
        }
        return IBucketable.tryBucket(player, hand, this).orElse(super.func_230254_b_(player, hand));
    }

    @Override
    public void copyDataToStack(ItemStack stack) {
        IBucketable.copyDataToStack((MobEntity)this, stack);
        CompoundNBT compound = stack.func_196082_o();
        compound.func_74768_a("Variant", this.getVariant().getId());
        compound.func_74768_a("Age", this.func_70874_b());
    }

    @Override
    public void copyDataFromNbt(CompoundNBT compound) {
        IBucketable.copyDataFromNbt((MobEntity)this, compound);
        this.setVariant(Variant.VARIANTS[compound.func_74762_e("Variant")]);
        if (compound.func_74764_b("Age")) {
            this.func_70873_a(compound.func_74762_e("Age"));
        }
    }

    @Override
    public ItemStack getBucketItem() {
        return ((Item)CCBItems.AXOLOTL_BUCKET.get()).func_190903_i();
    }

    @Override
    public SoundEvent getBucketedSound() {
        return (SoundEvent)CCBSoundEvents.ITEM_BUCKET_FILL_AXOLOTL.get();
    }

    public boolean canTakeDamage() {
        return !this.isPlayingDead() && !this.func_190530_aW() && !this.func_175149_v() && this.func_70089_S();
    }

    public static void appreciatePlayer(AxolotlEntity axolotl) {
        Optional target = axolotl.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        if (target.isPresent()) {
            Entity attacker;
            DamageSource source;
            World world = axolotl.field_70170_p;
            LivingEntity entity = (LivingEntity)target.get();
            if (!entity.func_70089_S() && (source = entity.func_189748_bU()) != null && (attacker = source.func_76346_g()) != null && attacker.func_200600_R() == EntityType.field_200729_aH) {
                PlayerEntity player = (PlayerEntity)attacker;
                List playersNearby = world.func_217357_a(PlayerEntity.class, axolotl.func_174813_aQ().func_186662_g(20.0));
                if (playersNearby.contains(player)) {
                    axolotl.buffPlayer(player);
                }
            }
        }
    }

    public void buffPlayer(PlayerEntity player) {
        int duration;
        EffectInstance effectInstance = player.func_70660_b(Effects.field_76428_l);
        int n = duration = effectInstance != null ? effectInstance.func_76459_b() : 0;
        if (duration < 2400) {
            duration = Math.min(2400, 100 + duration);
            player.func_195064_c(new EffectInstance(Effects.field_76428_l, duration, 0));
        }
        player.func_195063_d(Effects.field_76419_f);
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.isFromBucket();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)CCBSoundEvents.ENTITY_AXOLOTL_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)CCBSoundEvents.ENTITY_AXOLOTL_DEATH.get();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? (SoundEvent)CCBSoundEvents.ENTITY_AXOLOTL_IDLE_WATER.get() : (SoundEvent)CCBSoundEvents.ENTITY_AXOLOTL_IDLE_AIR.get();
    }

    protected SoundEvent func_184181_aa() {
        return (SoundEvent)CCBSoundEvents.ENTITY_AXOLOTL_SPLASH.get();
    }

    protected SoundEvent func_184184_Z() {
        return (SoundEvent)CCBSoundEvents.ENTITY_AXOLOTL_SWIM.get();
    }

    protected Brain.BrainCodec<AxolotlEntity> func_230289_cH_() {
        return Brain.func_233705_a_(MEMORY_MODULES, SENSOR_TYPES);
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        return AxolotlTasks.create((Brain<AxolotlEntity>)this.func_230289_cH_().func_233748_a_(dynamicIn));
    }

    public Brain<AxolotlEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a((LivingEntity)this);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(travelVector);
        }
    }

    private void consumeItemFromStack(PlayerEntity player, ItemStack stack, Hand hand) {
        if (stack.func_77973_b() == Items.field_204272_aO) {
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151131_as));
        } else {
            super.func_175505_a(player, stack);
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isFromBucket() && !this.func_145818_k_();
    }

    public static boolean canSpawn(EntityType<? extends LivingEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return (Boolean)CavesAndCliffsConfig.LEGACY_AXOLOTL_GENERATION.get() == false ? worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150435_aG) : EntityHelper.canSpawnUnderground(type, worldIn, reason, pos, random);
    }

    static class AxolotlSwimNavigation
    extends SwimmerPathNavigator {
        public AxolotlSwimNavigation(AxolotlEntity axolotl, World worldIn) {
            super((MobEntity)axolotl, worldIn);
        }

        protected boolean func_75485_k() {
            return true;
        }

        protected PathFinder func_179679_a(int range) {
            this.field_179695_a = new WalkAndSwimNodeProcessor();
            return new PathFinder(this.field_179695_a, range);
        }

        public boolean func_188555_b(BlockPos pos) {
            return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
        }
    }

    public static class AxolotlData
    extends AgeableEntity.AgeableData {
        public final Variant[] variants;

        public AxolotlData(Variant ... variants) {
            super(false);
            this.variants = variants;
        }

        public Variant getRandomVariant(Random rand) {
            return this.variants[rand.nextInt(this.variants.length)];
        }
    }

    public static enum Variant {
        LUCY(0, "lucy", true),
        WILD(1, "wild", true),
        GOLD(2, "gold", true),
        CYAN(3, "cyan", true),
        BLUE(4, "blue", false);

        public static final Variant[] VARIANTS;
        private final int id;
        private final String name;
        private final boolean natural;

        private Variant(int id, String name, boolean natural) {
            this.id = id;
            this.name = name;
            this.natural = natural;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Variant getRandomNatural(Random rand) {
            return Variant.getRandom(rand, true);
        }

        public static Variant getRandomUnnatural(Random rand) {
            return Variant.getRandom(rand, false);
        }

        private static Variant getRandom(Random rand, boolean natural) {
            Variant[] variants = (Variant[])Arrays.stream(VARIANTS).filter(variant -> variant.natural == natural).toArray(Variant[]::new);
            return Variant.getRandom(variants, rand);
        }

        public static <T> T getRandom(T[] array, Random rand) {
            return array[rand.nextInt(array.length)];
        }

        static {
            VARIANTS = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparing(Variant::getId)).toArray(Variant[]::new);
        }
    }

    class AxolotlLookControl
    extends AquaticLookControl {
        public AxolotlLookControl(MobEntity mob, int maxYawDifference) {
            super(mob, maxYawDifference);
        }

        @Override
        public void func_75649_a() {
            if (!AxolotlEntity.this.isPlayingDead()) {
                super.func_75649_a();
            }
        }
    }

    static class AxolotlMoveControl
    extends AquaticMoveControl {
        private final AxolotlEntity axolotl;

        public AxolotlMoveControl(AxolotlEntity axolotl) {
            super((MobEntity)axolotl, 85, 10, 0.1f, 0.5f, false);
            this.axolotl = axolotl;
        }

        @Override
        public void func_75641_c() {
            if (!this.axolotl.isPlayingDead()) {
                super.func_75641_c();
            }
        }
    }
}

