/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity;

import com.blackgear.cavesandcliffs.common.entity.AxolotlEntity;
import com.blackgear.cavesandcliffs.common.entity.ai.task.AquaticStrollTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.ForgetAttackTargetTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.GoTowardsLookTargetTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.PlayDeadTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.PlayDeadTimerTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.RangedApproachTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.SeekWaterTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.StrollTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.TemptTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.TemptationCooldownTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.UpdateAttackTargetTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.WalkTowardClosestAdultTask;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.core.other.tags.CCBItemTags;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBActivities;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AnimalBreedTask;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MultiTask;
import net.minecraft.entity.ai.brain.task.PredicateTask;
import net.minecraft.entity.ai.brain.task.RunSometimesTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.IPosWrapper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class AxolotlTasks {
    private static final RangedInteger WALK_TOWARD_ADULT_RANGE = RangedInteger.func_233017_a_((int)5, (int)16);

    protected static Brain<?> create(Brain<AxolotlEntity> brain) {
        AxolotlTasks.addCoreActivities(brain);
        AxolotlTasks.addIdleActivities(brain);
        AxolotlTasks.addFightActivities(brain);
        AxolotlTasks.addPlayDeadActivities(brain);
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_233714_e_();
        return brain;
    }

    private static void addPlayDeadActivities(Brain<AxolotlEntity> brain) {
        brain.func_233701_a_((Activity)CCBActivities.PLAY_DEAD.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new PlayDeadTask())), (Object)Pair.of((Object)1, (Object)new PredicateTask(AxolotlTasks::hasBreedTarget, (MemoryModuleType)CCBMemoryModuleTypes.PLAY_DEAD_TICKS.get()))), (Set)ImmutableSet.of((Object)Pair.of((Object)CCBMemoryModuleTypes.PLAY_DEAD_TICKS.get(), (Object)MemoryModuleStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)CCBMemoryModuleTypes.PLAY_DEAD_TICKS.get()));
    }

    private static void addFightActivities(Brain<AxolotlEntity> brain) {
        brain.func_233699_a_(Activity.field_234621_k_, 0, ImmutableList.of(new ForgetAttackTargetTask<AxolotlEntity>(AxolotlEntity::appreciatePlayer), (Object)((Object)new RangedApproachTask(AxolotlTasks::getTargetApproachingSpeed)), (Object)new AttackTargetTask(20), (Object)new PredicateTask(AxolotlTasks::hasBreedTarget, MemoryModuleType.field_234103_o_)), MemoryModuleType.field_234103_o_);
    }

    private static void addCoreActivities(Brain<AxolotlEntity> brain) {
        brain.func_233698_a_(Activity.field_221365_a, 0, ImmutableList.of((Object)new LookTask(45, 90), (Object)new WalkToTargetTask(), (Object)((Object)new PlayDeadTimerTask()), (Object)((Object)new TemptationCooldownTask((MemoryModuleType<Integer>)((MemoryModuleType)CCBMemoryModuleTypes.TEMPTATION_COOLDOWN_TICKS.get())))));
    }

    private static void addIdleActivities(Brain<AxolotlEntity> brain) {
        brain.func_218208_a(Activity.field_221366_b, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimesTask((Task)new LookAtEntityTask(EntityType.field_200729_aH, 6.0f), RangedInteger.func_233017_a_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new AnimalBreedTask((EntityType)CCBEntityTypes.AXOLOTL.get(), 0.2f)), (Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)((Object)new TemptTask(AxolotlTasks::getTemptedSpeed)), (Object)1), (Object)Pair.of(new WalkTowardClosestAdultTask(WALK_TOWARD_ADULT_RANGE, AxolotlTasks::getAdultFollowingSpeed), (Object)1)))), (Object)Pair.of((Object)3, new UpdateAttackTargetTask<AxolotlEntity>(AxolotlTasks::getAttackTarget)), (Object)Pair.of((Object)3, (Object)((Object)new SeekWaterTask(6, 0.15f))), (Object)Pair.of((Object)4, (Object)new MultiTask((Map)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), MultiTask.Ordering.ORDERED, MultiTask.RunType.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)((Object)new AquaticStrollTask(0.5f)), (Object)2), (Object)Pair.of((Object)((Object)new StrollTask(0.15f)), (Object)2), (Object)Pair.of((Object)((Object)new GoTowardsLookTargetTask(AxolotlTasks::canGoToLookTarget, AxolotlTasks::getTemptedSpeed, 3)), (Object)3), (Object)Pair.of((Object)new SupplementedTask(Entity::func_203005_aq, (Task)new DummyTask(30, 60)), (Object)5), (Object)Pair.of((Object)new SupplementedTask(Entity::func_233570_aj_, (Task)new DummyTask(200, 400)), (Object)5))))));
    }

    private static boolean canGoToLookTarget(LivingEntity entity) {
        World world = entity.field_70170_p;
        Optional optional = entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220951_l);
        if (optional.isPresent()) {
            BlockPos pos = ((IPosWrapper)optional.get()).func_220608_a();
            return BlockUtils.isWater((IWorldReader)world, pos) == entity.func_203005_aq();
        }
        return false;
    }

    public static void updateActivities(AxolotlEntity axolotl) {
        Brain<AxolotlEntity> brain = axolotl.func_213375_cj();
        Activity activity = brain.func_233716_f_().orElse(null);
        if (activity != CCBActivities.PLAY_DEAD.get()) {
            brain.func_233706_a_((List)ImmutableList.of((Object)CCBActivities.PLAY_DEAD.get(), (Object)Activity.field_234621_k_, (Object)Activity.field_221366_b));
            if (activity == Activity.field_234621_k_ && brain.func_233716_f_().orElse(null) != Activity.field_234621_k_) {
                brain.func_233696_a_((MemoryModuleType)CCBMemoryModuleTypes.HAS_HUNTING_COOLDOWN.get(), (Object)true, 2400L);
            }
        }
    }

    private static float getTargetApproachingSpeed(LivingEntity entity) {
        return entity.func_203005_aq() ? 0.6f : 0.15f;
    }

    private static float getAdultFollowingSpeed(LivingEntity entity) {
        return entity.func_203005_aq() ? 0.6f : 0.15f;
    }

    private static float getTemptedSpeed(LivingEntity entity) {
        return entity.func_203005_aq() ? 0.5f : 0.15f;
    }

    private static Optional<? extends LivingEntity> getAttackTarget(AxolotlEntity axolotl) {
        return AxolotlTasks.hasBreedTarget(axolotl) ? Optional.empty() : axolotl.func_213375_cj().func_218207_c((MemoryModuleType)CCBMemoryModuleTypes.NEAREST_ATTACKABLE.get());
    }

    private static boolean hasBreedTarget(AxolotlEntity axolotl) {
        return axolotl.func_213375_cj().func_218191_a(MemoryModuleType.field_220953_n);
    }

    public static Ingredient getTemptItems() {
        return Ingredient.func_199805_a(CCBItemTags.AXOLOTL_TEMPT_ITEMS);
    }
}

