/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity;

import com.blackgear.cavesandcliffs.common.entity.AbstractSquidEntity;
import com.blackgear.cavesandcliffs.common.util.EntityHelper;
import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class GlowSquidEntity
extends AbstractSquidEntity {
    private static final DataParameter<Integer> DARK_TICKS_REMAINING = EntityDataManager.func_187226_a(GlowSquidEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public GlowSquidEntity(EntityType<? extends SquidEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected IParticleData getInkParticle() {
        return (IParticleData)CCBParticleTypes.GLOW_SQUID_INK.get();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DARK_TICKS_REMAINING, (Object)0);
    }

    @Override
    protected SoundEvent getSquirtSound() {
        return (SoundEvent)CCBSoundEvents.ENTITY_GLOW_SQUID_SQUIRT.get();
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)CCBSoundEvents.ENTITY_GLOW_SQUID_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)CCBSoundEvents.ENTITY_GLOW_SQUID_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)CCBSoundEvents.ENTITY_GLOW_SQUID_DEATH.get();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("DarkTicksRemaining", this.getDarkTicksRemaining());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setDarkTicks(compound.func_74762_e("DarkTicksRemaining"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        int ticks = this.getDarkTicksRemaining();
        if (ticks > 0) {
            this.setDarkTicks(ticks - 1);
        }
        this.field_70170_p.func_195594_a((IParticleData)CCBParticleTypes.GLOW.get(), this.func_226282_d_(0.6), this.func_226279_cv_(), this.func_226287_g_(0.6), 0.0, 0.0, 0.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean hasBeenDamaged = super.func_70097_a(source, amount);
        if (hasBeenDamaged) {
            this.setDarkTicks(100);
        }
        return hasBeenDamaged;
    }

    private void setDarkTicks(int ticks) {
        this.field_70180_af.func_187227_b(DARK_TICKS_REMAINING, (Object)ticks);
    }

    public int getDarkTicksRemaining() {
        return (Integer)this.field_70180_af.func_187225_a(DARK_TICKS_REMAINING);
    }

    public static boolean canSpawn(EntityType<? extends LivingEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        if (worldIn.func_226691_t_(pos) != ForgeRegistries.BIOMES.getValue(new ResourceLocation("dungeons_world", "squid_coast"))) {
            if (!((Boolean)CavesAndCliffsConfig.LEGACY_GLOW_SQUID_GENERATION.get()).booleanValue()) {
                return worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) && pos.func_177956_o() <= worldIn.func_181545_F() - 33;
            }
            return EntityHelper.canSpawnUnderground(type, worldIn, reason, pos, random);
        }
        return pos.func_177956_o() > 45 && pos.func_177956_o() < worldIn.func_181545_F();
    }
}

