/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity;

import com.blackgear.cavesandcliffs.common.item.ItemUsage;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public interface IBucketable {
    public boolean isFromBucket();

    public void setFromBucket(boolean var1);

    public void copyDataToStack(ItemStack var1);

    public void copyDataFromNbt(CompoundNBT var1);

    public ItemStack getBucketItem();

    public SoundEvent getBucketedSound();

    public static void copyDataToStack(MobEntity entity, ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (entity.func_145818_k_()) {
            stack.func_200302_a(entity.func_200201_e());
        }
        if (entity.func_175446_cd()) {
            nbt.func_74757_a("NoAI", entity.func_175446_cd());
        }
        if (entity.func_174814_R()) {
            nbt.func_74757_a("Silent", entity.func_174814_R());
        }
        if (entity.func_189652_ae()) {
            nbt.func_74757_a("NoGravity", entity.func_189652_ae());
        }
        if (entity.func_225510_bt_()) {
            nbt.func_74757_a("Glowing", entity.func_225510_bt_());
        }
        if (entity.func_190530_aW()) {
            nbt.func_74757_a("Invulnerable", entity.func_190530_aW());
        }
        nbt.func_74776_a("Health", entity.func_110143_aJ());
    }

    public static void copyDataFromNbt(MobEntity entity, CompoundNBT compound) {
        if (compound.func_74764_b("NoAI")) {
            entity.func_94061_f(compound.func_74767_n("NoAI"));
        }
        if (compound.func_74764_b("Silent")) {
            entity.func_174810_b(compound.func_74767_n("Silent"));
        }
        if (compound.func_74764_b("NoGravity")) {
            entity.func_189654_d(compound.func_74767_n("NoGravity"));
        }
        if (compound.func_74764_b("Glowing")) {
            entity.func_184195_f(compound.func_74767_n("Glowing"));
        }
        if (compound.func_74764_b("Invulnerable")) {
            entity.func_184224_h(compound.func_74767_n("Invulnerable"));
        }
        if (compound.func_150297_b("Health", 99)) {
            entity.func_70606_j(compound.func_74760_g("Health"));
        }
    }

    public static <T extends LivingEntity> Optional<ActionResultType> tryBucket(PlayerEntity player, Hand hand, T entity) {
        ItemStack inputStack = player.func_184586_b(hand);
        if (inputStack.func_77973_b() == Items.field_151131_as && entity.func_70089_S()) {
            entity.func_184185_a(((IBucketable)entity).getBucketedSound(), 1.0f, 1.0f);
            ItemStack outputStack = ((IBucketable)entity).getBucketItem();
            ((IBucketable)entity).copyDataToStack(outputStack);
            ItemStack stack = ItemUsage.exchangeStack(inputStack, player, outputStack, false);
            player.func_184611_a(hand, stack);
            World world = entity.field_70170_p;
            if (!world.func_201670_d()) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, outputStack);
            }
            entity.func_70106_y();
            return Optional.of(ActionResultType.func_233537_a_((boolean)world.func_201670_d()));
        }
        return Optional.empty();
    }
}

