/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.ai.sensor;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.world.server.ServerWorld;

public abstract class NearestVisibleLivingEntitySensor
extends Sensor<LivingEntity> {
    protected abstract boolean matches(LivingEntity var1, LivingEntity var2);

    protected abstract MemoryModuleType<LivingEntity> getOutputMemoryModule();

    public Set<MemoryModuleType<?>> func_220974_a() {
        return ImmutableSet.of(this.getOutputMemoryModule());
    }

    protected void func_212872_a_(ServerWorld worldIn, LivingEntity entityIn) {
        entityIn.func_213375_cj().func_218226_a(this.getOutputMemoryModule(), this.getNearestVisibleLivingEntity(entityIn));
    }

    private Optional<LivingEntity> getNearestVisibleLivingEntity(LivingEntity entity) {
        return this.getVisibleLivingEntities(entity).flatMap(entities -> {
            Stream<LivingEntity> nearVisibleEntities = entities.stream().filter(target -> this.matches(entity, (LivingEntity)target));
            return nearVisibleEntities.min(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).func_70068_e(arg_0)));
        });
    }

    protected Optional<List<LivingEntity>> getVisibleLivingEntities(LivingEntity entity) {
        return entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g);
    }
}

