/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.ai.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class SeekWaterTask
extends Task<CreatureEntity> {
    private final int range;
    private final float speed;
    private long time;

    public SeekWaterTask(int range, float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED));
        this.range = range;
        this.speed = speed;
    }

    protected void resetTask(ServerWorld world, CreatureEntity entity, long gameTimeIn) {
        this.time = gameTimeIn + 20L + 2L;
    }

    protected boolean shouldExecute(ServerWorld worldIn, CreatureEntity owner) {
        return !owner.field_70170_p.func_204610_c(owner.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    protected void startExecuting(ServerWorld worldIn, CreatureEntity entityIn, long gameTimeIn) {
        if (gameTimeIn >= this.time) {
            BlockPos currentPos = null;
            BlockPos waterPos = null;
            BlockPos entityPos = entityIn.func_233580_cy_();
            Iterable proximitySortedBoxPositions = BlockPos.func_239583_a_((BlockPos)entityPos, (int)this.range, (int)this.range, (int)this.range);
            for (BlockPos positions : proximitySortedBoxPositions) {
                if (positions.func_177958_n() == entityPos.func_177958_n() && positions.func_177952_p() == entityPos.func_177952_p()) continue;
                BlockState aboveState = entityIn.field_70170_p.func_180495_p(positions.func_177984_a());
                BlockState currentState = entityIn.field_70170_p.func_180495_p(positions);
                if (!currentState.func_203425_a(Blocks.field_150355_j)) continue;
                if (aboveState.func_196958_f()) {
                    currentPos = positions.func_185334_h();
                    break;
                }
                if (waterPos != null || positions.func_218137_a((IPosition)entityIn.func_213303_ch(), 1.5)) continue;
                waterPos = positions.func_185334_h();
            }
            if (currentPos == null) {
                currentPos = waterPos;
            }
            if (currentPos != null) {
                this.time = gameTimeIn + 40L;
                BrainUtil.func_233866_a_((LivingEntity)entityIn, currentPos, (float)this.speed, (int)0);
            }
        }
    }
}

