/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.ai.task;

import com.blackgear.cavesandcliffs.core.registries.entity.CCBMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.IPosWrapper;
import net.minecraft.world.server.ServerWorld;

public class TemptTask
extends Task<CreatureEntity> {
    private final Function<LivingEntity, Float> speed;

    public TemptTask(Function<LivingEntity, Float> speed) {
        super((Map)Util.func_199748_a(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED);
            builder.put((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.REGISTERED);
            builder.put((Object)CCBMemoryModuleTypes.TEMPTATION_COOLDOWN_TICKS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT);
            builder.put((Object)CCBMemoryModuleTypes.IS_TEMPTED.get(), (Object)MemoryModuleStatus.REGISTERED);
            builder.put((Object)CCBMemoryModuleTypes.TEMPTING_PLAYER.get(), (Object)MemoryModuleStatus.VALUE_PRESENT);
            builder.put((Object)MemoryModuleType.field_220953_n, (Object)MemoryModuleStatus.VALUE_ABSENT);
            return builder.build();
        }));
        this.speed = speed;
    }

    protected float getSpeed(CreatureEntity entity) {
        return this.speed.apply((LivingEntity)entity).floatValue();
    }

    private Optional<PlayerEntity> getTemptingPlayer(CreatureEntity entity) {
        return entity.func_213375_cj().func_218207_c((MemoryModuleType)CCBMemoryModuleTypes.TEMPTING_PLAYER.get());
    }

    protected boolean func_220383_a(long gameTime) {
        return false;
    }

    protected boolean shouldContinueExecuting(ServerWorld worldIn, CreatureEntity entityIn, long gameTimeIn) {
        return this.getTemptingPlayer(entityIn).isPresent() && !entityIn.func_213375_cj().func_218191_a(MemoryModuleType.field_220953_n);
    }

    protected void startExecuting(ServerWorld worldIn, CreatureEntity entityIn, long gameTimeIn) {
        entityIn.func_213375_cj().func_218205_a((MemoryModuleType)CCBMemoryModuleTypes.IS_TEMPTED.get(), (Object)true);
    }

    protected void resetTask(ServerWorld worldIn, CreatureEntity entityIn, long gameTimeIn) {
        Brain brain = entityIn.func_213375_cj();
        brain.func_218205_a((MemoryModuleType)CCBMemoryModuleTypes.TEMPTATION_COOLDOWN_TICKS.get(), (Object)100);
        brain.func_218205_a((MemoryModuleType)CCBMemoryModuleTypes.IS_TEMPTED.get(), (Object)false);
        brain.func_218189_b(MemoryModuleType.field_220950_k);
        brain.func_218189_b(MemoryModuleType.field_220951_l);
    }

    protected void updateTask(ServerWorld worldIn, CreatureEntity owner, long gameTime) {
        PlayerEntity player = this.getTemptingPlayer(owner).get();
        Brain brain = owner.func_213375_cj();
        brain.func_218205_a(MemoryModuleType.field_220951_l, (Object)new EntityPosWrapper((Entity)player, true));
        if (owner.func_70068_e((Entity)player) < 6.25) {
            brain.func_218189_b(MemoryModuleType.field_220950_k);
        } else {
            brain.func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget((IPosWrapper)new EntityPosWrapper((Entity)player, false), this.getSpeed(owner), 2));
        }
    }
}

