/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.events.interactions;

import com.blackgear.cavesandcliffs.common.events.PlayerInteraction;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.common.util.WorldEvents;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WaxCopperInteraction
extends PlayerInteraction.Interaction {
    public static final Supplier<BiMap<Block, Block>> UNWAXED_TO_WAXED_BLOCKS = Suppliers.memoize(() -> new ImmutableBiMap.Builder().put((Object)CCBBlocks.COPPER_BLOCK.get(), (Object)CCBBlocks.WAXED_COPPER_BLOCK.get()).put((Object)CCBBlocks.EXPOSED_COPPER.get(), (Object)CCBBlocks.WAXED_EXPOSED_COPPER.get()).put((Object)CCBBlocks.WEATHERED_COPPER.get(), (Object)CCBBlocks.WAXED_WEATHERED_COPPER.get()).put((Object)CCBBlocks.OXIDIZED_COPPER.get(), (Object)CCBBlocks.WAXED_OXIDIZED_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER.get(), (Object)CCBBlocks.WAXED_CUT_COPPER.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER.get()).put((Object)CCBBlocks.OXIDIZED_CUT_COPPER.get(), (Object)CCBBlocks.WAXED_OXIDIZED_CUT_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.OXIDIZED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_OXIDIZED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.CUT_COPPER_VERTICAL_SLAB.get(), (Object)CCBBlocks.WAXED_CUT_COPPER_VERTICAL_SLAB.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_VERTICAL_SLAB.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER_VERTICAL_SLAB.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_VERTICAL_SLAB.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER_VERTICAL_SLAB.get()).put((Object)CCBBlocks.OXIDIZED_CUT_COPPER_VERTICAL_SLAB.get(), (Object)CCBBlocks.WAXED_OXIDIZED_CUT_COPPER_VERTICAL_SLAB.get()).put((Object)CCBBlocks.CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.OXIDIZED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS.get()).build());
    public static final Supplier<BiMap<Block, Block>> WAXED_TO_UNWAXED_BLOCKS = Suppliers.memoize(() -> UNWAXED_TO_WAXED_BLOCKS.get().inverse());

    public WaxCopperInteraction(PlayerInteraction.UseBlockContext ctx) {
        super(ctx, ctx.getItem() == Items.field_226635_pU_);
    }

    @Override
    public ActionResultType onInteraction(World world, PlayerEntity player, Hand hand, BlockPos pos, BlockState state, Block block, ItemStack stack, Item item) {
        return WaxCopperInteraction.getWaxedState(state).map(stateIn -> {
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_232607_M_.func_226695_a_((ServerPlayerEntity)player, pos, stack);
            }
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            world.func_180501_a(pos, stateIn, 11);
            WorldEvents.syncWorldEvent(world, 3003, pos, 0);
            this.event.setCanceled(true);
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }).orElse(ActionResultType.PASS);
    }

    public static Optional<BlockState> getWaxedState(BlockState state) {
        return Optional.ofNullable(UNWAXED_TO_WAXED_BLOCKS.get().get((Object)state.func_177230_c())).map(block -> BlockUtils.getStateWithProperties(block, state));
    }
}

