/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.math.floatprovider;

import com.blackgear.cavesandcliffs.common.math.MathUtils;
import com.blackgear.cavesandcliffs.common.math.floatprovider.FloatProvider;
import com.blackgear.cavesandcliffs.common.math.floatprovider.FloatProviderType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.Function;

public class UniformFloatProvider
extends FloatProvider {
    public static final Codec<UniformFloatProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_inclusive").forGetter(provider -> Float.valueOf(provider.min)), (App)Codec.FLOAT.fieldOf("max_inclusive").forGetter(provider -> Float.valueOf(provider.max))).apply((Applicative)instance, UniformFloatProvider::new)).comapFlatMap(provider -> provider.max < provider.min ? DataResult.error((String)("Max must be at least min, min_inclusive: " + provider.min + ", max_inclusive: " + provider.max)) : DataResult.success((Object)provider), Function.identity());
    private final float min;
    private final float max;

    private UniformFloatProvider(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public static UniformFloatProvider create(float min, float max) {
        return new UniformFloatProvider(min, max);
    }

    @Override
    public float get(Random rand) {
        return MathUtils.nextBetween(rand, this.min, this.max);
    }

    @Override
    public float getMin() {
        return this.min;
    }

    @Override
    public float getMax() {
        return this.max;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.UNIFORM;
    }

    public String toString() {
        return "[" + this.min + "-" + this.max + "]";
    }
}

