/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.math.noise;

import com.blackgear.cavesandcliffs.common.world.gen.NoiseHelper;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;

public class InterpolatedNoiseSampler {
    private final OctavesNoiseGenerator lowerInterpolatedNoise;
    private final OctavesNoiseGenerator upperInterpolatedNoise;
    private final OctavesNoiseGenerator interpolationNoise;

    public InterpolatedNoiseSampler(OctavesNoiseGenerator lowerInterpolatedNoise, OctavesNoiseGenerator upperInterpolatedNoise, OctavesNoiseGenerator interpolationNoise) {
        this.lowerInterpolatedNoise = lowerInterpolatedNoise;
        this.upperInterpolatedNoise = upperInterpolatedNoise;
        this.interpolationNoise = interpolationNoise;
    }

    public InterpolatedNoiseSampler(SharedSeedRandom random) {
        this(NoiseHelper.createOctaves(random, -15, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), NoiseHelper.createOctaves(random, -15, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), NoiseHelper.createOctaves(random, -15, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0));
    }

    public double sample(int x, int y, int z, double horizontalScale, double verticalScale, double horizontalStretch, double verticalStretch) {
        double lowerBound = 0.0;
        double upperBound = 0.0;
        double noise = 0.0;
        double maxHeight = 1.0;
        for (int octave = 0; octave < 8; ++octave) {
            ImprovedNoiseGenerator interpolationNoise = this.interpolationNoise.func_215463_a(octave);
            if (interpolationNoise != null) {
                noise += interpolationNoise.func_215456_a(OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalStretch * maxHeight)), OctavesNoiseGenerator.func_215461_a((double)((double)y * verticalStretch * maxHeight)), OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalStretch * maxHeight)), verticalStretch * maxHeight, (double)y * verticalStretch * maxHeight) / maxHeight;
            }
            maxHeight /= 2.0;
        }
        double slide = (noise / 10.0 + 1.0) / 2.0;
        boolean lowerSlide = slide >= 1.0;
        boolean upperSlide = slide <= 0.0;
        maxHeight = 1.0;
        for (int octave = 0; octave < 16; ++octave) {
            ImprovedNoiseGenerator verticalInterpolation;
            double xIn = OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalScale * maxHeight));
            double yIn = OctavesNoiseGenerator.func_215461_a((double)((double)y * verticalScale * maxHeight));
            double zIn = OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalScale * maxHeight));
            double yScale = verticalScale * maxHeight;
            if (!lowerSlide && (verticalInterpolation = this.lowerInterpolatedNoise.func_215463_a(octave)) != null) {
                lowerBound += verticalInterpolation.func_215456_a(xIn, yIn, zIn, yScale, (double)y * yScale) / maxHeight;
            }
            if (!upperSlide && (verticalInterpolation = this.upperInterpolatedNoise.func_215463_a(octave)) != null) {
                upperBound += verticalInterpolation.func_215456_a(xIn, yIn, zIn, yScale, (double)y * yScale) / maxHeight;
            }
            maxHeight /= 2.0;
        }
        return MathHelper.func_151238_b((double)(lowerBound / 512.0), (double)(upperBound / 512.0), (double)slide);
    }
}

