/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.math.noise;

import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;

public class NoiseInterpolator {
    private double[][] startNoiseBuffer;
    private double[][] endNoiseBuffer;
    private final int sizeY;
    private final int sizeZ;
    private final int minY;
    private final ColumnSampler columnSampler;
    private double x0y0z0;
    private double x0y0z1;
    private double x1y0z0;
    private double x1y0z1;
    private double x0y1z0;
    private double x0y1z1;
    private double x1y1z0;
    private double x1y1z1;
    private double x0z0;
    private double x1z0;
    private double x0z1;
    private double x1z1;
    private double z0;
    private double z1;
    private final int startX;
    private final int startZ;

    public NoiseInterpolator(int sizeX, int sizeY, int sizeZ, ChunkPos pos, int minY, ColumnSampler columnSampler) {
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.minY = minY;
        this.columnSampler = columnSampler;
        this.startNoiseBuffer = NoiseInterpolator.createBuffer(sizeY, sizeZ);
        this.endNoiseBuffer = NoiseInterpolator.createBuffer(sizeY, sizeZ);
        this.startX = pos.field_77276_a * sizeX;
        this.startZ = pos.field_77275_b * sizeZ;
    }

    private static double[][] createBuffer(int sizeY, int sizeZ) {
        int z = sizeZ + 1;
        int y = sizeY + 1;
        double[][] buffer = new double[z][y];
        for (int i = 0; i < z; ++i) {
            buffer[i] = new double[y];
        }
        return buffer;
    }

    public void sampleStartNoise() {
        this.sampleNoise(this.startNoiseBuffer, this.startX);
    }

    public void sampleEndNoise(int x) {
        this.sampleNoise(this.endNoiseBuffer, this.startX + x + 1);
    }

    private void sampleNoise(double[][] buffer, int noiseX) {
        for (int z = 0; z < this.sizeZ + 1; ++z) {
            int noiseZ = this.startZ + z;
            this.columnSampler.fillNoiseColumn(buffer[z], noiseX, noiseZ, this.minY, this.sizeY);
        }
    }

    public void sampleNoiseCorners(int noiseY, int noiseZ) {
        this.x0y0z0 = this.startNoiseBuffer[noiseZ][noiseY];
        this.x0y0z1 = this.startNoiseBuffer[noiseZ + 1][noiseY];
        this.x1y0z0 = this.endNoiseBuffer[noiseZ][noiseY];
        this.x1y0z1 = this.endNoiseBuffer[noiseZ + 1][noiseY];
        this.x0y1z0 = this.startNoiseBuffer[noiseZ][noiseY + 1];
        this.x0y1z1 = this.startNoiseBuffer[noiseZ + 1][noiseY + 1];
        this.x1y1z0 = this.endNoiseBuffer[noiseZ][noiseY + 1];
        this.x1y1z1 = this.endNoiseBuffer[noiseZ + 1][noiseY + 1];
    }

    public void sampleNoiseY(double deltaY) {
        this.x0z0 = MathHelper.func_219803_d((double)deltaY, (double)this.x0y0z0, (double)this.x0y1z0);
        this.x1z0 = MathHelper.func_219803_d((double)deltaY, (double)this.x1y0z0, (double)this.x1y1z0);
        this.x0z1 = MathHelper.func_219803_d((double)deltaY, (double)this.x0y0z1, (double)this.x0y1z1);
        this.x1z1 = MathHelper.func_219803_d((double)deltaY, (double)this.x1y0z1, (double)this.x1y1z1);
    }

    public void sampleNoiseX(double deltaX) {
        this.z0 = MathHelper.func_219803_d((double)deltaX, (double)this.x0z0, (double)this.x1z0);
        this.z1 = MathHelper.func_219803_d((double)deltaX, (double)this.x0z1, (double)this.x1z1);
    }

    public double sampleNoise(double deltaZ) {
        return MathHelper.func_219803_d((double)deltaZ, (double)this.z0, (double)this.z1);
    }

    public void swapBuffers() {
        double[][] buffer = this.startNoiseBuffer;
        this.startNoiseBuffer = this.endNoiseBuffer;
        this.endNoiseBuffer = buffer;
    }

    public static interface ColumnSampler {
        public void fillNoiseColumn(double[] var1, int var2, int var3, int var4, int var5);
    }
}

