/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class BlockUtils {
    public static ImmutableMap<BlockState, VoxelShape> getShapesForStates(Block block, Function<BlockState, VoxelShape> function) {
        return (ImmutableMap)block.func_176194_O().func_177619_a().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), function));
    }

    public static BlockState getStateWithProperties(Block block, BlockState state) {
        BlockState blockState = block.func_176223_P();
        for (Property property : state.func_177230_c().func_176194_O().func_177623_d()) {
            if (!blockState.func_235901_b_(property)) continue;
            blockState = BlockUtils.copyProperty(state, blockState, property);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState source, BlockState target, Property<T> property) {
        return (BlockState)target.func_206870_a(property, source.func_177229_b(property));
    }

    public static boolean isWater(IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static boolean isFluidEqualAndStill(FluidState state, Fluid fluid) {
        return state.func_206886_c() == fluid && state.func_206886_c().func_207193_c(state);
    }

    public static BlockPos withY(BlockPos pos, int y) {
        return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
    }

    public static Iterable<BlockPos> iterateRandomly(Random random, int count, BlockPos around, int range) {
        return BlockPos.func_239585_a_((Random)random, (int)count, (int)(around.func_177958_n() - range), (int)(around.func_177956_o() - range), (int)(around.func_177952_p() - range), (int)(around.func_177958_n() + range), (int)(around.func_177956_o() + range), (int)(around.func_177952_p() + range));
    }

    public static Optional<BlockPos> isTopConnectedTo(IBlockReader readerIn, BlockPos pos, Block block, Direction direction, Block to) {
        BlockState state;
        BlockPos.Mutable mutable = pos.func_239590_i_();
        do {
            mutable.func_189536_c(direction);
        } while ((state = readerIn.func_180495_p((BlockPos)mutable)).func_203425_a(block));
        return state.func_203425_a(to) ? Optional.of(mutable) : Optional.empty();
    }
}

