/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.blocks.BuddingAmethystBlock;
import com.blackgear.cavesandcliffs.common.util.feature.FeatureHelper;
import com.blackgear.cavesandcliffs.common.world.gen.NoiseHelper;
import com.blackgear.cavesandcliffs.common.world.gen.feature.GeodeCrackConfig;
import com.blackgear.cavesandcliffs.common.world.gen.feature.GeodeFeatureConfig;
import com.blackgear.cavesandcliffs.common.world.gen.feature.GeodeLayerConfig;
import com.blackgear.cavesandcliffs.common.world.gen.feature.GeodeLayerThicknessConfig;
import com.blackgear.cavesandcliffs.core.other.tags.CCBBlockTags;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.MaxMinNoiseMixer;
import net.minecraft.world.gen.feature.Feature;

public class GeodeFeature
extends Feature<GeodeFeatureConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public GeodeFeature(Codec<GeodeFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, GeodeFeatureConfig config) {
        BlockState state;
        int minGenOffset = config.minGenOffset;
        int maxGenOffset = config.maxGenOffset;
        LinkedList generationPoints = Lists.newLinkedList();
        int distributionPoints = config.distributionPoints.get(rand);
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom(reader.func_72905_C());
        MaxMinNoiseMixer maxMinNoiseMixer = NoiseHelper.createMultiNoise(sharedSeedRandom, -4, 1.0);
        LinkedList crackPoints = Lists.newLinkedList();
        double wallDistance = (double)distributionPoints / (double)config.outerWallDistance.getMax();
        GeodeLayerThicknessConfig geodeLayerThickness = config.layerThicknessConfig;
        GeodeLayerConfig geodeLayer = config.layerConfig;
        GeodeCrackConfig geodeCrack = config.crackConfig;
        double filling = 1.0 / Math.sqrt(geodeLayerThickness.filling);
        double innerLayer = 1.0 / Math.sqrt(geodeLayerThickness.innerLayer + wallDistance);
        double middleLayer = 1.0 / Math.sqrt(geodeLayerThickness.middleLayer + wallDistance);
        double outerLayer = 1.0 / Math.sqrt(geodeLayerThickness.outerLayer + wallDistance);
        double crack = 1.0 / Math.sqrt(geodeCrack.baseCrackSize + rand.nextDouble() / 2.0 + (distributionPoints > 3 ? wallDistance : 0.0));
        boolean generateCrack = (double)rand.nextFloat() < geodeCrack.generateCrackChance;
        int blockThreshold = 0;
        for (int distance = 0; distance < distributionPoints; ++distance) {
            int zDistance;
            int yDistance;
            int xDistance = config.outerWallDistance.get(rand);
            BlockPos crackPos = pos.func_177982_a(xDistance, yDistance = config.outerWallDistance.get(rand), zDistance = config.outerWallDistance.get(rand));
            state = reader.func_180495_p(crackPos);
            if ((state.func_196958_f() || state.func_235714_a_(CCBBlockTags.GEODE_INVALID_BLOCKS)) && ++blockThreshold > config.invalidBlocksThreshold) {
                return false;
            }
            generationPoints.add(Pair.of((Object)crackPos, (Object)config.pointOffset.get(rand)));
        }
        if (generateCrack) {
            int crackType = rand.nextInt(4);
            int crackDistance = distributionPoints * 2 + 1;
            if (crackType == 0) {
                crackPoints.add(pos.func_177982_a(crackDistance, 7, 0));
                crackPoints.add(pos.func_177982_a(crackDistance, 5, 0));
                crackPoints.add(pos.func_177982_a(crackDistance, 1, 0));
            } else if (crackType == 1) {
                crackPoints.add(pos.func_177982_a(0, 7, crackDistance));
                crackPoints.add(pos.func_177982_a(0, 5, crackDistance));
                crackPoints.add(pos.func_177982_a(0, 1, crackDistance));
            } else if (crackType == 2) {
                crackPoints.add(pos.func_177982_a(crackDistance, 7, crackDistance));
                crackPoints.add(pos.func_177982_a(crackDistance, 5, crackDistance));
                crackPoints.add(pos.func_177982_a(crackDistance, 1, crackDistance));
            } else {
                crackPoints.add(pos.func_177982_a(0, 7, 0));
                crackPoints.add(pos.func_177982_a(0, 5, 0));
                crackPoints.add(pos.func_177982_a(0, 1, 0));
            }
        }
        ArrayList crystalPlacements = Lists.newArrayList();
        Predicate<BlockState> validPosition = FeatureHelper.notInBlockTagPredicate(geodeLayer.cannotReplace);
        for (BlockPos positions : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(minGenOffset, minGenOffset, minGenOffset), (BlockPos)pos.func_177982_a(maxGenOffset, maxGenOffset, maxGenOffset))) {
            double noiseValue = maxMinNoiseMixer.func_237211_a_((double)positions.func_177958_n(), (double)positions.func_177956_o(), (double)positions.func_177952_p()) * config.noiseMultiplier;
            double generationDistance = 0.0;
            double crackDistance = 0.0;
            for (Pair generationPoint : generationPoints) {
                generationDistance += MathHelper.func_181161_i((double)(positions.func_177951_i((Vector3i)generationPoint.getFirst()) + (double)((Integer)generationPoint.getSecond()).intValue())) + noiseValue;
            }
            for (BlockPos crackPos : crackPoints) {
                crackDistance += MathHelper.func_181161_i((double)(positions.func_177951_i((Vector3i)crackPos) + (double)geodeCrack.crackPointOffset + noiseValue));
            }
            if (!(generationDistance > outerLayer)) continue;
            if (generateCrack && crackDistance >= crack && generationDistance < filling) {
                FeatureHelper.setBlockStateIf(reader, positions, Blocks.field_150350_a.func_176223_P(), validPosition);
                for (Direction direction : DIRECTIONS) {
                    BlockPos placements = positions.func_177972_a(direction);
                    FluidState fluidState = reader.func_204610_c(placements);
                    if (fluidState.func_206888_e()) continue;
                    reader.func_205219_F_().func_205360_a(placements, (Object)fluidState.func_206886_c(), 0);
                }
                continue;
            }
            if (generationDistance >= filling) {
                FeatureHelper.setBlockStateIf(reader, positions, geodeLayer.fillingProvider.func_225574_a_(rand, positions), validPosition);
                continue;
            }
            if (generationDistance >= innerLayer) {
                boolean generateAltInnerLayer;
                boolean bl = generateAltInnerLayer = (double)rand.nextFloat() < config.useAlternateLayer0Chance;
                if (generateAltInnerLayer) {
                    FeatureHelper.setBlockStateIf(reader, positions, geodeLayer.alternateInnerLayerProvider.func_225574_a_(rand, positions), validPosition);
                } else {
                    FeatureHelper.setBlockStateIf(reader, positions, geodeLayer.innerLayerProvider.func_225574_a_(rand, positions), validPosition);
                }
                if (config.placementsRequireLayer0Alternate && !generateAltInnerLayer || !((double)rand.nextFloat() < config.usePotentialPlacementsChance)) continue;
                crystalPlacements.add(positions.func_185334_h());
                continue;
            }
            if (generationDistance >= middleLayer) {
                FeatureHelper.setBlockStateIf(reader, positions, geodeLayer.middleLayerProvider.func_225574_a_(rand, positions), validPosition);
                continue;
            }
            if (!(generationDistance >= outerLayer)) continue;
            FeatureHelper.setBlockStateIf(reader, positions, geodeLayer.outerLayerProvider.func_225574_a_(rand, positions), validPosition);
        }
        List<BlockState> innerPlacements = geodeLayer.innerPlacements;
        block5: for (BlockPos placements : crystalPlacements) {
            state = this.getRandom(innerPlacements, rand);
            for (Direction direction : DIRECTIONS) {
                if (state.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
                    state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction);
                }
                BlockPos shuffledPos = placements.func_177972_a(direction);
                BlockState blockState = reader.func_180495_p(shuffledPos);
                if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                    state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(blockState.func_204520_s().func_206889_d()));
                }
                if (!BuddingAmethystBlock.canGrowIn(blockState)) continue;
                FeatureHelper.setBlockStateIf(reader, shuffledPos, state, validPosition);
                continue block5;
            }
        }
        return true;
    }

    private <T> T getRandom(List<T> list, Random rand) {
        return list.get(rand.nextInt(list.size()));
    }
}

