/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.math.MathUtils;
import com.blackgear.cavesandcliffs.common.math.floatprovider.FloatProvider;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.common.util.feature.CaveSurface;
import com.blackgear.cavesandcliffs.common.util.feature.DripstoneHelper;
import com.blackgear.cavesandcliffs.common.world.gen.feature.LargeDripstoneFeatureConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class LargeDripstoneFeature
extends Feature<LargeDripstoneFeatureConfig> {
    public LargeDripstoneFeature(Codec<LargeDripstoneFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, LargeDripstoneFeatureConfig config) {
        if (!DripstoneHelper.canGenerate((IWorld)reader, pos)) {
            return false;
        }
        Optional<CaveSurface> surface = CaveSurface.create(reader, pos, config.floorToCeilingSearchRange, DripstoneHelper::canGenerate, DripstoneHelper::canReplaceOrLava);
        if (surface.isPresent() && surface.get() instanceof CaveSurface.Bounded) {
            CaveSurface.Bounded boundedSurface = (CaveSurface.Bounded)surface.get();
            if (boundedSurface.getHeight() < 4) {
                return false;
            }
            int radiusToHeightRatio = (int)((float)boundedSurface.getHeight() * config.maxColumnRadiusToCaveHeightRatio);
            int columnRadius = MathHelper.func_76125_a((int)radiusToHeightRatio, (int)config.columnRadius.getMin(), (int)config.columnRadius.getMax());
            int columnScale = MathUtils.nextBetween(rand, config.columnRadius.getMin(), columnRadius);
            DripstoneGenerator stalactiteGenerator = LargeDripstoneFeature.createGenerator(BlockUtils.withY(pos, boundedSurface.getCeiling() - 1), false, rand, columnScale, config.stalactiteBluntness, config.heightScale);
            DripstoneGenerator stalagmiteGenerator = LargeDripstoneFeature.createGenerator(BlockUtils.withY(pos, boundedSurface.getFloor() + 1), true, rand, columnScale, config.stalagmiteBluntness, config.heightScale);
            WindModifier wind = stalactiteGenerator.generateWind(config) && stalagmiteGenerator.generateWind(config) ? new WindModifier(pos.func_177956_o(), rand, config.windSpeed) : WindModifier.create();
            boolean generateStalactite = stalactiteGenerator.canGenerate(reader, wind);
            boolean generateStalagmite = stalagmiteGenerator.canGenerate(reader, wind);
            if (generateStalactite) {
                stalactiteGenerator.generate(reader, rand, wind);
            }
            if (generateStalagmite) {
                stalagmiteGenerator.generate(reader, rand, wind);
            }
            return true;
        }
        return false;
    }

    private static DripstoneGenerator createGenerator(BlockPos pos, boolean isStalagmite, Random random, int scale, FloatProvider bluntness, FloatProvider heightScale) {
        return new DripstoneGenerator(pos, isStalagmite, scale, bluntness.get(random), heightScale.get(random));
    }

    static final class WindModifier {
        private final int y;
        @Nullable
        private final Vector3d wind;

        WindModifier(int y, Random random, FloatProvider wind) {
            this.y = y;
            float offset = wind.get(random);
            float motion = MathUtils.nextBetween(random, 0.0f, (float)Math.PI);
            this.wind = new Vector3d((double)(MathHelper.func_76134_b((float)motion) * offset), 0.0, (double)(MathHelper.func_76126_a((float)motion) * offset));
        }

        private WindModifier() {
            this.y = 0;
            this.wind = null;
        }

        static WindModifier create() {
            return new WindModifier();
        }

        BlockPos modify(BlockPos pos) {
            if (this.wind == null) {
                return pos;
            }
            int y = this.y - pos.func_177956_o();
            Vector3d vec3d = this.wind.func_186678_a((double)y);
            return pos.func_177963_a(vec3d.field_72450_a, 0.0, vec3d.field_72449_c);
        }
    }

    static final class DripstoneGenerator {
        private BlockPos pos;
        private final boolean isStalagmite;
        private int scale;
        private final double bluntness;
        private final double heightScale;

        DripstoneGenerator(BlockPos blockPos, boolean isStalagmite, int scale, double bluntness, double heightScale) {
            this.pos = blockPos;
            this.isStalagmite = isStalagmite;
            this.scale = scale;
            this.bluntness = bluntness;
            this.heightScale = heightScale;
        }

        private int getBaseScale() {
            return this.scale(0.0f);
        }

        private int getMinY() {
            return this.isStalagmite ? this.pos.func_177956_o() : this.pos.func_177956_o() - this.getBaseScale();
        }

        private int getMaxY() {
            return !this.isStalagmite ? this.pos.func_177956_o() : this.pos.func_177956_o() + this.getBaseScale();
        }

        boolean canGenerate(ISeedReader readerIn, WindModifier wind) {
            while (this.scale > 1) {
                BlockPos.Mutable mutable = this.pos.func_239590_i_();
                int height = Math.min(10, this.getBaseScale());
                for (int i = 0; i < height; ++i) {
                    if (readerIn.func_180495_p((BlockPos)mutable).func_203425_a(Blocks.field_150353_l)) {
                        return false;
                    }
                    if (DripstoneHelper.canGenerateBase(readerIn, wind.modify((BlockPos)mutable), this.scale)) {
                        this.pos = mutable;
                        return true;
                    }
                    mutable.func_189536_c(this.isStalagmite ? Direction.DOWN : Direction.UP);
                }
                this.scale /= 2;
            }
            return false;
        }

        private int scale(float height) {
            return (int)DripstoneHelper.scaleHeightFromRadius(height, this.scale, this.heightScale, this.bluntness);
        }

        void generate(ISeedReader readerIn, Random random, WindModifier wind) {
            for (int xScale = -this.scale; xScale <= this.scale; ++xScale) {
                block1: for (int zScale = -this.scale; zScale <= this.scale; ++zScale) {
                    int scale;
                    float area = MathHelper.func_76129_c((float)(xScale * xScale + zScale * zScale));
                    if (!(area < (float)this.scale) || (scale = this.scale(area)) <= 0) continue;
                    if ((double)random.nextFloat() < 0.2) {
                        scale = (int)((float)scale * MathUtils.nextBetween(random, 0.8f, 1.0f));
                    }
                    BlockPos.Mutable mutable = this.pos.func_177982_a(xScale, 0, zScale).func_239590_i_();
                    boolean canGenerate = false;
                    for (int i = 0; i < scale; ++i) {
                        BlockPos blockPos = wind.modify((BlockPos)mutable);
                        if (DripstoneHelper.canGenerateOrLava((IWorld)readerIn, blockPos)) {
                            canGenerate = true;
                            Block block = (Block)CCBBlocks.DRIPSTONE_BLOCK.get();
                            readerIn.func_180501_a(blockPos, block.func_176223_P(), 2);
                        } else if (canGenerate && readerIn.func_180495_p(blockPos).func_235714_a_((ITag)BlockTags.field_242172_aH)) continue block1;
                        mutable.func_189536_c(this.isStalagmite ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        boolean generateWind(LargeDripstoneFeatureConfig config) {
            return this.scale >= config.minRadiusForWind && this.bluntness >= (double)config.minBluntnessForWind;
        }
    }
}

