/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.world.gen.feature.ModOreFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class ModOreFeature
extends Feature<ModOreFeatureConfig> {
    public ModOreFeature(Codec<ModOreFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, ModOreFeatureConfig config) {
        float chance = rand.nextFloat() * (float)Math.PI;
        float size = (float)config.size / 8.0f;
        int ceil = MathHelper.func_76123_f((float)(((float)config.size / 16.0f * 2.0f + 1.0f) / 2.0f));
        double startX = (double)pos.func_177958_n() + Math.sin(chance) * (double)size;
        double endX = (double)pos.func_177958_n() - Math.sin(chance) * (double)size;
        double startZ = (double)pos.func_177952_p() + Math.cos(chance) * (double)size;
        double endZ = (double)pos.func_177952_p() - Math.cos(chance) * (double)size;
        double startY = pos.func_177956_o() + rand.nextInt(3) - 2;
        double endY = pos.func_177956_o() + rand.nextInt(3) - 2;
        int x = pos.func_177958_n() - MathHelper.func_76123_f((float)size) - ceil;
        int y = pos.func_177956_o() - 2 - ceil;
        int z = pos.func_177952_p() - MathHelper.func_76123_f((float)size) - ceil;
        int horizontalScale = 2 * (MathHelper.func_76123_f((float)size) + ceil);
        int verticalScale = 2 * (2 + ceil);
        for (int xScale = x; xScale <= x + horizontalScale; ++xScale) {
            for (int zScale = z; zScale <= z + horizontalScale; ++zScale) {
                if (y > reader.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, xScale, zScale)) continue;
                return this.generateVeinPart(reader, rand, config, startX, endX, startZ, endZ, startY, endY, x, y, z, horizontalScale, verticalScale);
            }
        }
        return false;
    }

    protected boolean generateVeinPart(ISeedReader readerIn, Random random, ModOreFeatureConfig config, double startX, double endX, double startZ, double endZ, double startY, double endY, int x, int y, int z, int horizontalSize, int verticalSize) {
        double zSize;
        double ySize;
        double xSize;
        int index;
        int veins = 0;
        BitSet bitset = new BitSet(horizontalSize * verticalSize * horizontalSize);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int size = config.size;
        double[] buffer = new double[size * 4];
        for (index = 0; index < size; ++index) {
            float veinSize = (float)index / (float)size;
            xSize = MathHelper.func_219803_d((double)veinSize, (double)startX, (double)endX);
            ySize = MathHelper.func_219803_d((double)veinSize, (double)startY, (double)endY);
            zSize = MathHelper.func_219803_d((double)veinSize, (double)startZ, (double)endZ);
            double chance = random.nextDouble() * (double)size / 16.0;
            double radius = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * veinSize)) + 1.0f) * chance + 1.0) / 2.0;
            buffer[index * 4] = xSize;
            buffer[index * 4 + 1] = ySize;
            buffer[index * 4 + 2] = zSize;
            buffer[index * 4 + 3] = radius;
        }
        for (index = 0; index < size - 1; ++index) {
            if (buffer[index * 4 + 3] <= 0.0) continue;
            for (int veinSize = index + 1; veinSize < size; ++veinSize) {
                double radius;
                if (buffer[veinSize * 4 + 3] <= 0.0 || !((radius = buffer[index * 4 + 3] - buffer[veinSize * 4 + 3]) * radius > (xSize = buffer[index * 4] - buffer[veinSize * 4]) * xSize + (ySize = buffer[index * 4 + 1] - buffer[veinSize * 4 + 1]) * ySize + (zSize = buffer[index * 4 + 2] - buffer[veinSize * 4 + 2]) * zSize)) continue;
                if (radius > 0.0) {
                    buffer[veinSize * 4 + 3] = -1.0;
                    continue;
                }
                buffer[index * 4 + 3] = -1.0;
            }
        }
        for (int veinSize = 0; veinSize < size; ++veinSize) {
            double noise = buffer[veinSize * 4 + 3];
            if (noise < 0.0) continue;
            double xSize2 = buffer[veinSize * 4];
            double ySize2 = buffer[veinSize * 4 + 1];
            double zSize2 = buffer[veinSize * 4 + 2];
            int minX = Math.max(MathHelper.func_76128_c((double)(xSize2 - noise)), x);
            int minY = Math.max(MathHelper.func_76128_c((double)(ySize2 - noise)), y);
            int minZ = Math.max(MathHelper.func_76128_c((double)(zSize2 - noise)), z);
            int maxX = Math.max(MathHelper.func_76128_c((double)(xSize2 + noise)), minX);
            int maxY = Math.max(MathHelper.func_76128_c((double)(ySize2 + noise)), minY);
            int maxZ = Math.max(MathHelper.func_76128_c((double)(zSize2 + noise)), minZ);
            for (int localX = minX; localX <= maxX; ++localX) {
                double realX = ((double)localX + 0.5 - xSize2) / noise;
                if (!(realX * realX < 1.0)) continue;
                for (int localY = minY; localY <= maxY; ++localY) {
                    double realY = ((double)localY + 0.5 - ySize2) / noise;
                    if (!(realX * realX + realY * realY < 1.0)) continue;
                    block6: for (int localZ = minZ; localZ <= maxZ; ++localZ) {
                        int bitIndex;
                        double realZ = ((double)localZ + 0.5 - zSize2) / noise;
                        if (!(realX * realX + realY * realY + realZ * realZ < 1.0) || bitset.get(bitIndex = localX - x + (localY - y) * horizontalSize + (localZ - z) * horizontalSize * verticalSize)) continue;
                        bitset.set(bitIndex);
                        mutable.func_181079_c(localX, localY, localZ);
                        for (ModOreFeatureConfig.Target target : config.targets) {
                            if (!ModOreFeature.shouldPlace(readerIn.func_180495_p((BlockPos)mutable), random, config, target)) continue;
                            readerIn.func_180501_a((BlockPos)mutable, target.state, 2);
                            ++veins;
                            continue block6;
                        }
                    }
                }
            }
        }
        return veins > 0;
    }

    public static boolean shouldPlace(BlockState state, Random random, ModOreFeatureConfig config, ModOreFeatureConfig.Target target) {
        if (!target.target.func_215181_a(state, random)) {
            return false;
        }
        return ModOreFeature.shouldNotDiscard(random, config.discardOnAirChance);
    }

    protected static boolean shouldNotDiscard(Random random, float chance) {
        if (chance <= 0.0f) {
            return true;
        }
        if (chance >= 1.0f) {
            return false;
        }
        return random.nextFloat() >= chance;
    }
}

