/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.world.gen.feature.RootSystemFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeature;

public class RootSystemFeature
extends Feature<RootSystemFeatureConfig> {
    public RootSystemFeature(Codec<RootSystemFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, RootSystemFeatureConfig config) {
        if (!reader.func_180495_p(pos).func_196958_f()) {
            return false;
        }
        BlockPos.Mutable mutable = pos.func_239590_i_();
        if (this.generateTreeAndRoots(reader, generator, config, rand, mutable, pos)) {
            this.generateHangingRoots(reader, config, rand, pos, mutable);
        }
        return true;
    }

    private boolean hasSpaceForTree(ISeedReader readerIn, RootSystemFeatureConfig config, BlockPos pos) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int height = 0; height <= config.requiredVerticalSpaceForTree; ++height) {
            mutable.func_189536_c(Direction.UP);
            BlockState state = readerIn.func_180495_p((BlockPos)mutable);
            if (RootSystemFeature.isAirOrWater(state, height, config.allowedVerticalWaterForTree)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAirOrWater(BlockState state, int height, int allowedVerticalWaterForTree) {
        return state.func_196958_f() || height <= allowedVerticalWaterForTree && state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    private boolean generateTreeAndRoots(ISeedReader readerIn, ChunkGenerator generator, RootSystemFeatureConfig config, Random rand, BlockPos.Mutable mutable, BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        for (int height = 0; height < config.maxRootColumnHeight; ++height) {
            mutable.func_189536_c(Direction.UP);
            if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)readerIn, (BlockPos)mutable)) {
                if (!this.hasSpaceForTree(readerIn, config, (BlockPos)mutable)) continue;
                BlockPos blockPos = mutable.func_177977_b();
                if (readerIn.func_204610_c(blockPos).func_206884_a((ITag)FluidTags.field_206960_b) || !readerIn.func_180495_p(blockPos).func_185904_a().func_76220_a()) {
                    return false;
                }
                if (!this.generateFeature(readerIn, generator, config, rand, (BlockPos)mutable)) continue;
                return true;
            }
            this.placeRootedDirt(readerIn, config, rand, x, z, mutable);
        }
        return false;
    }

    private boolean generateFeature(ISeedReader readerIn, ChunkGenerator generator, RootSystemFeatureConfig config, Random rand, BlockPos pos) {
        return config.feature.get().func_242765_a(readerIn, generator, rand, pos);
    }

    private void placeRootedDirt(ISeedReader readerIn, RootSystemFeatureConfig config, Random rand, int x, int z, BlockPos.Mutable mutable) {
        int radius = config.rootRadius;
        ITag blockTag = BlockTags.func_199896_a().func_199910_a(config.rootReplaceable);
        Predicate<BlockState> predicate = blockTag == null ? state -> true : state -> state.func_235714_a_(blockTag);
        for (int attempts = 0; attempts < config.rootPlacementAttempts; ++attempts) {
            mutable.func_239621_a_((Vector3i)mutable, rand.nextInt(radius) - rand.nextInt(radius), 0, rand.nextInt(radius) - rand.nextInt(radius));
            if (predicate.test(readerIn.func_180495_p((BlockPos)mutable))) {
                readerIn.func_180501_a((BlockPos)mutable, config.rootStateProvider.func_225574_a_(rand, (BlockPos)mutable), 2);
            }
            mutable.func_223471_o(x);
            mutable.func_223472_q(z);
        }
    }

    private void generateHangingRoots(ISeedReader readerIn, RootSystemFeatureConfig config, Random rand, BlockPos pos, BlockPos.Mutable mutable) {
        int radius = config.hangingRootRadius;
        int verticalSpan = config.hangingRootVerticalSpan;
        for (int attempts = 0; attempts < config.hangingRootPlacementAttempts; ++attempts) {
            BlockState state;
            mutable.func_239621_a_((Vector3i)pos, rand.nextInt(radius) - rand.nextInt(radius), rand.nextInt(verticalSpan) - rand.nextInt(verticalSpan), rand.nextInt(radius) - rand.nextInt(radius));
            if (!readerIn.func_175623_d((BlockPos)mutable) || !(state = config.hangingRootStateProvider.func_225574_a_(rand, (BlockPos)mutable)).func_196955_c((IWorldReader)readerIn, (BlockPos)mutable) || !readerIn.func_180495_p(mutable.func_177984_a()).func_224755_d((IBlockReader)readerIn, (BlockPos)mutable, Direction.DOWN)) continue;
            readerIn.func_180501_a((BlockPos)mutable, state, 2);
        }
    }
}

