/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.world.gen.feature.VegetationPatchFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class VegetationPatchFeature
extends Feature<VegetationPatchFeatureConfig> {
    public VegetationPatchFeature(Codec<VegetationPatchFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, VegetationPatchFeatureConfig config) {
        Predicate<BlockState> replaceable = this.getReplaceablePredicate(config);
        int radiusX = config.xzRadius.get(rand) + 1;
        int radiusZ = config.xzRadius.get(rand) + 1;
        Set<BlockPos> positions = this.placeGroundAndGetPositions(reader, config, rand, pos, replaceable, radiusX, radiusZ);
        this.generateVegetation(generator, reader, config, rand, positions);
        return !positions.isEmpty();
    }

    protected Set<BlockPos> placeGroundAndGetPositions(ISeedReader readerIn, VegetationPatchFeatureConfig config, Random rand, BlockPos pos, Predicate<BlockState> replaceable, int radiusX, int radiusZ) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        BlockPos.Mutable position = mutable.func_239590_i_();
        Direction surfaceDirection = config.surface.getDirection();
        Direction oppositeSurface = surfaceDirection.func_176734_d();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int x = -radiusX; x <= radiusX; ++x) {
            boolean startOrEndX = x == -radiusX || x == radiusX;
            for (int z = -radiusZ; z <= radiusZ; ++z) {
                int range;
                boolean atEdge;
                boolean startOrEndZ = z == -radiusZ || z == radiusZ;
                boolean atEnd = startOrEndX || startOrEndZ;
                boolean atCorner = startOrEndX && startOrEndZ;
                boolean bl = atEdge = atEnd && !atCorner;
                if (atCorner || atEdge && (config.extraEdgeColumnChance == 0.0f || !(rand.nextFloat() <= config.extraEdgeColumnChance))) continue;
                mutable.func_239621_a_((Vector3i)pos, x, 0, z);
                for (range = 0; readerIn.func_217375_a((BlockPos)mutable, AbstractBlock.AbstractBlockState::func_196958_f) && range < config.verticalRange; ++range) {
                    mutable.func_189536_c(surfaceDirection);
                }
                for (range = 0; readerIn.func_217375_a((BlockPos)mutable, state -> !state.func_196958_f()) && range < config.verticalRange; ++range) {
                    mutable.func_189536_c(oppositeSurface);
                }
                position.func_239622_a_((Vector3i)mutable, config.surface.getDirection());
                BlockState state2 = readerIn.func_180495_p((BlockPos)position);
                if (!readerIn.func_175623_d((BlockPos)mutable) || !state2.func_224755_d((IBlockReader)readerIn, (BlockPos)position, config.surface.getDirection().func_176734_d())) continue;
                int depth = config.depth.get(rand) + (config.extraBottomBlockChance > 0.0f && rand.nextFloat() < config.extraBottomBlockChance ? 1 : 0);
                BlockPos immutable = position.func_185334_h();
                boolean canPlaceOnGround = this.placeGround(readerIn, config, replaceable, rand, position, depth);
                if (!canPlaceOnGround) continue;
                positions.add(immutable);
            }
        }
        return positions;
    }

    protected void generateVegetation(ChunkGenerator generator, ISeedReader readerIn, VegetationPatchFeatureConfig config, Random rand, Set<BlockPos> positions) {
        for (BlockPos pos : positions) {
            if (!(config.vegetationChance > 0.0f) || !(rand.nextFloat() < config.vegetationChance)) continue;
            this.generateVegetationFeature(readerIn, config, generator, rand, pos);
        }
    }

    protected boolean generateVegetationFeature(ISeedReader readerIn, VegetationPatchFeatureConfig config, ChunkGenerator generator, Random rand, BlockPos pos) {
        return config.vegetationFeature.get().func_242765_a(readerIn, generator, rand, pos.func_177972_a(config.surface.getDirection().func_176734_d()));
    }

    protected boolean placeGround(ISeedReader readerIn, VegetationPatchFeatureConfig config, Predicate<BlockState> replaceable, Random rand, BlockPos.Mutable pos, int depth) {
        for (int height = 0; height < depth; ++height) {
            BlockState blockState;
            BlockState groundState = config.groundState.func_225574_a_(rand, (BlockPos)pos);
            if (groundState.func_203425_a((blockState = readerIn.func_180495_p((BlockPos)pos)).func_177230_c())) continue;
            if (!replaceable.test(blockState)) {
                return height != 0;
            }
            readerIn.func_180501_a((BlockPos)pos, groundState, 2);
            pos.func_189536_c(config.surface.getDirection());
        }
        return true;
    }

    private Predicate<BlockState> getReplaceablePredicate(VegetationPatchFeatureConfig config) {
        ITag tag = BlockTags.func_199896_a().func_199910_a(config.replaceable);
        return tag == null ? state -> true : state -> state.func_235714_a_(tag);
    }
}

