/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.other;

import com.blackgear.cavesandcliffs.common.math.VerticalSurfaceType;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.common.util.feature.CaveSurface;
import com.blackgear.cavesandcliffs.common.world.gen.other.CaveSurfaceDecoratorConfig;
import com.blackgear.cavesandcliffs.mixin.core.accessor.WorldDecoratingHelperAccess;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.WorldDecoratingHelper;
import net.minecraft.world.gen.placement.Placement;

public class CaveSurfacePlacement
extends Placement<CaveSurfaceDecoratorConfig> {
    public CaveSurfacePlacement(Codec<CaveSurfaceDecoratorConfig> codec) {
        super(codec);
    }

    public static boolean isAirOrWater(BlockState state) {
        return state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j);
    }

    private static Predicate<BlockState> isValidPosition(boolean allowWater) {
        return allowWater ? CaveSurfacePlacement::isAirOrWater : AbstractBlock.AbstractBlockState::func_196958_f;
    }

    public Stream<BlockPos> getPositions(WorldDecoratingHelper helper, Random rand, CaveSurfaceDecoratorConfig config, BlockPos pos) {
        Optional<CaveSurface> surface = CaveSurface.create(((WorldDecoratingHelperAccess)helper).getField_242889_a(), pos, config.floorToCeilingSearchRange, CaveSurfacePlacement.isValidPosition(false), state -> state.func_185904_a().func_76220_a());
        if (!surface.isPresent()) {
            return Stream.of(new BlockPos[0]);
        }
        OptionalInt surfaceType = config.surface == VerticalSurfaceType.CEILING ? surface.get().getCeilingHeight() : surface.get().getFloorHeight();
        return !surfaceType.isPresent() ? Stream.of(new BlockPos[0]) : Stream.of(BlockUtils.withY(pos, surfaceType.getAsInt() - config.surface.getOffset()));
    }
}

