/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.other;

import com.blackgear.cavesandcliffs.common.math.intprovider.IntProvider;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBBlockStateProviderTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;

public class RandomizedIntBlockStateProvider
extends BlockStateProvider {
    public static final Codec<RandomizedIntBlockStateProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.field_236796_a_.fieldOf("source").forGetter(provider -> provider.source), (App)Codec.STRING.fieldOf("property").forGetter(provider -> provider.propertyName), (App)IntProvider.CODEC.fieldOf("values").forGetter(provider -> provider.values)).apply((Applicative)instance, RandomizedIntBlockStateProvider::new));
    private final BlockStateProvider source;
    private final String propertyName;
    private IntegerProperty property;
    private final IntProvider values;

    public RandomizedIntBlockStateProvider(BlockStateProvider source, IntegerProperty property, IntProvider values) {
        this.source = source;
        this.property = property;
        this.propertyName = property.func_177701_a();
        this.values = values;
        Collection allowedValues = property.func_177700_c();
        for (int value = values.getMin(); value <= values.getMax(); ++value) {
            if (allowedValues.contains(value)) continue;
            throw new IllegalArgumentException("Property value out of range: " + property.func_177701_a() + ": " + value);
        }
    }

    public RandomizedIntBlockStateProvider(BlockStateProvider source, String propertyName, IntProvider values) {
        this.source = source;
        this.propertyName = propertyName;
        this.values = values;
    }

    protected BlockStateProviderType<?> func_230377_a_() {
        return (BlockStateProviderType)CCBBlockStateProviderTypes.RANDOMIZED_INT_STATE_PROVIDER.get();
    }

    public BlockState func_225574_a_(Random randomIn, BlockPos blockPosIn) {
        BlockState state = this.source.func_225574_a_(randomIn, blockPosIn);
        if (this.property == null || !state.func_235901_b_((Property)this.property)) {
            this.property = this.getIntPropertyByName(state, this.propertyName);
        }
        return (BlockState)state.func_206870_a((Property)this.property, (Comparable)Integer.valueOf(this.values.get(randomIn)));
    }

    private IntegerProperty getIntPropertyByName(BlockState state, String propertyName) {
        Collection properties = state.func_235904_r_();
        Optional<IntegerProperty> property = properties.stream().filter(propertyIn -> propertyIn.func_177701_a().equals(propertyName)).filter(propertyIn -> propertyIn instanceof IntegerProperty).map(propertyIn -> (IntegerProperty)propertyIn).findAny();
        return property.orElseThrow(() -> new IllegalArgumentException("Illegal property: " + propertyName));
    }
}

