/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.surfacebuilder;

import com.blackgear.cavesandcliffs.common.world.gen.NoiseHelper;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.MaxMinNoiseMixer;
import net.minecraft.world.gen.surfacebuilders.DefaultSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public abstract class AbstractMountainSurfaceBuilder
extends DefaultSurfaceBuilder {
    private long seed;
    protected MaxMinNoiseMixer noiseSampler;

    public AbstractMountainSurfaceBuilder(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void func_205610_a_(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        BlockState middleState;
        BlockState topState;
        if (this.getSteepSlopeBlockConfig() != null && this.shouldPlaceSteepSlopeBlock(chunkIn, x, z, this.getSteepSlopeBlockConfig())) {
            topState = this.getSteepSlopeBlockConfig().getState();
            middleState = this.getSteepSlopeBlockConfig().getState();
        } else {
            topState = this.getTopMaterial(config, x, z);
            middleState = this.getUnderMaterial(config, x, z);
        }
        this.func_206967_a(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, topState, middleState, config.func_204110_c(), seaLevel);
    }

    protected BlockState getBlockFromNoise(double scale, int x, int z, BlockState outsideRangeState, BlockState insideRangeState, double noiseMin, double noiseMax) {
        double noise = this.noiseSampler.func_237211_a_((double)x * scale, 100.0, (double)z * scale);
        BlockState state = noise >= noiseMin && noise <= noiseMax ? insideRangeState : outsideRangeState;
        return state;
    }

    public void func_205548_a(long seed) {
        if (this.seed != seed) {
            SharedSeedRandom random = new SharedSeedRandom(seed);
            this.noiseSampler = NoiseHelper.createMultiNoise(random, -3, 1.0, 1.0, 1.0, 1.0);
        }
        this.seed = seed;
    }

    public boolean shouldPlaceSteepSlopeBlock(IChunk chunkIn, int x, int z, SteepSlopeBlockConfig config) {
        int spread;
        int minSpread;
        int maxSpread;
        int localX = x & 0xF;
        int localZ = z & 0xF;
        if (config.isNorth() || config.isSouth()) {
            int zMax = Math.max(localZ - 1, 0);
            int zMin = Math.min(localZ + 1, 15);
            maxSpread = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, localX, zMax);
            minSpread = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, localX, zMin);
            spread = maxSpread - minSpread;
            if (config.isSouth() && spread > 3) {
                return true;
            }
            if (config.isNorth() && -spread > 3) {
                return true;
            }
        }
        if (!config.isEast() && !config.isEast()) {
            return false;
        }
        int xMax = Math.max(localX - 1, 0);
        int xMin = Math.min(localX + 1, 15);
        maxSpread = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, xMax, localZ);
        minSpread = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, xMin, localZ);
        spread = maxSpread - minSpread;
        if (config.isEast() && spread > 3) {
            return true;
        }
        return config.isWest() && -spread > 3;
    }

    protected abstract SteepSlopeBlockConfig getSteepSlopeBlockConfig();

    protected abstract BlockState getTopMaterial(SurfaceBuilderConfig var1, int var2, int var3);

    protected abstract BlockState getUnderMaterial(SurfaceBuilderConfig var1, int var2, int var3);

    public static class SteepSlopeBlockConfig {
        private final BlockState state;
        private final boolean north;
        private final boolean south;
        private final boolean west;
        private final boolean east;

        public SteepSlopeBlockConfig(BlockState state, boolean north, boolean south, boolean west, boolean east) {
            this.state = state;
            this.north = north;
            this.south = south;
            this.west = west;
            this.east = east;
        }

        public BlockState getState() {
            return this.state;
        }

        public boolean isNorth() {
            return this.north;
        }

        public boolean isSouth() {
            return this.south;
        }

        public boolean isWest() {
            return this.west;
        }

        public boolean isEast() {
            return this.east;
        }
    }
}

