/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.other.conditions;

import com.blackgear.cavesandcliffs.core.other.Compat;
import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class QuarkRecipeCondition
implements ICondition {
    private final ResourceLocation location;
    private final String flag;

    public QuarkRecipeCondition(ResourceLocation location, String flag) {
        this.location = location;
        this.flag = flag;
    }

    public ResourceLocation getID() {
        return this.location;
    }

    public boolean test() {
        if (Compat.HAS_QUARK.booleanValue()) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "quark:flag");
            json.addProperty("flag", this.flag);
            return CraftingHelper.getCondition((JsonObject)json).test();
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<QuarkRecipeCondition> {
        private final ResourceLocation location = new ResourceLocation("cavesandcliffs", "quark_flag");

        public void write(JsonObject json, QuarkRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public QuarkRecipeCondition read(JsonObject json) {
            return new QuarkRecipeCondition(this.location, json.getAsJsonPrimitive("flag").getAsString());
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

