/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.data.common;

import com.blackgear.cavesandcliffs.core.CavesAndCliffs;
import com.blackgear.cavesandcliffs.data.common.loot.BlockLootTableGenerator;
import com.blackgear.cavesandcliffs.data.common.loot.EntityLootTableGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.ResourceLocation;

public class LootTableGenerator
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> lootTableGenerators = ImmutableList.of((Object)Pair.of(BlockLootTableGenerator::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(EntityLootTableGenerator::new, (Object)LootParameterSets.field_216263_d));

    public LootTableGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.dataGenerator = dataGeneratorIn;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.dataGenerator.func_200391_b();
        HashMap map = Maps.newHashMap();
        this.getTables().forEach(pair -> ((Consumer)((Supplier)pair.getFirst()).get()).accept((id, builder) -> {
            if (map.put(id, builder.func_216039_a((LootParameterSet)pair.getSecond()).func_216038_b()) != null) {
                throw new IllegalStateException("Duplicate loot table " + id);
            }
        }));
        map.forEach((resourceLocation, lootTable) -> {
            Path output = LootTableGenerator.getPath(path, resourceLocation);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)output);
            }
            catch (IOException exception) {
                CavesAndCliffs.LOGGER.error("Couldn't save loot table {}", (Object)output, (Object)exception);
            }
        });
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return this.lootTableGenerators;
    }

    private static Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.func_110624_b() + "/loot_tables/" + id.func_110623_a() + ".json");
    }
}

