/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.common.world.gen;

import com.blackgear.cavesandcliffs.common.blocks.ICauldron;
import com.blackgear.cavesandcliffs.core.registries.CCBPointOfInterestTypes;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerWorld.class})
public abstract class ServerWorldMixin
extends World {
    @Shadow
    public abstract PointOfInterestManager func_217443_B();

    @Shadow
    public abstract ServerWorld func_201672_e();

    protected ServerWorldMixin(ISpawnWorldInfo worldInfo, RegistryKey<World> dimension, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean isRemote, boolean isDebug, long seed) {
        super(worldInfo, dimension, dimensionType, profiler, isRemote, isDebug, seed);
    }

    @Inject(method={"tickEnvironment"}, at={@At(value="HEAD")})
    private void tickEnvironment(Chunk chunkIn, int randomTickSpeed, CallbackInfo ci) {
        ChunkPos chunkPos = chunkIn.func_76632_l();
        boolean isRaining = this.func_72896_J();
        int x = chunkPos.func_180334_c();
        int z = chunkPos.func_180333_d();
        if (this.field_73012_v.nextInt(16) == 0) {
            BlockPos height = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_217383_a(x, 0, z, 15));
            BlockPos pos = height.func_177977_b();
            if (isRaining) {
                BlockState state = this.func_180495_p(pos);
                Biome.RainType rainType = this.func_226691_t_(height).func_201851_b();
                if (state.func_177230_c() instanceof ICauldron) {
                    ((ICauldron)state.func_177230_c()).precipitationTick(state, this, pos, rainType);
                }
            }
        }
    }

    private Optional<BlockPos> getLightningRodPos(BlockPos pos) {
        Optional<BlockPos> position = this.getPosition(this.func_217443_B(), poiType -> poiType == CCBPointOfInterestTypes.LIGHTNING_ROD.get(), posIn -> posIn.func_177956_o() == this.func_201672_e().func_201676_a(Heightmap.Type.WORLD_SURFACE, posIn.func_177958_n(), posIn.func_177952_p()) - 1, pos, 128, PointOfInterestManager.Status.ANY);
        return position.map(posIn -> posIn.func_177981_b(1));
    }

    @Inject(method={"adjustPosToNearbyEntity(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/BlockPos;"}, at={@At(value="HEAD", shift=At.Shift.AFTER)}, cancellable=true)
    private void cba$adjustPosToNearbyEntity(BlockPos pos, CallbackInfoReturnable<BlockPos> cir) {
        BlockPos surface = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos);
        Optional<BlockPos> lightningRodPos = this.getLightningRodPos(surface);
        if (lightningRodPos.isPresent()) {
            cir.setReturnValue((Object)lightningRodPos.get());
        } else {
            AxisAlignedBB box = new AxisAlignedBB(surface, new BlockPos(surface.func_177958_n(), this.func_217301_I(), surface.func_177952_p())).func_186662_g(3.0);
            List entitiesInRadius = this.func_175647_a(LivingEntity.class, box, entity -> entity != null && entity.func_70089_S() && this.func_226660_f_(entity.func_233580_cy_()));
            if (!entitiesInRadius.isEmpty()) {
                cir.setReturnValue((Object)((LivingEntity)entitiesInRadius.get(this.field_73012_v.nextInt(entitiesInRadius.size()))).func_233580_cy_());
            } else {
                if (surface.func_177956_o() == -1) {
                    surface = surface.func_177981_b(2);
                }
                cir.setReturnValue((Object)surface);
            }
        }
    }

    public Optional<BlockPos> getPosition(PointOfInterestManager storage, Predicate<PointOfInterestType> predicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PointOfInterestManager.Status occupationStatus) {
        return storage.func_219146_b(predicate, pos, radius, occupationStatus).map(PointOfInterest::func_218261_f).filter(posPredicate).min(Comparator.comparingDouble(posIn -> posIn.func_177951_i((Vector3i)pos)));
    }
}

