/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomeapi.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntSupplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BiomeTintCacheExtension {
    private final ThreadLocal<LatestCacheInfo> latestChunkOnThread = ThreadLocal.withInitial(LatestCacheInfo::new);
    private final Long2ObjectLinkedOpenHashMap<CacheData> cache = new Long2ObjectLinkedOpenHashMap(256, 0.25f);

    public int getBiomeColor(BlockPos pos, IntSupplier source, ReentrantReadWriteLock lock) {
        int color;
        int chunkX = SectionPos.func_218159_a((int)pos.func_177958_n());
        int chunkZ = SectionPos.func_218159_a((int)pos.func_177952_p());
        LatestCacheInfo chunkOnThread = this.latestChunkOnThread.get();
        if (chunkOnThread.x != chunkX || chunkOnThread.z != chunkZ || chunkOnThread.cache == null) {
            chunkOnThread.x = chunkX;
            chunkOnThread.z = chunkZ;
            chunkOnThread.cache = this.findOrCreateChunkCache(lock, chunkX, chunkZ);
        }
        int[] layer = chunkOnThread.cache.getLayer(pos.func_177956_o());
        int xOffset = pos.func_177958_n() & 0xF;
        int zOffset = pos.func_177952_p() & 0xF;
        int index = zOffset << 4 | xOffset;
        int cachedColor = layer[index];
        if (cachedColor != -1) {
            return cachedColor;
        }
        layer[index] = color = source.getAsInt();
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateForChunk(ReentrantReadWriteLock lock, int chunkX, int chunkZ) {
        try {
            lock.writeLock().lock();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    long chunk = ChunkPos.func_77272_a((int)(chunkX + x), (int)(chunkZ + z));
                    this.cache.remove(chunk);
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public void invalidateAll(ReentrantReadWriteLock lock) {
        try {
            lock.writeLock().lock();
            this.cache.clear();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheData findOrCreateChunkCache(ReentrantReadWriteLock lock, int chunkX, int chunkZ) {
        CacheData cache;
        long chunk = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
        lock.readLock().lock();
        try {
            cache = (CacheData)this.cache.get(chunk);
            if (cache != null) {
                CacheData cacheData = cache;
                return cacheData;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            cache = (CacheData)this.cache.get(chunk);
            if (cache == null) {
                cache = new CacheData();
                if (this.cache.size() >= 256) {
                    this.cache.removeFirst();
                }
                this.cache.put(chunk, (Object)cache);
                CacheData cacheData = cache;
                return cacheData;
            }
            CacheData cacheData = cache;
            return cacheData;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LatestCacheInfo {
        public int x = Integer.MIN_VALUE;
        public int z = Integer.MIN_VALUE;
        @Nullable
        CacheData cache;

        LatestCacheInfo() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CacheData {
        private final Int2ObjectArrayMap<int[]> cache = new Int2ObjectArrayMap(16);
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private static final int BLOCKS_PER_LAYER = (int)MathHelper.func_233022_k_((float)16.0f);

        CacheData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getLayer(int height) {
            this.lock.readLock().lock();
            try {
                int[] layer = (int[])this.cache.get(height);
                if (layer != null) {
                    int[] nArray = layer;
                    return nArray;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            try {
                int[] nArray = (int[])this.cache.computeIfAbsent(height, i -> this.allocateLayer());
                return nArray;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private int[] allocateLayer() {
            int[] layer = new int[BLOCKS_PER_LAYER];
            Arrays.fill(layer, -1);
            return layer;
        }
    }
}

