/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomeapi.common.level.worldgen.biome.debug;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;

public class DebugBiomeBuilder {
    private static final Multimap<Supplier<Block>, Biome.Attributes> NOISE_PARAMETERS = HashMultimap.create();
    private final List<Pair<Biome.Attributes, Supplier<Block>>> parameters;
    private final PerlinNoiseGenerator weirdness;
    private final PerlinNoiseGenerator offset;
    private Optional<Biome.Attributes> climate;

    private DebugBiomeBuilder(long seed, List<Pair<Biome.Attributes, Supplier<Block>>> parameters) {
        this.parameters = parameters;
        this.weirdness = new PerlinNoiseGenerator(new SharedSeedRandom(seed), IntStream.rangeClosed(-8, 0));
        this.offset = new PerlinNoiseGenerator(new SharedSeedRandom(seed + 1L), IntStream.rangeClosed(-8, 0));
    }

    public static synchronized DebugBiomeBuilder create(long seed) {
        ArrayList entries = new ArrayList();
        NOISE_PARAMETERS.forEach((block, parameters) -> entries.add(Pair.of((Object)parameters, (Object)block)));
        return new DebugBiomeBuilder(seed, entries.isEmpty() ? Collections.emptyList() : entries);
    }

    public static synchronized void addDebugBlock(Supplier<Block> block, Biome.Attributes parameters) {
        if (block == null || parameters == null) {
            throw new IllegalArgumentException("DebugBiomeBuilder.addDebugBlock: Block and parameters must not be null");
        }
        NOISE_PARAMETERS.put(block, (Object)parameters);
    }

    public void updateClimate(Biome biome, int x, int z) {
        if (biome == null) {
            throw new IllegalArgumentException("DebugBiomeBuilder.updateClimate: Biome must not be null");
        }
        float temperature = DebugBiomeBuilder.clamp(biome.func_242445_k() * 2.0f - 1.0f);
        float humidity = DebugBiomeBuilder.clamp(biome.func_76727_i() * 2.0f - 1.0f);
        float altitude = DebugBiomeBuilder.clamp(biome.func_185355_j() * 1.25f);
        this.climate = Optional.of(new Biome.Attributes(temperature, humidity, altitude, (float)this.weirdness.func_215464_a((double)x, (double)z, false), (float)this.offset.func_215464_a((double)x, (double)z, false)));
    }

    public BlockState getNoiseBlock(Biome biome, int x, int z) {
        this.updateClimate(biome, x, z);
        return this.parameters.stream().filter(pair -> this.climate.isPresent()).min(Comparator.comparing(pair -> Float.valueOf(((Biome.Attributes)pair.getFirst()).func_235110_a_(this.climate.get())))).map(Pair::getSecond).map(Supplier::get).orElse(Blocks.field_196858_iR).func_176223_P();
    }

    private static float clamp(float attribute) {
        return (float)MathHelper.func_151237_a((double)attribute, (double)-1.0, (double)1.0);
    }

    public void doFill(IChunk chunk, WorldGenRegion region) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int minBlockX = chunkPos.func_180334_c();
        int minBlockZ = chunkPos.func_180333_d();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int localX = 0; localX < 16; ++localX) {
            int x = localX + minBlockX;
            for (int localZ = 0; localZ < 16; ++localZ) {
                int z = localZ + minBlockZ;
                int y = chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, localX, localZ) + 1;
                Biome biome = region.func_226691_t_((BlockPos)mutable.func_181079_c(x, 128, z));
                mutable.func_181079_c(x, y, z);
                chunk.func_177436_a((BlockPos)mutable, this.getNoiseBlock(biome, x, z), false);
            }
        }
    }
}

