/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomeapi.core;

import com.blackgear.platform.core.util.config.ConfigBuilder;
import java.util.Collections;
import java.util.List;

public class CommonConfig {
    public final ConfigBuilder.ConfigValue<List<? extends String>> whitelistedDimensions;
    public final ConfigBuilder.ConfigValue<Boolean> useExperimentalBiomeSource;
    public final ConfigBuilder.ConfigValue<Boolean> biomeDebugMode;

    public CommonConfig(ConfigBuilder builder) {
        builder.push("Worldgen");
        this.whitelistedDimensions = builder.comment("Dimension whitelist of where underground biomes should generate.").defineList("whitelistedDimensions", Collections.singletonList("minecraft:overworld"), entry -> entry instanceof String);
        this.useExperimentalBiomeSource = builder.comment("Legacy biome source uses multiple noise values for biome placement.\nExperimental biome source is based on the surface biome values in addition to noise.").define("useExperimentalBiomeSource", false);
        builder.pop();
        builder.push("Debug");
        this.biomeDebugMode = builder.comment("Toggle Biome Debug Mode, a system to visualize cave biome placement through the world.\nThis does not represent the biome placement accurately, but it's useful for debugging.\nThis feature is focused for the Experimental biome source.").define("biomeDebugMode", false);
        builder.pop();
    }
}

