/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomeapi.core.compat;

import com.blackgear.cavebiomeapi.common.level.worldgen.biome.CaveBiomeBuilder;
import com.blackgear.cavebiomeapi.common.level.worldgen.biome.CaveBiomeHolder;
import com.blackgear.cavebiomeapi.core.Utilities;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;

public class NatureCompassHook {
    private boolean isTracking = false;
    private BiomeProvider undergroundBiomeSource = null;

    public void setupCompatibility(World level, Biome biome) {
        if (!(level instanceof ServerWorld) || !CaveBiomeBuilder.isUndergroundBiome(Utilities.registryName(biome))) {
            return;
        }
        BiomeProvider parent = ((ServerWorld)level).func_72863_F().func_201711_g().func_202090_b();
        CaveBiomeHolder holder = (CaveBiomeHolder)parent;
        holder.getCaveBiomeSource().ifPresent(source -> {
            this.undergroundBiomeSource = source.getUndergroundBiomeSource();
            this.isTracking = true;
        });
    }

    public Biome getUndergroundBiome(World level, BiomeManager manager, BlockPos pos) {
        Biome biome;
        if (!this.isTracking) {
            return manager.func_226836_a_(pos);
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        IChunk chunk = level.func_217353_a(x >> 2, z >> 2, ChunkStatus.field_222608_d, false);
        if (chunk == null && !Utilities.compare((RegistryKey<Biome>)Biomes.field_185440_P, biome = this.undergroundBiomeSource.func_225526_b_(x >> 2, y >> 2, z >> 2))) {
            return biome;
        }
        return manager.func_226836_a_(pos);
    }
}

