/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomeapi.core.mixin.common;

import com.blackgear.cavebiomeapi.common.level.worldgen.biome.CaveBiomeHolder;
import com.blackgear.cavebiomeapi.common.level.worldgen.biome.debug.DebugBiomeBuilder;
import com.blackgear.cavebiomeapi.core.CaveBiomeAPI;
import java.util.List;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkStatus.class})
public class ChunkStatusMixin {
    @Inject(method={"method_16564"}, at={@At(value="TAIL")})
    private static void addDebugSurface(ServerWorld level, ChunkGenerator generator, List<IChunk> surroundingChunks, IChunk chunk, CallbackInfo ci) {
        if (CaveBiomeAPI.isDebugMode()) {
            WorldGenRegion region = new WorldGenRegion(level, surroundingChunks);
            DebugBiomeBuilder.create(region.func_72905_C()).doFill(chunk, region);
        }
    }

    @Redirect(method={"method_12151"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ChunkGenerator;applyBiomeDecoration(Lnet/minecraft/server/level/WorldGenRegion;Lnet/minecraft/world/level/StructureFeatureManager;)V"))
    private static void addUndergroundFeatures(ChunkGenerator generator, WorldGenRegion region, StructureManager structureManager) {
        generator.func_230351_a_(region, structureManager);
        CaveBiomeHolder holder = (CaveBiomeHolder)generator.func_202090_b();
        holder.getCaveBiomeSource().ifPresent(source -> source.applyUndergroundBiomeDecoration(generator, region));
    }

    @Inject(method={"method_17033"}, at={@At(value="TAIL")})
    private static void addUndergroundBiomes(ServerWorld level, ChunkGenerator generator, List<IChunk> surroundingChunks, IChunk chunk, CallbackInfo ci) {
        CaveBiomeHolder holder = (CaveBiomeHolder)generator.func_202090_b();
        holder.getCaveBiomeSource().ifPresent(source -> source.createUndergroundBiomes(generator, (Registry<Biome>)level.func_241828_r().func_243612_b(Registry.field_239720_u_), chunk));
    }
}

