/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wenxin2.marioverse.client.models.entities.KoopaShellModel;
import com.wenxin2.marioverse.entities.GoldKoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class KoopaShellRenderer
extends GeoEntityRenderer<KoopaShellEntity> {
    private static final String HELMET = "armorHead";
    private static final String CHEST = "armorBody";
    private static final String LEFT_ARM = "armorLeftArm";
    private static final String RIGHT_ARM = "armorRightArm";
    private static final String LEFT_LEG = "armorLeftLeg";
    private static final String RIGHT_LEG = "armorRightLeg";
    private static final String LEFT_BOOT = "armorLeftBoot";
    private static final String RIGHT_BOOT = "armorRightBoot";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;

    public KoopaShellRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new KoopaShellModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<KoopaShellEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, KoopaShellEntity animatable) {
                return switch (bone.getName()) {
                    case KoopaShellRenderer.HELMET -> this.helmetStack;
                    case KoopaShellRenderer.CHEST, KoopaShellRenderer.LEFT_ARM, KoopaShellRenderer.RIGHT_ARM -> this.chestplateStack;
                    case KoopaShellRenderer.LEFT_LEG, KoopaShellRenderer.RIGHT_LEG -> this.leggingsStack;
                    case KoopaShellRenderer.LEFT_BOOT, KoopaShellRenderer.RIGHT_BOOT -> this.bootsStack;
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, KoopaShellEntity animatable) {
                return switch (bone.getName()) {
                    case KoopaShellRenderer.HELMET -> EquipmentSlot.HEAD;
                    case KoopaShellRenderer.CHEST -> EquipmentSlot.CHEST;
                    case KoopaShellRenderer.RIGHT_ARM -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case KoopaShellRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case KoopaShellRenderer.LEFT_LEG, KoopaShellRenderer.RIGHT_LEG -> EquipmentSlot.LEGS;
                    case KoopaShellRenderer.LEFT_BOOT, KoopaShellRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, KoopaShellEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case KoopaShellRenderer.HELMET -> baseModel.head;
                    case KoopaShellRenderer.CHEST -> baseModel.body;
                    case KoopaShellRenderer.LEFT_ARM -> baseModel.leftArm;
                    case KoopaShellRenderer.RIGHT_ARM -> baseModel.rightArm;
                    case KoopaShellRenderer.LEFT_LEG, KoopaShellRenderer.LEFT_BOOT -> baseModel.leftLeg;
                    case KoopaShellRenderer.RIGHT_LEG, KoopaShellRenderer.RIGHT_BOOT -> baseModel.rightLeg;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.0f, 1.0f, 1.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
                poseStack.translate(0.0f, 0.1f, 0.75f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<KoopaShellEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, KoopaShellEntity animatable) {
                return switch (bone.getName()) {
                    case KoopaShellRenderer.HELMET -> {
                        BlockItem blockItem;
                        Item var6_5;
                        if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (var6_5 = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)var6_5).getBlock() instanceof SkullBlock)) {
                            yield animatable.getItemBySlot(EquipmentSlot.HEAD);
                        }
                        yield ItemStack.EMPTY;
                    }
                    case KoopaShellRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield KoopaShellRenderer.this.mainHandItem;
                        }
                        yield KoopaShellRenderer.this.offhandItem;
                    }
                    case KoopaShellRenderer.RIGHT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield KoopaShellRenderer.this.offhandItem;
                        }
                        yield KoopaShellRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, KoopaShellEntity animatable) {
                return switch (bone.getName()) {
                    case KoopaShellRenderer.HELMET -> ItemDisplayContext.HEAD;
                    case KoopaShellRenderer.LEFT_ARM, KoopaShellRenderer.RIGHT_ARM -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, KoopaShellEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == KoopaShellRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, 0.125, -0.5);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, -0.05);
                    }
                } else if (stack == KoopaShellRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, 0.125, -0.5);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, 0.45);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                } else if (stack.getItem() instanceof BlockItem) {
                    poseStack.scale(0.63f, 0.63f, 0.63f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
                    poseStack.translate(0.0f, 0.6f, 0.1f);
                } else {
                    poseStack.scale(0.6f, 0.6f, 0.6f);
                    poseStack.translate(0.0f, 0.5f, 0.0f);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected float getDeathMaxRotation(KoopaShellEntity animatable) {
        return 0.0f;
    }

    public void preRender(PoseStack poseStack, KoopaShellEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }

    public void render(KoopaShellEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        if (Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            KoopaShellRenderer.renderBounceCollisionBox(entity, poseStack, vertexConsumer);
        }
    }

    public void renderFinal(PoseStack poseStack, KoopaShellEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        if (animatable instanceof GoldKoopaShellEntity) {
            this.model.getBone("shell_particles").ifPresent(bone -> {
                Vector3d bonePos = bone.getWorldPosition();
                if (animatable.tickCount % 80 == 0) {
                    double randomX = (Math.random() - 0.5) * (double)bone.getScaleX();
                    double randomY = (Math.random() - 0.5) * (double)bone.getScaleY();
                    double randomZ = (Math.random() - 0.5) * (double)bone.getScaleZ();
                    animatable.getCommandSenderWorld().addParticle((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), bonePos.x() + randomX, bonePos.y() + randomY, bonePos.z() + randomZ, 0.0, 0.0, 0.0);
                }
            });
        }
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, color);
    }

    private static void renderBounceCollisionBox(KoopaShellEntity entity, PoseStack poseStack, VertexConsumer vertexConsumer) {
        AABB bb = entity.getBoundingBox();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            AABB movedBox = bb.move((double)dir.getStepX() * 0.1, 0.0, (double)dir.getStepZ() * 0.1);
            AABB posBox = movedBox.move(-entity.getX(), -entity.getY(), -entity.getZ());
            poseStack.pushPose();
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)posBox, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            poseStack.popPose();
        }
    }
}

