/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.datagen;

import com.wenxin2.marioverse.data.BlockFamilyExtended;
import com.wenxin2.marioverse.data.RecipeUtils;
import com.wenxin2.marioverse.registries.BlockFamilyRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;

public class RecipeGen
extends RecipeUtils {
    public RecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void generateForEnabledBlockFamilies(RecipeOutput output, FeatureFlagSet set) {
        BlockFamilyRegistry.getAllExtendedFamilies().filter(BlockFamilyExtended::shouldGenerateRecipe).forEach(recipes -> RecipeGen.generateRecipes(output, recipes, set));
    }

    protected void buildRecipes(RecipeOutput output) {
        Item woolItem;
        TagKey<Item> dyeItemTag;
        DyeColor dyeColor;
        this.generateForEnabledBlockFamilies(output, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.smeltingRecipe(200, 0.1f, (ItemLike)BlockRegistry.POLISHED_DEEP_FUNGAL_STONE, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.DEEP_FUNGAL_STONE, output);
        this.smeltingRecipe(200, 0.1f, (ItemLike)BlockRegistry.POLISHED_FUNGAL_STONE, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.FUNGAL_STONE, output);
        RecipeGen.waxRecipes((RecipeOutput)output, (FeatureFlagSet)FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.smithingTemplateRecipe(2, (ItemLike)ItemRegistry.MARIO_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)ItemRegistry.MARIO_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)Blocks.RED_WOOL, (TagKey<Item>)Tags.Items.LEATHERS, output);
        this.smithingTemplateRecipe(2, (ItemLike)ItemRegistry.LUIGI_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)ItemRegistry.LUIGI_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)Blocks.LIME_WOOL, (TagKey<Item>)Tags.Items.LEATHERS, output);
        this.smithingTemplateRecipe(2, (ItemLike)ItemRegistry.PEACH_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)ItemRegistry.PEACH_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)Blocks.PINK_WOOL, (TagKey<Item>)Tags.Items.LEATHERS, output);
        this.smithingTemplateRecipe(2, (ItemLike)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)Blocks.MAGMA_BLOCK, (TagKey<Item>)Tags.Items.LEATHERS, output);
        this.smithingTemplateRecipe(2, (ItemLike)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), (ItemLike)Blocks.ICE, (TagKey<Item>)Tags.Items.LEATHERS, output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_HAT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.MARIO_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_HELMET, Blocks.RED_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_SHIRT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.MARIO_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_CHESTPLATE, Blocks.RED_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_PANTS.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.MARIO_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_LEGGINGS, Blocks.BLUE_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_SHOES.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.MARIO_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_BOOTS, Blocks.BROWN_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_FIRE_HAT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.MARIO_HATS, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_FIRE_SHIRT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.MARIO_SHIRTS, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_FIRE_PANTS.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.MARIO_PANTS, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_FIRE_SHOES.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.MARIO_SHOES, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_ICE_HAT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.MARIO_HATS, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_ICE_SHIRT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.MARIO_SHIRTS, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_ICE_PANTS.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.MARIO_PANTS, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.MARIO_ICE_SHOES.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.MARIO_SHOES, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_HAT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.LUIGI_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_HELMET, Blocks.LIME_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_SHIRT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.LUIGI_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_CHESTPLATE, Blocks.LIME_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_PANTS.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.LUIGI_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_LEGGINGS, Blocks.BLUE_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_SHOES.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.LUIGI_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_BOOTS, Blocks.BROWN_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_FIRE_HAT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.LUIGI_HATS, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_FIRE_SHIRT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.LUIGI_SHIRTS, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_FIRE_PANTS.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.LUIGI_PANTS, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_FIRE_SHOES.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.LUIGI_SHOES, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_ICE_HAT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.LUIGI_HATS, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_ICE_SHIRT.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.LUIGI_SHIRTS, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_ICE_PANTS.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.LUIGI_PANTS, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.LUIGI_ICE_SHOES.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.LUIGI_SHOES, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_CROWN.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.PEACH_COSTUME_SMITHING_TEMPLATE.get(), Items.GOLDEN_HELMET, (TagKey<Item>)Tags.Items.GEMS, output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_BODICE.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.PEACH_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_CHESTPLATE, Blocks.PINK_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_DRESS.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.PEACH_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_LEGGINGS, Blocks.PINK_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_SHOES.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.PEACH_COSTUME_SMITHING_TEMPLATE.get(), Items.LEATHER_BOOTS, Blocks.PINK_WOOL.asItem(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_FIRE_BODICE.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.PEACH_SHIRTS, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_FIRE_DRESS.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.PEACH_PANTS, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_FIRE_SHOES.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.FIRE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.PEACH_SHOES, (Item)ItemRegistry.FIRE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_ICE_BODICE.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.PEACH_SHIRTS, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_ICE_DRESS.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.PEACH_PANTS, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        RecipeGen.costumeSmithing((Item)ItemRegistry.PEACH_ICE_SHOES.get(), RecipeCategory.COMBAT, (Item)ItemRegistry.ICE_COSTUME_SMITHING_TEMPLATE.get(), TagRegistry.PEACH_SHOES, (Item)ItemRegistry.ICE_FLOWER.get(), output);
        this.checkeredRecipe(4, "spike_panels", (ItemLike)BlockRegistry.CALCITE_CHECKERED_TILES, BlockRegistry.POLISHED_CALCITE.get(DyeColor.WHITE), BlockRegistry.POLISHED_CALCITE.get(DyeColor.BLACK), false, output);
        this.classicCheckpointFlagRecipe(1, (ItemLike)BlockRegistry.CLASSIC_CHECKPOINT_FLAG, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (ItemLike)ItemRegistry.SUPER_MUSHROOM, (ItemLike)Items.WHITE_WOOL, (ItemLike)Blocks.SMOOTH_STONE_SLAB, output);
        this.classicGoalPoleRecipe(4, (ItemLike)BlockRegistry.CLASSIC_GOAL_POLE, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (TagKey<Item>)Tags.Items.DYES_LIME, (ItemLike)Items.WHITE_WOOL, (ItemLike)Items.BAMBOO, output);
        this.coinRecipe(4, (ItemLike)BlockRegistry.COIN, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (TagKey<Item>)Tags.Items.NUGGETS_GOLD, output);
        this.dyeItemRecipe(1, "calcite_from_dye", (ItemLike)Blocks.CALCITE, RecipeCategory.BUILDING_BLOCKS, Tags.Items.DYES_WHITE, TagRegistry.CALCITE_ITEMS, output);
        RecipeGen.oneToOneConversionRecipe((RecipeOutput)output, ItemRegistry.WRENCH, ItemRegistry.WRENCH, (String)("marioverse:" + RecipeGen.getSimpleRecipeName(ItemRegistry.WRENCH)));
        this.plusRecipe(1, "brick_pedestals", (ItemLike)BlockRegistry.RED_NETHER_BRICK_PEDESTAL, Items.NETHER_WART, BlockRegistry.NETHER_BRICK_PEDESTAL, true, output);
        this.plusRecipe(1, "invisible_question_blocks", (ItemLike)BlockRegistry.INVISIBLE_RED_NETHER_QUESTION_BRICKS, Items.NETHER_WART, BlockRegistry.INVISIBLE_NETHER_QUESTION_BRICKS, true, output);
        this.plusRecipe(1, "question_blocks", (ItemLike)BlockRegistry.RED_NETHER_QUESTION_BRICKS, Items.NETHER_WART, BlockRegistry.NETHER_QUESTION_BRICKS, true, output);
        this.plusRecipe(1, "smashable_blocks", (ItemLike)BlockRegistry.SMASHABLE_RED_NETHER_BRICKS, Items.NETHER_WART, BlockRegistry.SMASHABLE_NETHER_BRICKS, true, output);
        this.plusRecipe(1, "spikes", (ItemLike)BlockRegistry.IRON_SPIKE, Tags.Items.NUGGETS_IRON, Tags.Items.INGOTS_IRON, false, output);
        this.plusRecipe(1, "storage_bricks", (ItemLike)BlockRegistry.STORAGE_RED_NETHER_BRICKS, Items.NETHER_WART, BlockRegistry.STORAGE_NETHER_BRICKS, true, output);
        this.plusRecipe(4, "glow_block", (ItemLike)BlockRegistry.GLOW_BLOCK, Tags.Items.GLASS_BLOCKS_COLORLESS, Blocks.GLOWSTONE, false, output);
        this.spikePanelRecipe(3, "spike_panels", (ItemLike)BlockRegistry.SPIKE_PANEL, Tags.Items.NUGGETS_IRON, Tags.Items.INGOTS_IRON, Blocks.POLISHED_DEEPSLATE_SLAB, false, output);
        RecipeGen.threeByThreePacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.MISC, BlockRegistry.STAR_COIN, BlockRegistry.COIN);
        this.twoByOneRecipe(1, "splunkin_o_lantern", (ItemLike)BlockRegistry.SPLUNKIN_O_LANTERN, RecipeCategory.BUILDING_BLOCKS, BlockRegistry.SPLUNKIN_CARVED_PUMPKIN, Blocks.TORCH, false, output);
        this.twoItemRecipe(1, "brick_pedestals", (ItemLike)BlockRegistry.MOSSY_STONE_BRICK_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.STONE_BRICK_PEDESTAL, (ItemLike)Blocks.MOSS_BLOCK, output);
        this.twoItemRecipe(1, "brick_pedestals", (ItemLike)BlockRegistry.MOSSY_STONE_BRICK_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.STONE_BRICK_PEDESTAL, (ItemLike)Blocks.VINE, output);
        this.twoItemRecipe(1, "invisible_question_blocks", (ItemLike)BlockRegistry.INVISIBLE_MOSSY_STONE_QUESTION_BRICKS, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.INVISIBLE_STONE_QUESTION_BRICKS, (ItemLike)Blocks.MOSS_BLOCK, output);
        this.twoItemRecipe(1, "invisible_question_blocks", (ItemLike)BlockRegistry.INVISIBLE_MOSSY_STONE_QUESTION_BRICKS, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.INVISIBLE_STONE_QUESTION_BRICKS, (ItemLike)Blocks.VINE, output);
        this.twoItemRecipe(1, "question_blocks", (ItemLike)BlockRegistry.MOSSY_STONE_QUESTION_BRICKS, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.STONE_QUESTION_BRICKS, (ItemLike)Blocks.MOSS_BLOCK, output);
        this.twoItemRecipe(1, "question_blocks", (ItemLike)BlockRegistry.MOSSY_STONE_QUESTION_BRICKS, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.STONE_QUESTION_BRICKS, (ItemLike)Blocks.VINE, output);
        this.twoItemRecipe(1, "smashable_blocks", (ItemLike)BlockRegistry.SMASHABLE_MOSSY_STONE_BRICKS, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.SMASHABLE_STONE_BRICKS, (ItemLike)Blocks.MOSS_BLOCK, output);
        this.twoItemRecipe(1, "smashable_blocks", (ItemLike)BlockRegistry.SMASHABLE_MOSSY_STONE_BRICKS, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.SMASHABLE_STONE_BRICKS, (ItemLike)Blocks.VINE, output);
        this.twoItemRecipe(1, "storage_bricks", (ItemLike)BlockRegistry.STORAGE_MOSSY_STONE_BRICKS, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.STORAGE_STONE_BRICKS, (ItemLike)Blocks.MOSS_BLOCK, output);
        this.twoItemRecipe(1, "storage_bricks", (ItemLike)BlockRegistry.STORAGE_MOSSY_STONE_BRICKS, RecipeCategory.BUILDING_BLOCKS, (ItemLike)BlockRegistry.STORAGE_STONE_BRICKS, (ItemLike)Blocks.VINE, output);
        this.twoItemTagRecipe(1, "warp_pipes", "_from_glass", (ItemLike)BlockRegistry.CLEAR_WARP_PIPE, RecipeCategory.BUILDING_BLOCKS, TagRegistry.DYEABLE_WARP_PIPE_ITEMS, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_COLORLESS, output);
        this.warpDisruptorRecipe(1, (ItemLike)ItemRegistry.WARP_DISRUPTOR, (ItemLike)Items.ENDER_EYE, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (TagKey<Item>)Tags.Items.RODS_WOODEN, output);
        this.warpPipeRecipe(4, (ItemLike)BlockRegistry.CLEAR_WARP_PIPE, (TagKey<Item>)Tags.Items.INGOTS_COPPER, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_COLORLESS, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (TagKey<Item>)Tags.Items.ENDER_PEARLS, output);
        this.wrenchRecipe(1, (ItemLike)ItemRegistry.WRENCH, (TagKey<Item>)Tags.Items.INGOTS_IRON, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.INVISIBLE_WAXED_COPPER_QUESTION_BLOCK, (ItemLike)BlockRegistry.INVISIBLE_COPPER_QUESTION_BLOCK, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.INVISIBLE_WAXED_EXPOSED_COPPER_QUESTION_BLOCK, (ItemLike)BlockRegistry.INVISIBLE_EXPOSED_COPPER_QUESTION_BLOCK, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.INVISIBLE_WAXED_OXIDIZED_COPPER_QUESTION_BLOCK, (ItemLike)BlockRegistry.INVISIBLE_OXIDIZED_COPPER_QUESTION_BLOCK, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.INVISIBLE_WAXED_WEATHERED_COPPER_QUESTION_BLOCK, (ItemLike)BlockRegistry.INVISIBLE_WEATHERED_COPPER_QUESTION_BLOCK, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.SMASHABLE_WAXED_CUT_COPPER, (ItemLike)BlockRegistry.SMASHABLE_CUT_COPPER, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.SMASHABLE_WAXED_EXPOSED_CUT_COPPER, (ItemLike)BlockRegistry.SMASHABLE_EXPOSED_CUT_COPPER, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.SMASHABLE_WAXED_OXIDIZED_CUT_COPPER, (ItemLike)BlockRegistry.SMASHABLE_OXIDIZED_CUT_COPPER, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.SMASHABLE_WAXED_WEATHERED_CUT_COPPER, (ItemLike)BlockRegistry.SMASHABLE_WEATHERED_CUT_COPPER, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.STORAGE_WAXED_CUT_COPPER, (ItemLike)BlockRegistry.STORAGE_CUT_COPPER, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.STORAGE_WAXED_EXPOSED_CUT_COPPER, (ItemLike)BlockRegistry.STORAGE_EXPOSED_CUT_COPPER, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.STORAGE_WAXED_OXIDIZED_CUT_COPPER, (ItemLike)BlockRegistry.STORAGE_OXIDIZED_CUT_COPPER, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.STORAGE_WAXED_WEATHERED_CUT_COPPER, (ItemLike)BlockRegistry.STORAGE_WEATHERED_CUT_COPPER, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.WAXED_COPPER_QUESTION_BLOCK, (ItemLike)BlockRegistry.COPPER_QUESTION_BLOCK, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.WAXED_CUT_COPPER_PEDESTAL, (ItemLike)BlockRegistry.CUT_COPPER_PEDESTAL, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.WAXED_EXPOSED_COPPER_QUESTION_BLOCK, (ItemLike)BlockRegistry.EXPOSED_COPPER_QUESTION_BLOCK, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.WAXED_EXPOSED_CUT_COPPER_PEDESTAL, (ItemLike)BlockRegistry.EXPOSED_CUT_COPPER_PEDESTAL, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.WAXED_OXIDIZED_COPPER_QUESTION_BLOCK, (ItemLike)BlockRegistry.OXIDIZED_COPPER_QUESTION_BLOCK, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.WAXED_OXIDIZED_CUT_COPPER_PEDESTAL, (ItemLike)BlockRegistry.OXIDIZED_CUT_COPPER_PEDESTAL, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.WAXED_WEATHERED_COPPER_QUESTION_BLOCK, (ItemLike)BlockRegistry.WEATHERED_COPPER_QUESTION_BLOCK, (ItemLike)Items.HONEYCOMB, output);
        this.waxedBlockRecipe(1, (ItemLike)BlockRegistry.WAXED_WEATHERED_CUT_COPPER_PEDESTAL, (ItemLike)BlockRegistry.WEATHERED_CUT_COPPER_PEDESTAL, (ItemLike)Items.HONEYCOMB, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.EXPOSED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.EXPOSED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.OXIDIZED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OXIDIZED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.WAXED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.WAXED_EXPOSED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_EXPOSED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.WAXED_OXIDIZED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_OXIDIZED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.WAXED_WEATHERED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_WEATHERED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.WEATHERED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WEATHERED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.SMASHABLE_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.SMASHABLE_EXPOSED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.EXPOSED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.SMASHABLE_OXIDIZED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OXIDIZED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.SMASHABLE_WAXED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.SMASHABLE_WAXED_EXPOSED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_EXPOSED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.SMASHABLE_WAXED_OXIDIZED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_OXIDIZED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.SMASHABLE_WAXED_WEATHERED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_WEATHERED_CUT_COPPER, output);
        this.stonecutting(1, (ItemLike)BlockRegistry.SMASHABLE_WEATHERED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WEATHERED_CUT_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COPPER_BLOCK, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.EXPOSED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.EXPOSED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.OXIDIZED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OXIDIZED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.WAXED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_COPPER_BLOCK, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.WAXED_EXPOSED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_EXPOSED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.WAXED_OXIDIZED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_OXIDIZED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.WAXED_WEATHERED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_WEATHERED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.WEATHERED_CUT_COPPER_PEDESTAL, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WEATHERED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.SMASHABLE_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COPPER_BLOCK, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.SMASHABLE_EXPOSED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.EXPOSED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.SMASHABLE_OXIDIZED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OXIDIZED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.SMASHABLE_WAXED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_COPPER_BLOCK, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.SMASHABLE_WAXED_EXPOSED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_EXPOSED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.SMASHABLE_WAXED_OXIDIZED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_OXIDIZED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.SMASHABLE_WAXED_WEATHERED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WAXED_WEATHERED_COPPER, output);
        this.stonecuttingFromBase(4, (ItemLike)BlockRegistry.SMASHABLE_WEATHERED_CUT_COPPER, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.WEATHERED_COPPER, output);
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.AMETHYST, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.AMETHYST_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_AMETHYST, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.AMETHYST_BRICKS, (ItemLike)BlockRegistry.POLISHED_AMETHYST, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.AMETHYST_BRICKS, (ItemLike)Blocks.AMETHYST_BLOCK, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_AMETHYST, (ItemLike)Blocks.AMETHYST_BLOCK, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.CALCITE_CHECKERED_TILES, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.LIGHT_GRAY_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.GRAY_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.BLACK_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.BROWN_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.RED_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.ORANGE_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.YELLOW_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.LIME_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.GREEN_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.CYAN_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.LIGHT_BLUE_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.BLUE_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.PURPLE_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.MAGENTA_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.PINK_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.LIGHT_GRAY_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.GRAY_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.BLACK_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.BROWN_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.RED_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.ORANGE_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.YELLOW_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.LIME_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.GREEN_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.CYAN_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.LIGHT_BLUE_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.BLUE_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.PURPLE_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.MAGENTA_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.PINK_CALCITE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_LIGHT_GRAY_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_GRAY_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_BLACK_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_BROWN_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_RED_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_ORANGE_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_YELLOW_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_LIME_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_GREEN_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_CYAN_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_LIGHT_BLUE_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_BLUE_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_PURPLE_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_MAGENTA_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_PINK_CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.CALCITE_BRICKS, (ItemLike)Blocks.CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.LIGHT_GRAY_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.LIGHT_GRAY), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.GRAY_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.GRAY), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.BLACK_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.BLACK), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.BROWN_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.BROWN), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.RED_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.RED), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.ORANGE_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.ORANGE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.YELLOW_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.YELLOW), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.LIME_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.LIME), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.GREEN_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.GREEN), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.CYAN_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.CYAN), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.LIGHT_BLUE_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.LIGHT_BLUE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.BLUE_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.BLUE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.PURPLE_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.PURPLE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.MAGENTA_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.MAGENTA), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.PINK_CALCITE_BRICKS, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.PINK), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.WHITE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.LIGHT_GRAY_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.LIGHT_GRAY), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.GRAY_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.GRAY), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.BLACK_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.BLACK), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.BROWN_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.BROWN), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.RED_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.RED), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.ORANGE_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.ORANGE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.YELLOW_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.YELLOW), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.LIME_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.LIME), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.GREEN_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.GREEN), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.CYAN_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.CYAN), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.LIGHT_BLUE_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.LIGHT_BLUE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.BLUE_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.BLUE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.PURPLE_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.PURPLE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.MAGENTA_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.MAGENTA), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.PINK_CALCITE_BRICKS, (ItemLike)BlockRegistry.POLISHED_CALCITE.get(DyeColor.PINK), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_CALCITE, (ItemLike)Blocks.CALCITE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_LIGHT_GRAY_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.LIGHT_GRAY), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_GRAY_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.GRAY), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_BLACK_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.BLACK), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_BROWN_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.BROWN), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_RED_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.RED), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_ORANGE_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.ORANGE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_YELLOW_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.YELLOW), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_LIME_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.LIME), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_GREEN_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.GREEN), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_CYAN_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.CYAN), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_LIGHT_BLUE_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.LIGHT_BLUE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_BLUE_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.BLUE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_PURPLE_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.PURPLE), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_MAGENTA_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.MAGENTA), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_PINK_CALCITE, (ItemLike)BlockRegistry.CALCITE.get(DyeColor.PINK), FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.DEEP_FUNGAL_STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.DEEP_FUNGAL_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.DEEP_FUNGAL_BRICKS, (ItemLike)BlockRegistry.DEEP_FUNGAL_STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.FUNGAL_STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.FUNGAL_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.FUNGAL_BRICKS, (ItemLike)BlockRegistry.FUNGAL_STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_FUNGAL_STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_FUNGAL_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_FUNGAL_BRICKS, (ItemLike)BlockRegistry.POLISHED_FUNGAL_STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_BRICKS, (ItemLike)BlockRegistry.POLISHED_DEEP_FUNGAL_STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.CUT_SANDSTONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.CUT_SANDSTONE, (ItemLike)Blocks.SANDSTONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.SANDSTONE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.SANDSTONE_BRICKS, (ItemLike)Blocks.SANDSTONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.CUT_RED_SANDSTONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.CUT_RED_SANDSTONE, (ItemLike)Blocks.RED_SANDSTONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.RED_SANDSTONE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.RED_SANDSTONE_BRICKS, (ItemLike)Blocks.RED_SANDSTONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.BLACKSTONE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.BLACKSTONE_BRICKS, (ItemLike)Blocks.BLACKSTONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.BLACKSTONE_BRICKS, (ItemLike)Blocks.POLISHED_BLACKSTONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.DARK_PRISMARINE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.DEEPSLATE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.DEEPSLATE_BRICKS, (ItemLike)Blocks.COBBLED_DEEPSLATE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.DEEPSLATE_BRICKS, (ItemLike)Blocks.POLISHED_DEEPSLATE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.DEEPSLATE_TILES, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.DEEPSLATE_TILES, (ItemLike)Blocks.COBBLED_DEEPSLATE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.DEEPSLATE_TILES, (ItemLike)Blocks.DEEPSLATE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.DEEPSLATE_TILES, (ItemLike)Blocks.POLISHED_DEEPSLATE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.END_STONE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.END_STONE_BRICKS, (ItemLike)Blocks.END_STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.MOSSY_STONE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.MUD_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.MUD_BRICKS, (ItemLike)Blocks.PACKED_MUD, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.NETHER_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.PRISMARINE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.PURPUR_BLOCK, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.QUARTZ_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.QUARTZ_BRICKS, (ItemLike)Blocks.QUARTZ_BLOCK, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.RED_NETHER_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.STONE_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.STONE_BRICKS, (ItemLike)Blocks.STONE, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingRecipes(output, BlockFamilyRegistry.TUFF_BRICKS, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.TUFF_BRICKS, (ItemLike)Blocks.TUFF, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        this.generateStonecuttingFromBaseRecipes(output, BlockFamilyRegistry.TUFF_BRICKS, (ItemLike)Blocks.POLISHED_TUFF, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA));
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CALCITE.entrySet()) {
            dyeColor = entry.getKey();
            dyeItemTag = TagRegistry.itemTags("c", "dyes/" + dyeColor.getName());
            this.dyeItemRecipe(1, "calcite_from_dye", (ItemLike)entry.getValue(), RecipeCategory.BUILDING_BLOCKS, dyeItemTag, TagRegistry.CALCITE_ITEMS, output);
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.POLISHED_CALCITE.entrySet()) {
            dyeColor = entry.getKey();
            dyeItemTag = TagRegistry.itemTags("c", "dyes/" + dyeColor.getName());
            this.dyeItemRecipe(1, "polished_calcite_from_dye", (ItemLike)entry.getValue(), RecipeCategory.BUILDING_BLOCKS, dyeItemTag, TagRegistry.POLISHED_CALCITE_ITEMS, output);
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CALCITE_BRICKS.entrySet()) {
            dyeColor = entry.getKey();
            dyeItemTag = TagRegistry.itemTags("c", "dyes/" + dyeColor.getName());
            this.dyeItemRecipe(1, "calcite_bricks_from_dye", (ItemLike)entry.getValue(), RecipeCategory.BUILDING_BLOCKS, dyeItemTag, TagRegistry.CALCITE_BRICK_ITEMS, output);
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CRACKED_CALCITE_BRICKS.entrySet()) {
            dyeColor = entry.getKey();
            dyeItemTag = TagRegistry.itemTags("c", "dyes/" + dyeColor.getName());
            this.dyeItemRecipe(1, "cracked_calcite_bricks_from_dye", (ItemLike)entry.getValue(), RecipeCategory.BUILDING_BLOCKS, dyeItemTag, TagRegistry.CRACKED_CALCITE_BRICK_ITEMS, output);
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CHISELED_CALCITE_BRICKS.entrySet()) {
            dyeColor = entry.getKey();
            dyeItemTag = TagRegistry.itemTags("c", "dyes/" + dyeColor.getName());
            this.dyeItemRecipe(1, "chiseled_calcite_bricks_from_dye", (ItemLike)entry.getValue(), RecipeCategory.BUILDING_BLOCKS, dyeItemTag, TagRegistry.CHISELED_CALCITE_BRICK_ITEMS, output);
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CHECKPOINT_FLAGS.entrySet()) {
            dyeColor = entry.getKey();
            dyeItemTag = TagRegistry.itemTags("c", "dyes/" + dyeColor.getName());
            woolItem = BuiltInRegistries.ITEM.stream().filter(item -> {
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey(item);
                return itemId.getPath().endsWith("_wool") && itemId.getPath().startsWith(dyeColor.getName());
            }).findFirst().orElse(Items.WHITE_WOOL);
            this.checkpointFlagRecipe(1, (ItemLike)entry.getValue(), (TagKey<Item>)Tags.Items.INGOTS_GOLD, (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)woolItem, (ItemLike)Blocks.SMOOTH_STONE_SLAB, output);
            this.dyeItemRecipe(1, "checkpoint_flags_from_dye", (ItemLike)entry.getValue(), RecipeCategory.BUILDING_BLOCKS, dyeItemTag, TagRegistry.DYEABLE_CHECKPOINT_FLAG_ITEMS, output);
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.GOAL_POLES.entrySet()) {
            dyeColor = entry.getKey();
            dyeItemTag = TagRegistry.itemTags("c", "dyes/" + dyeColor.getName());
            woolItem = BuiltInRegistries.ITEM.stream().filter(item -> {
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey(item);
                return itemId != null && itemId.getPath().endsWith("_wool") && itemId.getPath().startsWith(dyeColor.getName());
            }).findFirst().orElse(Items.WHITE_WOOL);
            this.goalPoleRecipe(4, (ItemLike)entry.getValue(), (TagKey<Item>)Tags.Items.INGOTS_GOLD, (TagKey<Item>)Tags.Items.INGOTS_IRON, (ItemLike)woolItem, output);
            this.dyeItemRecipe(1, "goal_poles_from_dye", (ItemLike)entry.getValue(), RecipeCategory.BUILDING_BLOCKS, dyeItemTag, TagRegistry.DYEABLE_GOAL_POLE_ITEMS, output);
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.WARP_PIPES.entrySet()) {
            dyeColor = entry.getKey();
            dyeItemTag = TagRegistry.itemTags("c", "dyes/" + dyeColor.getName());
            this.warpPipeRecipe(4, (ItemLike)entry.getValue(), (TagKey<Item>)Tags.Items.INGOTS_COPPER, dyeItemTag, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (TagKey<Item>)Tags.Items.ENDER_PEARLS, output);
            this.dyeItemRecipe(1, "warp_pipes_from_dye", (ItemLike)entry.getValue(), RecipeCategory.BUILDING_BLOCKS, dyeItemTag, TagRegistry.DYEABLE_WARP_PIPE_ITEMS, output);
        }
    }
}

