/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.google.common.base.MoreObjects;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.entities.projectiles.BouncingIceBallProjectile;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IceCubeEntity
extends Mob
implements GeoEntity,
TraceableEntity {
    private static final EntityDataAccessor<CompoundTag> FROZEN_DATA = SynchedEntityData.defineId(IceCubeEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Vec3 slidingMovement;
    private CompoundTag frozenEntityData;
    private Entity displayEntity;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private boolean leftOwner;
    private float previousFallDistance;

    public IceCubeEntity(EntityType<? extends IceCubeEntity> type, Level world) {
        super(type, world);
        this.slidingMovement = new Vec3(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
        this.previousFallDistance = 0.0f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setSliding(boolean isSliding) {
        this.setData(DataAttachmentRegistry.IS_SLIDING.get(), isSliding);
    }

    public boolean isSliding() {
        return (Boolean)this.getData(DataAttachmentRegistry.IS_SLIDING.get());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROZEN_DATA, (Object)new CompoundTag());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        CompoundTag tag;
        super.onSyncedDataUpdated(accessor);
        if (FROZEN_DATA.equals(accessor) && this.level().isClientSide && !(tag = (CompoundTag)this.entityData.get(FROZEN_DATA)).isEmpty()) {
            this.frozenEntityData = tag.copy();
            this.refreshDimensions();
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.put("FrozenData", (Tag)((CompoundTag)this.entityData.get(FROZEN_DATA)).copy());
        if (this.getFrozenEntityData() != null) {
            tag.put("FrozenEntityData", (Tag)this.getFrozenEntityData());
        }
        if (this.ownerUUID != null) {
            tag.putUUID("OwnerUUID", this.ownerUUID);
        }
        if (this.leftOwner) {
            tag.putBoolean("LeftOwner", true);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.leftOwner = tag.getBoolean("LeftOwner");
        if (tag.contains("FrozenData", 10)) {
            this.entityData.set(FROZEN_DATA, (Object)tag.getCompound("FrozenData"));
        }
        if (tag.contains("FrozenEntityData", 10)) {
            this.setFrozenEntityData(tag);
        }
        if (tag.hasUUID("OwnerUUID")) {
            this.ownerUUID = tag.getUUID("OwnerUUID");
            this.cachedOwner = null;
        }
        this.reapplyPosition();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, serverEntity, entity == null ? 0 : entity.getId());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Entity entity = this.level().getEntity(packet.getData());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        BlockPos pos = this.blockPosition();
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if (this.onGround() && this.getDeltaMovement().horizontalDistance() <= 0.005 && this.getEntityFrozenCooldown() > 0) {
            this.setEntityFrozenCooldown(this.getEntityFrozenCooldown() - 1);
        }
        if (this.getEntityFrozenCooldown() == 0) {
            this.shatterIceCube((Entity)this, false, false, false);
        }
        if (!this.onGround() && this.getTicksInAir() > 0) {
            this.setTicksInAir(this.getTicksInAir() - 1);
        }
        if (this.getDeltaMovement().horizontalDistance() > 0.1) {
            this.spawnSnowParticles();
        }
        if (this.getFrozenEntityData() != null) {
            float height = this.getFrozenEntityData().getFloat("Height") * 1.55f;
            float width = this.getFrozenEntityData().getFloat("Width") * 1.55f;
            this.setSize(width, height);
        }
        if (!this.isOnSolidGround() && this.fallDistance > this.previousFallDistance) {
            this.previousFallDistance = this.fallDistance;
        }
        if (this.isOnSolidGround() && this.previousFallDistance > 3.0f) {
            this.shatterIceCube((Entity)this, true, false, false);
            this.previousFallDistance = 0.0f;
        }
        if (this.isSliding() && this.isAlive() && !this.isNoAi()) {
            BlockPos posBelow = this.blockPosition().below();
            BlockState stateBelow = this.level().getBlockState(posBelow);
            float friction = stateBelow.getFriction((LevelReader)this.level(), posBelow, (Entity)this);
            double slideFriction = 1.0;
            Vec3 slideMotion = this.slidingMovement.scale(slideFriction);
            if (this.onGround() && this.getDeltaMovement().horizontalDistance() > 1.0E-4) {
                this.setDeltaMovement(slideMotion.x, this.getDeltaMovement().y, slideMotion.z);
                this.slidingMovement = new Vec3(slideMotion.x, this.getDeltaMovement().y, slideMotion.z);
                this.hasImpulse = true;
            }
        }
        this.collideWithFire(world);
        this.collideWithEntity();
        if (this.horizontalCollision) {
            this.shatterIceCube((Entity)this, false, true, false);
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.NAME_TAG)) {
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public ItemStack getPickedResult(@NotNull HitResult target) {
        if (this.displayEntity != null) {
            ItemStack pickedResult;
            Entity entityInstance = this.displayEntity.getType().create(this.level());
            SpawnEggItem spawnEggItem = SpawnEggItem.byId((EntityType)this.displayEntity.getType());
            if (spawnEggItem != null) {
                return new ItemStack((ItemLike)spawnEggItem);
            }
            if (entityInstance != null && (pickedResult = entityInstance.getPickedResult(target)) != null && !pickedResult.isEmpty()) {
                return pickedResult;
            }
        }
        return super.getPickedResult(target);
    }

    public boolean hurt(DamageSource source, float damage) {
        LivingEntity entity;
        Level world = this.level();
        BlockPos posBelow = this.blockPosition().below();
        BlockState stateBelow = world.getBlockState(posBelow);
        if (this.level().isClientSide || this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.getDirectEntity() instanceof BouncingIceBallProjectile && this.getType().is(TagRegistry.ICE_BALL_IMMUNE)) {
            return false;
        }
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).getMainHandItem().is(ItemTags.PICKAXES)) {
            this.shatterIceCube((Entity)this, false, false, false);
            return true;
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.shatterIceCube(null, false, false, false);
            return true;
        }
        float friction = stateBelow.getFriction((LevelReader)world, posBelow, (Entity)this);
        double slideSpeed = (double)friction > 0.6 ? 0.4 + (double)friction / 1.5 : 1.0;
        Vec3 slideDirection = new Vec3(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
        if (source.getEntity() != null) {
            Vec3 attackerPos = source.getEntity().position();
            Vec3 hitPos = this.position();
            Vec3 slideDirRaw = hitPos.subtract(attackerPos).normalize();
            slideDirection = new Vec3(slideDirRaw.x, this.getDeltaMovement().y, slideDirRaw.z).normalize();
        } else if (source.getDirectEntity() != null) {
            slideDirection = source.getDirectEntity().getDeltaMovement().normalize();
        }
        Vec3 movement = slideDirection.scale(slideSpeed);
        if (!this.isNoAi() && this.displayEntity instanceof Mob || !(this.displayEntity instanceof Mob)) {
            this.setDeltaMovement(movement.x, this.getDeltaMovement().y, movement.z);
            this.slidingMovement = new Vec3(movement.x, this.getDeltaMovement().y, movement.z);
            this.hasImpulse = true;
            this.setOwner(source.getEntity());
            this.setSliding(true);
            this.leftOwner = false;
        }
        return true;
    }

    protected boolean wouldNotSuffocateAtTargetPose(Pose pose) {
        return false;
    }

    public boolean canCollideWith(Entity entity) {
        return super.canCollideWith(entity);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    public void push(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!(entity instanceof IceCubeEntity) && !entity.noPhysics && !this.noPhysics && (d2 = Mth.absMax((double)(d0 = entity.getX() - this.getX()), (double)(d1 = entity.getZ() - this.getZ()))) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.isVehicle() && this.isPushable()) {
                this.push(-d0, 0.0, -d1);
            }
            if (!entity.isVehicle() && entity.isPushable()) {
                entity.push(d0, 0.0, d1);
            }
        }
    }

    protected double getDefaultGravity() {
        return 0.06;
    }

    public boolean isNoGravity() {
        if (this.getTicksInAir() > 0 && !this.onGround() && this.getDeltaMovement().horizontalDistance() == 0.0) {
            return true;
        }
        if (this.isNoAi()) {
            return true;
        }
        return super.isNoGravity();
    }

    protected void applyGravity() {
        if (this.getTicksInAir() == 0 && !this.isNoAi()) {
            super.applyGravity();
        }
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity riderEntity) {
        return true;
    }

    protected boolean canRide(Entity riderEntity) {
        return true;
    }

    protected void positionRider(Entity riderEntity, Entity.MoveFunction moveFunction) {
        if (this.isAlive()) {
            moveFunction.accept(riderEntity, this.getX(), this.getY() + (double)(riderEntity.getBbHeight() / 4.0f), this.getZ());
        } else {
            super.positionRider(riderEntity, moveFunction);
        }
        if (riderEntity instanceof Player) {
            Player player = (Player)riderEntity;
            player.setYRot(this.getYRot());
            player.yRotO = this.getYRot();
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canControlVehicle() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        if (!this.getPassengers().isEmpty()) {
            return false;
        }
        return this.getFrozenEntityData() == null;
    }

    public void turn(double yaw, double pitch) {
    }

    public void setYRot(float yaw) {
    }

    public void setYHeadRot(float yaw) {
    }

    public void setYya(float yaw) {
    }

    public void setRot(float yaw, float pitch) {
    }

    @NotNull
    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.getFrozenEntityData() != null) {
            float height = this.getFrozenEntityData().getFloat("Height") * 1.55f;
            float width = this.getFrozenEntityData().getFloat("Width") * 1.55f;
            return EntityDimensions.fixed((float)width, (float)height);
        }
        return super.getDefaultDimensions(pose);
    }

    public void setOwner(@Nullable Entity entity) {
        if (entity != null) {
            this.ownerUUID = entity.getUUID();
            this.cachedOwner = entity;
        }
    }

    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.cachedOwner = serverWorld.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof IceCubeEntity) {
            IceCubeEntity iceCube = (IceCubeEntity)entity;
            this.cachedOwner = iceCube.cachedOwner;
        }
    }

    protected boolean ownedBy(Entity entity) {
        return entity.getUUID().equals(this.ownerUUID);
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)((Object)this));
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity1 : this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), mob -> !mob.isSpectator() && mob.isPickable())) {
                if (entity1.getRootVehicle() != entity.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean deflect(@Nullable Entity entity, @Nullable Entity ownerEntity, boolean deflect) {
        if (!this.level().isClientSide) {
            this.setOwner(ownerEntity);
            this.onDeflection(entity, deflect);
        }
        return true;
    }

    protected void onDeflection(@Nullable Entity entity, boolean deflect) {
        Vec3 motion = this.getDeltaMovement();
        this.setDeltaMovement(new Vec3(-motion.x, motion.y, -motion.z));
    }

    public void setFrozenEntity(Entity entity, int ticksFrozen) {
        if (entity != null) {
            float scale = 1.0f;
            float eyeHeightScale = 1.0f;
            float heightScale = 1.0f;
            float widthScale = 1.0f;
            this.frozenEntityData = new CompoundTag();
            entity.save(this.frozenEntityData);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                AttributeInstance scaleAttribute = living.getAttribute(Attributes.SCALE);
                AttributeInstance eyeHeightScaleAttribute = living.getAttribute(AttributesRegistry.EYE_HEIGHT_SCALE);
                AttributeInstance heightScaleAttribute = living.getAttribute(AttributesRegistry.HEIGHT_SCALE);
                AttributeInstance widthScaleAttribute = living.getAttribute(AttributesRegistry.WIDTH_SCALE);
                if (scaleAttribute != null) {
                    scale = (float)scaleAttribute.getValue();
                }
                if (eyeHeightScaleAttribute != null) {
                    eyeHeightScale = (float)eyeHeightScaleAttribute.getValue();
                }
                if (heightScaleAttribute != null) {
                    heightScale = (float)heightScaleAttribute.getValue();
                }
                if (widthScaleAttribute != null) {
                    widthScale = (float)widthScaleAttribute.getValue();
                }
                this.copyAttributeWithModifiers(living, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE);
                this.getFrozenEntityData().putFloat("YBodyRot", living.yBodyRot);
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                this.setNoAi(mob.isNoAi());
            }
            if (!this.level().isClientSide) {
                this.getFrozenEntityData().putString("id", EntityType.getKey((EntityType)entity.getType()).toString());
                this.getFrozenEntityData().putFloat("BodyRotation", entity.getYRot());
                this.getFrozenEntityData().putFloat("HeadRotation", entity.getYHeadRot());
                this.getFrozenEntityData().putFloat("Pitch", entity.getXRot());
                this.getFrozenEntityData().putFloat("EyeHeight", entity.getEyeHeight());
                this.getFrozenEntityData().putFloat("Height", entity.getBbHeight());
                this.getFrozenEntityData().putFloat("Width", entity.getBbWidth());
                this.getFrozenEntityData().putFloat("Scale", scale);
                this.getFrozenEntityData().putFloat("EyeHeightScale", eyeHeightScale);
                this.getFrozenEntityData().putFloat("HeightScale", heightScale);
                this.getFrozenEntityData().putFloat("WidthScale", widthScale);
                this.entityData.set(FROZEN_DATA, (Object)this.frozenEntityData);
            }
            this.setHeight(entity.getBbHeight());
            this.setWidth(entity.getBbWidth());
            this.setEyeHeightScale(eyeHeightScale);
            this.setHeightScale(heightScale);
            this.setWidthScale(widthScale);
            this.setScale(scale);
            if (entity instanceof KoopaTroopaEntity) {
                KoopaTroopaEntity koopa = (KoopaTroopaEntity)entity;
                koopa.hide(koopa.isHiding());
            }
            this.setSize(entity.getBbWidth() * scale * widthScale * 1.55f, entity.getBbHeight() * scale * heightScale * 1.55f);
            if (!(entity instanceof Player)) {
                entity.discard();
            }
            this.refreshDimensions();
            this.setEntityFrozenCooldown(ticksFrozen);
        }
    }

    @Nullable
    public Entity getPlayer(Level world) {
        Iterator iterator;
        CompoundTag tag = (CompoundTag)this.entityData.get(FROZEN_DATA);
        if (tag.isEmpty() && (iterator = world.players().iterator()).hasNext()) {
            Player player = (Player)iterator.next();
            return player;
        }
        return null;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level world) {
        CompoundTag tag = (CompoundTag)this.entityData.get(FROZEN_DATA);
        if (tag.isEmpty()) {
            return null;
        }
        if (this.displayEntity == null) {
            Entity entity;
            if (!tag.contains("id", 8)) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)world, Function.identity());
            if (this.displayEntity != null && (entity = this.displayEntity) instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                entity2.hurtDuration = 0;
                entity2.hurtTime = 0;
                entity2.yBodyRot = this.getYBodyRot();
                if (tag.contains("Scale")) {
                    float scale = tag.getFloat("Scale");
                    entity2.setBoundingBox(entity2.getBoundingBox().inflate((double)scale - 1.0));
                    entity2.getPersistentData().putFloat("Scale", scale);
                }
                if (tag.contains("HeightScale")) {
                    float scale = tag.getFloat("HeightScale");
                    entity2.setBoundingBox(entity2.getBoundingBox().inflate((double)scale - 1.0));
                    entity2.getPersistentData().putFloat("HeightScale", scale);
                }
                if (tag.contains("WidthScale")) {
                    float scale = tag.getFloat("WidthScale");
                    entity2.setBoundingBox(entity2.getBoundingBox().inflate((double)scale - 1.0));
                    entity2.getPersistentData().putFloat("WidthScale", scale);
                }
            }
        }
        return this.displayEntity;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.displayEntity == null) {
            this.displayEntity = this.getOrCreateDisplayEntity(this.level());
        }
    }

    public void shatterIceCube(@Nullable Entity attackingEntity, boolean applyFallDamage, boolean applyCollisionDamage, boolean useWaterParticles) {
        ServerLevel serverWorld;
        Level level;
        if (this.getFrozenEntityData() != null && (level = this.level()) instanceof ServerLevel) {
            serverWorld = (ServerLevel)level;
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)this.getFrozenEntityData(), (Level)serverWorld, e -> {
                e.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
                return e;
            });
            if (entity != null) {
                if (attackingEntity != null) {
                    serverWorld.addFreshEntity(entity);
                }
                if (entity instanceof LivingEntity) {
                    float damageAmount;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (applyFallDamage) {
                        damageAmount = Math.max(0.0f, this.fallDistance - (float)livingEntity.getMaxFallDistance());
                        livingEntity.hurt(this.level().damageSources().fall(), damageAmount);
                        livingEntity.hurtDuration = 10;
                        livingEntity.hurtTime = 10;
                        livingEntity.hurtMarked = true;
                    }
                    if (applyCollisionDamage && !livingEntity.getType().is(TagRegistry.ICE_CUBE_SHATTER_CANNOT_DAMAGE)) {
                        float f = damageAmount = livingEntity.getType().is(TagRegistry.ICE_CUBE_SHATTER_CAN_INSTAKILL) ? Float.MAX_VALUE : ((Double)ConfigRegistry.ICE_CUBE_DAMAGE.get()).floatValue();
                        if (this.getOwner() != null) {
                            livingEntity.hurt(DamageSourceRegistry.iceCubeCrushed((Entity)livingEntity, this.getOwner()), damageAmount);
                        } else if (attackingEntity != null) {
                            livingEntity.hurt(DamageSourceRegistry.iceCubeCrushed((Entity)livingEntity, attackingEntity), damageAmount);
                        }
                        livingEntity.hurtDuration = 10;
                        livingEntity.hurtTime = 10;
                        livingEntity.hurtMarked = true;
                    }
                    livingEntity.yBodyRot = this.getYBodyRot();
                }
                entity.setYRot(this.getBodyRotation());
                entity.setYHeadRot(this.getHeadRotation());
                entity.setXRot(this.getPitch());
                entity.setIsInPowderSnow(true);
                this.discard();
                if (entity.canFreeze()) {
                    entity.setTicksFrozen(((Integer)ConfigRegistry.ICE_CUBE_FREEZE_DURATION.get()).intValue());
                }
                this.level().playSound((Entity)this, this.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.AMBIENT, 1.0f, 1.0f);
                if (useWaterParticles) {
                    this.spawnShatterParticles(serverWorld, entity, (ParticleOptions)ParticleTypes.SPLASH);
                } else {
                    this.spawnShatterParticles(serverWorld, entity, (ParticleOptions)ParticleRegistry.ICE_CUBE_SHATTER.get());
                }
            }
        }
        if ((level = this.getControllingPassenger()) instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)level;
            handler.mv$setFreezeImmunityCooldown(20);
        }
        this.ejectPassengers();
        if (this.previousFallDistance > 3.0f || attackingEntity != null || this.getEntityFrozenCooldown() == 0) {
            this.discard();
            this.level().playSound((Entity)this, this.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.AMBIENT, 1.0f, 1.0f);
            level = this.level();
            if (level instanceof ServerLevel) {
                serverWorld = (ServerLevel)level;
                if (useWaterParticles) {
                    this.spawnShatterParticles(serverWorld, (Entity)this, (ParticleOptions)ParticleTypes.SPLASH);
                } else {
                    this.spawnShatterParticles(serverWorld, (Entity)this, (ParticleOptions)ParticleRegistry.ICE_CUBE_SHATTER.get());
                }
            }
        }
    }

    private void collideWithFire(Level world) {
        AABB box = this.getBoundingBox().inflate(0.05);
        for (BlockPos hitPos : BlockPos.betweenClosed((int)Mth.floor((double)box.minX), (int)Mth.floor((double)box.minY), (int)Mth.floor((double)box.minZ), (int)Mth.floor((double)box.maxX), (int)Mth.floor((double)box.maxY), (int)Mth.floor((double)box.maxZ))) {
            BlockState state = world.getBlockState(hitPos);
            if (state.is(TagRegistry.ICE_CUBE_EXTINGUISHES) || state.getFluidState().is(FluidTags.LAVA)) {
                ServerLevel serverWorld;
                Level level;
                if (state.is(BlockTags.FIRE)) {
                    level = this.level();
                    if (level instanceof ServerLevel) {
                        serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnParticleRingOnBlock((ParticleOptions)ParticleTypes.SMOKE, serverWorld, hitPos, 0.25, 10);
                    }
                    world.setBlock(hitPos, Blocks.AIR.defaultBlockState(), 3);
                    world.playSound(null, hitPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (state.hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                    level = this.level();
                    if (level instanceof ServerLevel) {
                        serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnParticleRingOnBlock((ParticleOptions)ParticleTypes.SMOKE, serverWorld, hitPos, 0.25, 10);
                    }
                    world.setBlock(hitPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
                    world.playSound(null, hitPos, state.getBlock() instanceof CandleBlock || state.getBlock() instanceof CandleCakeBlock ? SoundEvents.CANDLE_EXTINGUISH : SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (this.isOnFire() || state.getFluidState().is(FluidTags.LAVA)) {
                this.shatterIceCube((Entity)this, false, false, true);
                break;
            }
            if (state.is(TagRegistry.MELTS_ICE_CUBE) && state.hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                this.shatterIceCube((Entity)this, false, false, true);
                break;
            }
            if (!state.is(TagRegistry.MELTS_ICE_CUBE) || state.hasProperty((Property)BlockStateProperties.LIT)) continue;
            this.shatterIceCube((Entity)this, false, false, true);
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void collideWithEntity() {
        collisionBox = this.getBoundingBox().inflate(0.01, 0.0, 0.01);
        collisionBoxNoInflation = this.getBoundingBox();
        collidingEntities = this.level().getEntities((Entity)this, collisionBox);
        collidingEntitiesNoInflation = this.level().getEntities((Entity)this, collisionBoxNoInflation);
        for (Entity entity : collidingEntities) {
            block10: {
                if (!(this.getDeltaMovement().horizontalDistance() > 0.0)) break block10;
                if (!(entity instanceof IceCubeEntity)) ** GOTO lbl-1000
                otherIceCube = (IceCubeEntity)entity;
                if (this.getDeltaMovement().horizontalDistance() >= 0.2 || this.getDeltaMovement().horizontalDistance() <= -0.2) {
                    this.shatterIceCube((Entity)this, false, true, false);
                    otherIceCube.shatterIceCube((Entity)this, false, true, false);
                } else if (entity instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity;
                    if ((this.getDeltaMovement().horizontalDistance() >= 0.5 || this.getDeltaMovement().horizontalDistance() <= -0.5) && !livingEntity.getType().is(TagRegistry.ICE_CUBE_COLLISION_CANNOT_DAMAGE)) {
                        shield = livingEntity.getUseItem();
                        toIceCube = this.position().subtract(livingEntity.position()).normalize();
                        look = livingEntity.getLookAngle().normalize();
                        dot = toIceCube.dot(look);
                        if (livingEntity.isBlocking() && dot > 0.25) {
                            this.deflect(entity, (Entity)livingEntity, true);
                            shield.hurtAndBreak(1, livingEntity, LivingEntity.getSlotForHand((InteractionHand)livingEntity.getUsedItemHand()));
                            this.level().playSound(null, this.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                            continue;
                        }
                        if (this.getOwner() != null) {
                            livingEntity.hurt(DamageSourceRegistry.iceCubeCrushed((Entity)livingEntity, this.getOwner()), ((Double)ConfigRegistry.ICE_CUBE_DAMAGE.get()).floatValue());
                        } else {
                            livingEntity.hurt(DamageSourceRegistry.iceCubeCrushed((Entity)livingEntity, (Entity)this), ((Double)ConfigRegistry.ICE_CUBE_DAMAGE.get()).floatValue());
                        }
                    }
                }
            }
            if (!(entity instanceof AbstractArrow)) continue;
            arrow = (AbstractArrow)entity;
            this.shatterIceCube((Entity)this, false, false, false);
            if (arrow.isOnFire()) {
                arrow.extinguishFire();
            }
            if (!(arrow instanceof SpectralArrow)) continue;
            this.setGlowingTag(true);
        }
        for (Entity entity : collidingEntitiesNoInflation) {
            entity.extinguishFire();
            if (!(entity instanceof Player) || (player = (Player)entity).isCreative()) continue;
            entity.setIsInPowderSnow(true);
            if (!player.canFreeze()) continue;
            entity.setTicksFrozen(((Integer)ConfigRegistry.ICE_CUBE_FREEZE_DURATION.get()).intValue());
        }
    }

    private boolean isOnSolidGround() {
        BlockPos posBelow = this.blockPosition().below();
        return this.level().getBlockState(posBelow).isSolidRender((BlockGetter)this.level(), posBelow);
    }

    protected void spawnSnowParticles() {
        BlockPos posLegacy = this.getOnPosLegacy();
        BlockState state = this.level().getBlockState(posLegacy);
        if (!state.addRunningEffects(this.level(), posLegacy, (Entity)this) && state.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 vec3 = this.getDeltaMovement();
            BlockPos pos = this.blockPosition();
            double x = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getSize().x;
            double z = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getSize().x;
            if (pos.getX() != posLegacy.getX()) {
                x = Mth.clamp((double)x, (double)posLegacy.getX(), (double)((double)posLegacy.getX() + 1.0));
            }
            if (pos.getZ() != posLegacy.getZ()) {
                z = Mth.clamp((double)z, (double)posLegacy.getZ(), (double)((double)posLegacy.getZ() + 1.0));
            }
            if (!this.isInWaterOrBubble()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, x, this.getY() + 0.1, z, vec3.x * -2.0, 0.0, vec3.z * -2.0);
                this.level().addParticle((ParticleOptions)ParticleRegistry.ICE_CUBE_SHATTER.get(), x, this.getY() + 0.1, z, vec3.x * -2.0, 0.0, vec3.z * -2.0);
            }
            this.level().addParticle((ParticleOptions)ParticleRegistry.ICE_STAR.get(), x, this.getY() + 0.1, z, vec3.x * -4.0, 1.5, vec3.z * -4.0);
        }
    }

    private void spawnShatterParticles(ServerLevel serverWorld, Entity entity, ParticleOptions particle) {
        float height = this.getHeight() * this.getScale() * this.getHeightScale() * 1.55f;
        float width = this.getWidth() * this.getScale() * this.getWidthScale() * 1.55f;
        if (entity.getBbHeight() >= entity.getBbWidth() * 3.0f) {
            width *= 2.0f;
        }
        float scaleFactor = height * width * 1.2f;
        int numParticles = (int)(scaleFactor * 10.0f);
        for (int i = 0; i < numParticles; ++i) {
            ServerParticleUtils.spawnEntityBreakParticles(particle, serverWorld, entity, height, width);
        }
    }

    public CompoundTag getFrozenEntityData() {
        return this.frozenEntityData;
    }

    public void setFrozenEntityData(CompoundTag tag) {
        this.frozenEntityData = tag.getCompound("FrozenEntityData");
    }

    public Vec2 getSize() {
        return new Vec2(this.getWidth(), this.getHeight());
    }

    public void setSize(float width, float height) {
        this.setHeight(height);
        this.setWidth(width);
        this.refreshDimensions();
        this.setBoundingBox(new AABB(this.getX() - (double)(width / 2.0f), this.getY(), this.getZ() - (double)(width / 2.0f), this.getX() + (double)(width / 2.0f), this.getY() + (double)height, this.getZ() + (double)(width / 2.0f)));
    }

    public float getHeight() {
        return ((Float)this.getData(DataAttachmentRegistry.HEIGHT)).floatValue();
    }

    public void setHeight(float height) {
        this.setData(DataAttachmentRegistry.HEIGHT, Float.valueOf(height));
    }

    public float getWidth() {
        return ((Float)this.getData(DataAttachmentRegistry.WIDTH)).floatValue();
    }

    public void setWidth(float width) {
        this.setData(DataAttachmentRegistry.WIDTH, Float.valueOf(width));
    }

    public void setScale(float scale) {
        this.setData(DataAttachmentRegistry.SCALE, Float.valueOf(scale));
    }

    public float getEyeHeightScale() {
        AttributeMap attributeMap = this.getAttributes();
        return attributeMap == null ? 1.0f : this.sanitizeScale((float)attributeMap.getValue(AttributesRegistry.EYE_HEIGHT_SCALE));
    }

    public void setEyeHeightScale(float eyeHeightScale) {
        this.setData(DataAttachmentRegistry.EYE_HEIGHT_SCALE, Float.valueOf(eyeHeightScale));
    }

    public float getHeightScale() {
        AttributeMap attributeMap = this.getAttributes();
        return attributeMap == null ? 1.0f : this.sanitizeScale((float)attributeMap.getValue(AttributesRegistry.HEIGHT_SCALE));
    }

    public void setHeightScale(float heightScale) {
        this.setData(DataAttachmentRegistry.HEIGHT_SCALE, Float.valueOf(heightScale));
    }

    public float getWidthScale() {
        AttributeMap attributeMap = this.getAttributes();
        return attributeMap == null ? 1.0f : this.sanitizeScale((float)attributeMap.getValue(AttributesRegistry.WIDTH_SCALE));
    }

    public void setWidthScale(float widthScale) {
        this.setData(DataAttachmentRegistry.WIDTH_SCALE, Float.valueOf(widthScale));
    }

    public int getEntityFrozenCooldown() {
        return (Integer)this.getData(DataAttachmentRegistry.ENTITY_FROZEN_COOLDOWN);
    }

    public void setEntityFrozenCooldown(int frozenCooldown) {
        this.setData(DataAttachmentRegistry.ENTITY_FROZEN_COOLDOWN, frozenCooldown);
    }

    public int getTicksInAir() {
        return (Integer)this.getData(DataAttachmentRegistry.TICKS_IN_AIR);
    }

    public void setTicksInAir(int ticksInAir) {
        this.setData(DataAttachmentRegistry.TICKS_IN_AIR, ticksInAir);
    }

    public float getBodyRotation() {
        return ((Float)this.getData(DataAttachmentRegistry.BODY_ROTATION)).floatValue();
    }

    public void setBodyRotation(float bodyRotation) {
        this.setData(DataAttachmentRegistry.BODY_ROTATION, Float.valueOf(bodyRotation));
    }

    public float getHeadRotation() {
        return ((Float)this.getData(DataAttachmentRegistry.HEAD_ROTATION)).floatValue();
    }

    public void setHeadRotation(float headRotation) {
        this.setData(DataAttachmentRegistry.HEAD_ROTATION, Float.valueOf(headRotation));
    }

    public float getPitch() {
        return ((Float)this.getData(DataAttachmentRegistry.PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.setData(DataAttachmentRegistry.PITCH, Float.valueOf(pitch));
    }

    public float getYBodyRot() {
        return ((Float)this.getData(DataAttachmentRegistry.Y_BODY_ROT)).floatValue();
    }

    public void setYBodyRot(float yBodyRot) {
        this.setData(DataAttachmentRegistry.Y_BODY_ROT, Float.valueOf(yBodyRot));
    }

    private void copyAttributeWithModifiers(LivingEntity entity, Holder<Attribute> attribute) {
        AttributeInstance fromAttr = entity.getAttribute(attribute);
        AttributeInstance toAttr = this.getAttribute(attribute);
        if (fromAttr != null && toAttr != null) {
            toAttr.setBaseValue(fromAttr.getBaseValue());
            for (AttributeModifier modifier : fromAttr.getModifiers()) {
                toAttr.addPermanentModifier(modifier);
            }
        }
    }
}

