/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.CopperGolemStatueBlock;
import com.github.smallinger.coppergolemlegacy.util.WeatheringHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WeatheringCopperGolemStatueBlock
extends CopperGolemStatueBlock
implements WeatheringCopper {
    public static final MapCodec<WeatheringCopperGolemStatueBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeatheringCopper.WeatherState.CODEC.fieldOf("weathering_state").forGetter(CopperGolemStatueBlock::getWeatheringState), (App)WeatheringCopperGolemStatueBlock.propertiesCodec()).apply((Applicative)instance, WeatheringCopperGolemStatueBlock::new));

    public WeatheringCopperGolemStatueBlock(WeatheringCopper.WeatherState weatheringState, BlockBehaviour.Properties properties) {
        super(weatheringState, properties);
    }

    protected MapCodec<? extends WeatheringCopperGolemStatueBlock> codec() {
        return CODEC;
    }

    public static Optional<Block> getNextBlock(Block block) {
        if (block == CopperGolemLegacy.COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_GOLEM_STATUE.get());
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_GOLEM_STATUE.get());
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_GOLEM_STATUE.get()) {
            return Optional.of((Block)CopperGolemLegacy.OXIDIZED_COPPER_GOLEM_STATUE.get());
        }
        return WeatheringCopper.getNext((Block)block);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        WeatheringHelper.tryWeather(state, level, pos, random, WeatheringCopperGolemStatueBlock::getNextBlock);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return WeatheringHelper.canWeather(state, WeatheringCopperGolemStatueBlock::getNextBlock);
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.getWeatheringState();
    }
}

