/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.ClutterNoMoreClient;
import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
import dev.tazer.clutternomore.common.shape_map.ShapeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_8710;

public class ShapeSwitcherOverlay {
    public final class_310 minecraft;
    public final boolean render;
    public final int selected;
    public int count;
    public final List<class_1792> shapes;
    public int selectedIndex;
    public float currentIndex;

    public ShapeSwitcherOverlay(class_310 minecraft, class_1799 heldStack, boolean render) {
        this.minecraft = minecraft;
        this.render = render;
        this.selected = minecraft.field_1724.method_31548().field_7545;
        class_1792 item = ShapeMap.getParent(heldStack.method_7909());
        this.count = heldStack.method_7947();
        this.shapes = new ArrayList<class_1792>(ShapeMap.getShapes(item));
        this.shapes.add(0, item);
        this.selectedIndex = this.shapes.indexOf(heldStack.method_7909());
        this.currentIndex = this.selectedIndex;
    }

    public void render(class_332 guiGraphics, float partialTick) {
        class_2960 background = ClutterNoMore.location("textures/gui/shape_background.png");
        class_2960 selected = ClutterNoMore.location("textures/gui/selected_shape.png");
        int y = guiGraphics.method_51443() / 2 + 20;
        int centreX = guiGraphics.method_51421() / 2 - 8;
        int spacing = 22;
        float smoothing = 1.0f - (float)Math.exp(-5.0f * partialTick);
        this.currentIndex = class_3532.method_16439((float)smoothing, (float)this.currentIndex, (float)this.selectedIndex);
        if (((Boolean)ClutterNoMoreClient.CLIENT_CONFIG.SCROLLING.value()).booleanValue()) {
            int startX = class_3532.method_15375((float)((float)centreX - this.currentIndex * (float)spacing));
            RenderSystem.enableBlend();
            guiGraphics.method_25290(selected, centreX - 3, y - 3, 0.0f, 0.0f, 22, 22, 22, 22);
            for (int index = 0; index < this.shapes.size(); ++index) {
                int x = startX + index * spacing;
                RenderSystem.enableBlend();
                guiGraphics.method_25290(background, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.method_51427(this.shapes.get(index).method_7854(), x, y);
            }
        } else {
            int startX = class_3532.method_15375((float)((float)centreX - (float)this.shapes.size() / 2.0f * (float)spacing)) + spacing / 2;
            for (int index = 0; index < this.shapes.size(); ++index) {
                int x = startX + index * spacing;
                RenderSystem.enableBlend();
                guiGraphics.method_25290(background, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.method_51427(this.shapes.get(index).method_7854(), x, y);
            }
            RenderSystem.enableBlend();
            guiGraphics.method_25290(selected, class_3532.method_15375((float)((float)startX + this.currentIndex * (float)spacing)) - 3, y - 3, 0.0f, 0.0f, 22, 22, 22, 22);
        }
        RenderSystem.disableBlend();
    }

    public void onMouseScrolled(int direction) {
        this.changeSlot(this.selectedIndex - direction);
    }

    public void changeSlot(int newIndex) {
        int maxIndex = this.shapes.size() - 1;
        this.selectedIndex = newIndex;
        if (((Boolean)ClutterNoMoreClient.CLIENT_CONFIG.WRAP_SCROLLING.value()).booleanValue()) {
            if (this.selectedIndex < 0) {
                this.selectedIndex = maxIndex;
            }
            if (this.selectedIndex > maxIndex) {
                this.selectedIndex = 0;
            }
        } else {
            if (this.selectedIndex < 0) {
                this.selectedIndex = 0;
            }
            if (this.selectedIndex > maxIndex) {
                this.selectedIndex = maxIndex;
            }
        }
        class_1792 nextItem = this.shapes.get(this.selectedIndex);
        class_1799 next = nextItem.method_7854();
        next.method_7939(this.count);
        class_1657 player = (class_1657)Objects.requireNonNull(this.minecraft.field_1724);
        player.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.3f, 1.5f);
        player.method_6122(class_1268.field_5808, next);
        ClientPlayNetworking.send((class_8710)new ChangeStackPayload(-1, -1, next));
    }

    public boolean shouldStayOpenThisTick() {
        int selected = this.minecraft.field_1724.method_31548().field_7545;
        class_1799 heldStack = this.minecraft.field_1724.method_5998(class_1268.field_5808);
        this.count = heldStack.method_7947();
        return this.shapes.contains(heldStack.method_7909()) && selected == this.selected;
    }
}

