/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hwijinrpg.HwijinRpgMod;
import com.hwijinrpg.enumeration.Enumerable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public abstract class AbstractJsonConfig<KEY extends Enumerable, VALUE> {
    protected static final Gson gson = new Gson();

    protected abstract Map<KEY, VALUE> getConfig();

    protected abstract void initDefaultConfig();

    protected abstract Path getConfigPath();

    protected abstract VALUE convertValue(KEY var1, JsonElement var2);

    public void loadConfig() {
        block10: {
            this.initDefaultConfig();
            try {
                if (Files.exists(this.getConfigPath(), new LinkOption[0])) {
                    BufferedReader reader = Files.newBufferedReader(this.getConfigPath());
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    for (Enumerable type : this.getConfig().keySet()) {
                        if (!json.has(type.name())) continue;
                        this.getConfig().put(type, this.convertValue(type, json.get(type.name())));
                    }
                    break block10;
                }
                Files.createDirectories(this.getConfigPath().getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(this.getConfigPath(), new OpenOption[0]);){
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson(this.getConfig(), (Appendable)writer);
                }
            }
            catch (IOException e) {
                HwijinRpgMod.LOGGER.error("{} file load failed. message={}", (Object)this.getConfigPath(), (Object)e.getMessage());
            }
        }
    }
}

