/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.config;

import com.google.gson.JsonElement;
import com.hwijinrpg.config.AbstractJsonConfig;
import com.hwijinrpg.weapon.Material;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class WeaponAdditionalDamageConfig
extends AbstractJsonConfig<Material, Double> {
    private static final WeaponAdditionalDamageConfig INSTANCE = new WeaponAdditionalDamageConfig();
    private final Map<Material, Double> contexts = new HashMap<Material, Double>();

    public static WeaponAdditionalDamageConfig getInstance() {
        if (WeaponAdditionalDamageConfig.INSTANCE.contexts.isEmpty()) {
            INSTANCE.loadConfig();
        }
        return INSTANCE;
    }

    @Override
    protected Map<Material, Double> getConfig() {
        return this.contexts;
    }

    @Override
    protected void initDefaultConfig() {
        for (Material material : Material.values()) {
            this.contexts.put(material, material.getDefaultAdditionalDamage());
        }
    }

    @Override
    protected Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("hwijinrpg/additional_damage_by_material.json");
    }

    @Override
    protected Double convertValue(Material material, JsonElement value) {
        return value.getAsDouble();
    }

    public double getAdditionalDamage(Material material) {
        return this.contexts.getOrDefault(material, 0.0);
    }
}

