/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.gui;

import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.enumeration.ExperienceType;
import com.hwijinrpg.enumeration.ResetType;
import com.hwijinrpg.holder.PlayerDataHolder;
import com.hwijinrpg.holder.ServerDataHolder;
import com.hwijinrpg.job.Job;
import com.hwijinrpg.network.payload.RequestAbilityLevelUpPayload;
import com.hwijinrpg.network.payload.RequestChangeJobPayload;
import com.hwijinrpg.network.payload.RequestResetPayload;
import com.hwijinrpg.network.payload.RequestSkillLevelUpPayload;
import com.hwijinrpg.network.payload.SelectSkillPayload;
import com.hwijinrpg.skill.Skill;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class RpgMainScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_437 parent;

    public RpgMainScreen(class_437 parent) {
        this.parent = parent;
    }

    public OwoUIAdapter<FlowLayout> getAdapter() {
        return this.uiAdapter;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    public void build(FlowLayout root) {
        root.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of((int)7, (int)3, (int)7, (int)7));
        this.drawPlayerStatus(root);
        this.drawExperienceOfToday(root);
        this.drawCenter(root);
        this.drawFooter(root);
    }

    private void drawPlayerStatus(FlowLayout root) {
        FlowLayout header = Containers.verticalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fixed((int)((int)((double)this.field_22790 * 0.1))));
        FlowLayout headerRow = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        headerRow.child((Component)Components.label((class_2561)class_2561.method_43471((String)"header.level").method_27693(": " + PlayerDataHolder.syncedLevel)));
        headerRow.child((Component)Components.spacer((int)7));
        headerRow.child((Component)Components.label((class_2561)class_2561.method_43471((String)"header.experience").method_27693(": " + PlayerDataHolder.syncedExp + " / " + PlayerDataHolder.syncedExpToNext)));
        headerRow.child((Component)Components.spacer((int)7));
        headerRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)("AP: " + PlayerDataHolder.syncedAp))));
        headerRow.child((Component)Components.spacer((int)7));
        headerRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)("SP: " + PlayerDataHolder.syncedSp))));
        headerRow.child((Component)Components.spacer((int)7));
        headerRow.child((Component)Components.label((class_2561)class_2561.method_43471((String)"header.job").method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)PlayerDataHolder.currentJob.getDisplayNameKey()))));
        header.child((Component)headerRow.margins(Insets.of((int)3, (int)3, (int)0, (int)0)));
        root.child((Component)header);
        root.child((Component)Components.box((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fixed((int)1)).color(Color.ofRgb((int)444444)).margins(Insets.vertical((int)4)));
    }

    private void drawExperienceOfToday(FlowLayout root) {
        FlowLayout expLayout = Containers.verticalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.content());
        expLayout.child((Component)Components.label((class_2561)class_2561.method_43471((String)"experience_of_today").method_10862(class_2583.field_24360.method_10977(class_124.field_1054))).margins(Insets.of((int)3, (int)7, (int)5, (int)5)));
        FlowLayout leftColumn = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)50), (Sizing)Sizing.content()).margins(Insets.right((int)25));
        FlowLayout rightColumn = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)50), (Sizing)Sizing.content()).margins(Insets.right((int)30));
        AtomicInteger index = new AtomicInteger(0);
        PlayerDataHolder.experienceSummary.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ExperienceType)entry.getKey()).getSort())).forEach(entry -> {
            double current = (Double)entry.getValue();
            double max = ServerDataHolder.maxAccumulatedExperiencePerDays.get(entry.getKey());
            String translationKey = "experience_type." + ((ExperienceType)entry.getKey()).name().toLowerCase();
            class_5250 labelText = class_2561.method_43471((String)translationKey).method_54663(RpgMainScreen.getColorCode(current, max));
            class_5250 accumulated = class_2561.method_43470((String)String.format("%.1f / %.1f", Math.min(current, max), max)).method_54663(RpgMainScreen.getColorCode(current, max));
            Component icon = Components.item((class_1799)((ExperienceType)entry.getKey()).getIconItem()).tooltip((class_2561)class_2561.method_43471((String)((ExperienceType)entry.getKey()).getDescriptionKey())).sizing(Sizing.fixed((int)10), Sizing.fixed((int)10));
            BaseComponent label = Components.label((class_2561)labelText).margins(Insets.left((int)3));
            ParentComponent row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)18)).child(icon).child((Component)label).child((Component)Components.spacer()).child((Component)Components.label((class_2561)accumulated)).verticalAlignment(VerticalAlignment.CENTER);
            if (index.get() % 2 == 0) {
                leftColumn.child((Component)row);
            } else {
                rightColumn.child((Component)row);
            }
            index.getAndIncrement();
        });
        expLayout.child((Component)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).child((Component)leftColumn).child((Component)rightColumn).padding(Insets.left((int)7)));
        root.child((Component)Containers.verticalScroll((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fill((int)23), (Component)expLayout).scrollbar(ScrollContainer.Scrollbar.vanilla()).margins(Insets.bottom((int)5)));
        root.child((Component)Components.box((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fixed((int)1)).color(Color.ofRgb((int)444444)).margins(Insets.vertical((int)4)));
    }

    private void drawCenter(FlowLayout root) {
        FlowLayout center = Containers.horizontalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.content()).gap(10);
        this.drawAbilities(center);
        this.drawSkillsOrJobs(center);
        this.drawScroll(root, center);
    }

    private void drawAbilities(FlowLayout center) {
        FlowLayout abilities = Containers.verticalFlow((Sizing)Sizing.fill((int)50), (Sizing)Sizing.content());
        abilities.child((Component)Components.label((class_2561)class_2561.method_43471((String)"center.ability").method_10862(class_2583.field_24360.method_10977(class_124.field_1060))).margins(Insets.of((int)5, (int)7, (int)5, (int)5)));
        PlayerDataHolder.abilities.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((Ability)entry.getKey()).getSort())).forEach(ability -> {
            FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)18));
            int colorCode = RpgMainScreen.getColorCode(PlayerDataHolder.abilities.get(ability.getKey()), ServerDataHolder.getMaxLevel((Ability)ability.getKey()));
            row.child(Components.item((class_1799)((Ability)ability.getKey()).getIconItem()).tooltip(RpgMainScreen.getAbilityTooltip(ability, colorCode)).sizing(Sizing.fixed((int)10), Sizing.fixed((int)10)));
            row.child((Component)Components.label((class_2561)class_2561.method_43471((String)((Ability)ability.getKey()).getDisplayNameKey()).method_54663(colorCode)).margins(Insets.left((int)3)));
            row.child((Component)Components.spacer((int)100));
            row.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Lv " + String.valueOf(PlayerDataHolder.abilities.get(ability.getKey())) + "  ")).method_54663(colorCode)));
            row.child(Components.button((class_2561)class_2561.method_43470((String)"+"), btn -> this.handleAbilityLevelUp((Ability)ability.getKey())).active(PlayerDataHolder.abilities.get(ability.getKey()) < ServerDataHolder.getMaxLevel((Ability)ability.getKey())).tooltip(RpgMainScreen.getAbilityLevelUpTooltip(ability)).sizing(Sizing.fixed((int)14), Sizing.fixed((int)14)).margins(Insets.right((int)14)));
            abilities.child(row.verticalAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)4, (int)6, (int)0)));
        });
        center.child((Component)abilities);
    }

    private void drawSkillsOrJobs(FlowLayout center) {
        FlowLayout right = Containers.verticalFlow((Sizing)Sizing.fill((int)50), (Sizing)Sizing.content());
        boolean hasJob = PlayerDataHolder.currentJob != Job.BEGINNER;
        right.child((Component)Components.label((class_2561)class_2561.method_43471((String)(hasJob ? "center.skill" : "center.changeable_job")).method_10862(class_2583.field_24360.method_10977(class_124.field_1075))).margins(Insets.of((int)5, (int)7, (int)5, (int)5)));
        if (!hasJob) {
            RpgMainScreen.drawJobs(right);
        } else {
            this.drawSkills(right);
        }
        center.child((Component)right);
    }

    private static void drawJobs(FlowLayout right) {
        for (Job job : Job.getChangeableJobs()) {
            FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)18));
            row.child(Components.item((class_1799)job.getIconItem()).tooltip((class_2561)class_2561.method_43471((String)job.getDescriptionKey())).sizing(Sizing.fixed((int)10), Sizing.fixed((int)10)));
            row.child((Component)Components.label((class_2561)class_2561.method_43471((String)job.getDisplayNameKey())).margins(Insets.left((int)3)));
            row.child((Component)Components.spacer());
            row.child(Components.button((class_2561)class_2561.method_43471((String)"center.change_job"), btn -> RpgMainScreen.handleChangeJob(job)).tooltip((class_2561)class_2561.method_43469((String)"center.change_job_description", (Object[])new Object[]{ResetType.JOB.getRequiredDiamondCount()})).sizing(Sizing.fixed((int)50), Sizing.fixed((int)15)).margins(Insets.right((int)18)));
            right.child(row.verticalAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)4, (int)6, (int)0)));
        }
    }

    private void drawSkills(FlowLayout right) {
        PlayerDataHolder.skills.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((Skill)entry.getKey()).getSort())).forEach(skill -> {
            FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)18));
            int colorCode = RpgMainScreen.getColorCode(PlayerDataHolder.skills.get(skill.getKey()), ServerDataHolder.getMaxLevel((Skill)skill.getKey()));
            row.child(Components.item((class_1799)((Skill)skill.getKey()).getIconItem()).tooltip(RpgMainScreen.getSkillTooltip(skill)).sizing(Sizing.fixed((int)10), Sizing.fixed((int)10)));
            row.child((Component)Components.label((class_2561)class_2561.method_43471((String)((Skill)skill.getKey()).getDisplayNameKey()).method_54663(colorCode)).margins(Insets.left((int)3)));
            row.child((Component)Components.spacer());
            row.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Lv " + String.valueOf(PlayerDataHolder.skills.get(skill.getKey())) + "  ")).method_54663(colorCode)));
            if (PlayerDataHolder.currentSkill == skill.getKey()) {
                row.child(Components.button((class_2561)class_2561.method_43471((String)"center.unselect_skill_text"), btn -> this.handleSkillSelected(Skill.UNSELECT)).active((Integer)skill.getValue() > 0).tooltip((class_2561)class_2561.method_43471((String)"center.unselect_skill_description")).sizing(Sizing.fixed((int)25), Sizing.fixed((int)14)).margins(Insets.right((int)8)));
            } else {
                row.child(Components.button((class_2561)class_2561.method_43471((String)"center.select_skill_text"), btn -> this.handleSkillSelected((Skill)skill.getKey())).active((Integer)skill.getValue() > 0).tooltip((class_2561)class_2561.method_43471((String)"center.select_skill_description")).sizing(Sizing.fixed((int)25), Sizing.fixed((int)14)).margins(Insets.right((int)8)));
            }
            row.child(Components.button((class_2561)class_2561.method_43470((String)"+"), btn -> this.handleSkillLevelUp((Skill)skill.getKey())).active(PlayerDataHolder.skills.get(skill.getKey()) < ServerDataHolder.getMaxLevel((Skill)skill.getKey())).tooltip(RpgMainScreen.getSkillLevelUpTooltip(skill)).sizing(Sizing.fixed((int)14), Sizing.fixed((int)14)).margins(Insets.right((int)18)));
            right.child(row.verticalAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)4, (int)6, (int)0)));
        });
    }

    private void drawScroll(FlowLayout root, FlowLayout center) {
        ScrollContainer centerScroll = Containers.verticalScroll((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fixed((int)((int)((double)this.field_22790 * 0.42))), (Component)center).scrollbar(ScrollContainer.Scrollbar.vanilla());
        root.child((Component)centerScroll);
    }

    private void drawFooter(FlowLayout root) {
        FlowLayout footer = Containers.horizontalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.content()).gap(5);
        footer.child(Components.button((class_2561)class_2561.method_43471((String)"footer.reset_abilities"), btn -> this.requestReset(ResetType.AP)).sizing(Sizing.fixed((int)80), Sizing.fixed((int)18)).tooltip((class_2561)class_2561.method_43469((String)"footer_reset_abilities_description", (Object[])new Object[]{ResetType.AP.getRequiredDiamondCount()})));
        footer.child(Components.button((class_2561)class_2561.method_43471((String)"footer.reset_skills"), btn -> this.requestReset(ResetType.SP)).sizing(Sizing.fixed((int)80), Sizing.fixed((int)18)).tooltip((class_2561)class_2561.method_43469((String)"footer_reset_skills_description", (Object[])new Object[]{ResetType.SP.getRequiredDiamondCount()})));
        footer.child(Components.button((class_2561)class_2561.method_43471((String)"footer.reset_job"), btn -> this.requestReset(ResetType.JOB)).sizing(Sizing.fixed((int)80), Sizing.fixed((int)18)).tooltip((class_2561)class_2561.method_43469((String)"footer_reset_job_description", (Object[])new Object[]{ResetType.JOB.getRequiredDiamondCount()})));
        footer.child((Component)Components.spacer());
        footer.child(Components.button((class_2561)class_2561.method_43471((String)"footer.exit"), btn -> class_310.method_1551().method_1507(this.parent)).sizing(Sizing.fixed((int)50), Sizing.fixed((int)18)));
        FlowLayout footerContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fixed((int)((int)((double)this.field_22790 * 0.2))));
        footerContainer.child((Component)footer);
        root.child((Component)footerContainer.margins(Insets.top((int)5)));
    }

    private static class_2561 getAbilityTooltip(Map.Entry<Ability, Integer> ability, int colorCode) {
        class_5250 defaultTooltip = class_2561.method_43471((String)ability.getKey().getDescriptionKey());
        if (ability.getValue() < 1) {
            return defaultTooltip;
        }
        class_2561 additionalDescription = ServerDataHolder.simpleAbilityContexts.get(ability.getKey()).get(ability.getValue()).getAdditionalDescriptionAsText();
        return defaultTooltip.method_10852(additionalDescription).method_54663(colorCode);
    }

    private static class_2561 getAbilityLevelUpTooltip(Map.Entry<Ability, Integer> ability) {
        int requiredLevel = PlayerDataHolder.getRequiredLevelToNextLevel(ability.getKey());
        int requiredAp = PlayerDataHolder.getRequiredApToNextLevel(ability.getKey());
        class_5250 defaultToolTip = class_2561.method_43469((String)"center.level_up_ability_description", (Object[])new Object[]{requiredAp});
        if (ability.getValue() >= ServerDataHolder.getMaxLevel(ability.getKey())) {
            return defaultToolTip;
        }
        return defaultToolTip.method_27661().method_10852((class_2561)class_2561.method_43469((String)"ability.next_level", (Object[])new Object[]{ability.getValue() + 1})).method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"ability.required_level", (Object[])new Object[]{requiredLevel}).method_54663(requiredLevel <= PlayerDataHolder.syncedLevel ? -16711681 : -65536)).method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"ability.required_ap", (Object[])new Object[]{requiredAp}).method_54663(requiredAp <= PlayerDataHolder.syncedAp ? -16711681 : -65536)).method_27693("\n\n").method_10852(RpgMainScreen.getAbilityTooltip(new AbstractMap.SimpleEntry<Ability, Integer>(ability.getKey(), ability.getValue() + 1), -16711681)).method_54663(-16711681);
    }

    private static class_2561 getSkillTooltip(Map.Entry<Skill, Integer> skill) {
        class_5250 defaultTooltip = class_2561.method_43471((String)skill.getKey().getDescriptionKey());
        if (skill.getValue() < 1) {
            return defaultTooltip;
        }
        return defaultTooltip.method_10852(ServerDataHolder.getSkillContexts(skill.getKey()).get(skill.getValue()).getAdditionalDescriptionAsText()).method_54663(-16711681);
    }

    private static class_2561 getSkillLevelUpTooltip(Map.Entry<Skill, Integer> skill) {
        int requiredLevel = PlayerDataHolder.getRequiredLevelToNextLevel(skill.getKey());
        int requiredSp = PlayerDataHolder.getRequiredSpToNextLevel(skill.getKey());
        class_5250 defaultToolTip = class_2561.method_43469((String)"center.level_up_skill_description", (Object[])new Object[]{requiredSp});
        if (skill.getValue() >= ServerDataHolder.getMaxLevel(skill.getKey())) {
            return defaultToolTip;
        }
        return defaultToolTip.method_27661().method_10852((class_2561)class_2561.method_43469((String)"skill.next_level", (Object[])new Object[]{skill.getValue() + 1})).method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"skill.required_level", (Object[])new Object[]{requiredLevel}).method_54663(requiredLevel <= PlayerDataHolder.syncedLevel ? -16711681 : -65536)).method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"skill.required_sp", (Object[])new Object[]{requiredSp}).method_54663(requiredSp <= PlayerDataHolder.syncedSp ? -16711681 : -65536)).method_27693("\n\n").method_10852(RpgMainScreen.getSkillTooltip(new AbstractMap.SimpleEntry<Skill, Integer>(skill.getKey(), skill.getValue() + 1))).method_54663(-16711681);
    }

    private void handleSkillSelected(Skill skill) {
        ClientPlayNetworking.send((class_8710)new SelectSkillPayload(skill));
    }

    private void requestReset(ResetType type) {
        ClientPlayNetworking.send((class_8710)new RequestResetPayload(type));
    }

    private static void handleChangeJob(Job job) {
        ClientPlayNetworking.send((class_8710)new RequestChangeJobPayload(job));
    }

    private void handleAbilityLevelUp(Ability ability) {
        ClientPlayNetworking.send((class_8710)new RequestAbilityLevelUpPayload(ability));
    }

    private void handleSkillLevelUp(Skill skill) {
        ClientPlayNetworking.send((class_8710)new RequestSkillLevelUpPayload(skill));
    }

    private static int getColorCode(int current, int max) {
        return RpgMainScreen.getColorCode((double)current, (double)max);
    }

    private static int getColorCode(double current, double max) {
        if (current == 0.0) {
            return -1;
        }
        if (current < max) {
            return -16711936;
        }
        return -16711681;
    }

    public boolean method_25421() {
        return false;
    }
}

