/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.archer.chainshot;

import com.hwijinrpg.skill.archer.chainshot.ChainShotSkillContext;
import com.hwijinrpg.util.ArcherUtil;
import com.hwijinrpg.util.VectorUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class ChainShotDto {
    private final ChainShotSkillContext context;
    private final class_1799 itemStack;
    private final class_1799 shotFrom;
    private final Set<class_1309> damagedTargets;
    private final class_3222 shotPlayer;
    private final float speed;
    private class_1309 lastHitEntity;
    private class_243 lastArrowLocation;
    private class_243 direction;
    private int shotCount;
    private int tickPassedAfterLastArrow;

    public ChainShotDto(ChainShotSkillContext context, class_3222 player, class_1667 arrow) {
        this.context = context;
        this.itemStack = arrow.method_54759();
        this.shotFrom = arrow.method_59958();
        this.damagedTargets = new HashSet<class_1309>();
        this.shotPlayer = player;
        this.speed = (float)ArcherUtil.getSpeed(arrow);
        this.lastHitEntity = player;
        this.lastArrowLocation = player.method_73189();
        this.direction = arrow.method_5828(1.0f).method_1029();
        this.shotCount = 0;
        this.tickPassedAfterLastArrow = 0;
    }

    public void incrementTick() {
        ++this.tickPassedAfterLastArrow;
    }

    public boolean isMaxArrowCountReached() {
        return this.shotCount >= this.context.getMaxChainCount();
    }

    public void handleTargetHit(class_1309 target, class_1667 arrow) {
        this.damagedTargets.add(target);
        this.lastHitEntity = target;
        this.lastArrowLocation = arrow.method_73189();
        ++this.shotCount;
        this.tickPassedAfterLastArrow = 0;
    }

    public void changeDirection(class_1309 target) {
        class_243 targetVector = VectorUtil.getMiddlePos(target);
        this.direction = new class_243(targetVector.method_10216() - this.lastArrowLocation.method_10216(), targetVector.method_10214() - this.lastArrowLocation.method_10214(), targetVector.method_10215() - this.lastArrowLocation.method_10215()).method_1029();
    }

    public ChainShotSkillContext getContext() {
        return this.context;
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public class_1799 getShotFrom() {
        return this.shotFrom;
    }

    public Set<class_1309> getDamagedTargets() {
        return this.damagedTargets;
    }

    public class_3222 getShotPlayer() {
        return this.shotPlayer;
    }

    public float getSpeed() {
        return this.speed;
    }

    public class_1309 getLastHitEntity() {
        return this.lastHitEntity;
    }

    public class_243 getLastArrowLocation() {
        return this.lastArrowLocation;
    }

    public class_243 getDirection() {
        return this.direction;
    }

    public int getShotCount() {
        return this.shotCount;
    }

    public int getTickPassedAfterLastArrow() {
        return this.tickPassedAfterLastArrow;
    }
}

