/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.warrior.exposivesword;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.ability.context.FireElementSkillContext;
import com.hwijinrpg.ability.context.IceElementSkillContext;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.AbilityContextsByLevelConfig;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.warrior.exposivesword.ExplosiveSwordAdditionalDto;
import com.hwijinrpg.skill.warrior.exposivesword.ExplosiveSwordDto;
import com.hwijinrpg.skill.warrior.exposivesword.ExplosiveSwordSkillContext;
import com.hwijinrpg.util.DamageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;

public class ExplosiveSwordTracker
extends SkillTracker {
    private static final Map<UUID, ExplosiveSwordDto> ticks = new HashMap<UUID, ExplosiveSwordDto>();
    private static final Map<UUID, class_1542> thrownItems = new HashMap<UUID, class_1542>();
    private static final Map<UUID, List<ExplosiveSwordAdditionalDto>> additionalExplosions = new HashMap<UUID, List<ExplosiveSwordAdditionalDto>>();

    public static void start(class_3222 player) {
        ticks.put(player.method_5667(), new ExplosiveSwordDto());
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        ExplosiveSwordSkillContext context = (ExplosiveSwordSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.EXPLOSIVE_SWORD, comp.getSkills().get(Skill.EXPLOSIVE_SWORD), new TypeToken<ExplosiveSwordSkillContext>(){}.getType());
        ExplosiveSwordTracker.handleFirstExplosion(world, player, comp, context);
        ExplosiveSwordTracker.handleAdditionalExplosions(player, comp);
    }

    private static void handleFirstExplosion(class_1937 world, class_3222 player, PlayerRpgComponent comp, ExplosiveSwordSkillContext context) {
        ExplosiveSwordDto dto = ticks.get(player.method_5667());
        if (dto == null || context == null) {
            return;
        }
        if (dto.getTickPassed() < 2) {
            dto.incrementTick();
            return;
        }
        if (dto.getTickPassed() == 2) {
            dto.initCenterAndDirection((class_1657)player);
            ExplosiveSwordTracker.throwWeapon((class_1657)player, dto);
        }
        if (dto.getTickPassed() >= 2) {
            class_1542 item = thrownItems.get(player.method_5667());
            if (item == null) {
                ticks.remove(player.method_5667());
                return;
            }
            if (item.method_31481()) {
                ExplosiveSwordTracker.returnItemToPlayer(world, (class_1657)player, item);
                return;
            }
            class_243 newPos = dto.getCenter();
            ExplosiveSwordTracker.spawnParticlesOfSword((class_3218)world, comp, newPos);
            if (!dto.isReturning()) {
                ExplosiveSwordTracker.checkAndExplode((class_1657)player, dto, context, comp);
            } else {
                dto.updateDirection((class_1657)player);
                if (newPos.method_1022(player.method_73189()) < 2.0 || dto.getTickPassed() >= 200) {
                    ExplosiveSwordTracker.returnItemToPlayer(world, (class_1657)player, item);
                }
            }
            ExplosiveSwordTracker.checkAndDamageNearby((class_1657)player, dto, context);
            dto.moveCenterByTick();
            item.method_23327(dto.getCenter().field_1352, dto.getCenter().field_1351, dto.getCenter().field_1350);
            item.method_18799(dto.getDirection().method_1021(2.0));
            item.field_6007 = true;
        }
        dto.incrementTick();
    }

    private static void handleAdditionalExplosions(class_3222 player, PlayerRpgComponent comp) {
        List<ExplosiveSwordAdditionalDto> dtos = additionalExplosions.get(player.method_5667());
        if (dtos == null) {
            return;
        }
        Iterator<ExplosiveSwordAdditionalDto> it = dtos.iterator();
        while (it.hasNext()) {
            ExplosiveSwordAdditionalDto dto = it.next();
            dto.decrementTick();
            ExplosiveSwordTracker.spawnParticlesOfSword(player.method_51469(), comp, dto.getCurrentPos());
            if (dto.getTicksRemaining() > 0) continue;
            ExplosiveSwordTracker.performAdditionalExplosion((class_1657)player, dto.getExplosivePos(), dto.getContext());
            it.remove();
        }
    }

    private static void returnItemToPlayer(class_1937 world, class_1657 player, class_1542 item) {
        if (player.method_31548().method_7394(item.method_6983())) {
            world.method_60511(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15191, class_3419.field_15248, 1.0f, 1.0f);
            item.method_5650(class_1297.class_5529.field_26999);
        } else {
            player.method_7328(item.method_6983(), false);
        }
        ticks.remove(player.method_5667());
        thrownItems.remove(player.method_5667());
    }

    private static void throwWeapon(class_1657 player, ExplosiveSwordDto dto) {
        class_1799 weapon = player.method_6047().method_7972();
        player.method_31548().method_7378(player.method_6047());
        class_1542 swordEntity = new class_1542(player.method_73183(), dto.getCenter().field_1352, dto.getCenter().field_1351, dto.getCenter().field_1350, weapon);
        swordEntity.method_6982(Integer.MAX_VALUE);
        swordEntity.method_5684(true);
        player.method_73183().method_8649((class_1297)swordEntity);
        thrownItems.put(player.method_5667(), swordEntity);
        player.method_73183().method_60511(null, dto.getCenter().method_10216(), dto.getCenter().method_10214(), dto.getCenter().method_10215(), class_3417.field_15001, class_3419.field_15248, 1.0f, 0.7f);
    }

    private static void checkAndExplode(class_1657 player, ExplosiveSwordDto dto, ExplosiveSwordSkillContext context, PlayerRpgComponent comp) {
        class_2338 pos = class_2338.method_49638((class_2374)dto.getCenter());
        if (!dto.isReturning() && (player.method_73183().method_8320(pos).method_26212((class_1922)player.method_73183(), pos) || (float)dto.getTickPassed() >= context.getMaxDistance())) {
            ExplosiveSwordTracker.explode(player, dto.getCenter(), context);
            ExplosiveSwordTracker.scheduleAdditionalExplosions(player, dto.getCenter(), context, comp);
            dto.returnSword();
        }
    }

    private static void scheduleAdditionalExplosions(class_1657 player, class_243 currentPos, ExplosiveSwordSkillContext context, PlayerRpgComponent comp) {
        int count = comp.getSkills().get(Skill.EXPLOSIVE_SWORD) + 2;
        ArrayList<ExplosiveSwordAdditionalDto> list = new ArrayList<ExplosiveSwordAdditionalDto>();
        for (int i = 0; i < count; ++i) {
            class_243 offset = new class_243(Math.random() * 10.0 * Math.pow(-1.0, i % 2), (Math.random() - 0.5) * 5.0 + 1.0, Math.random() * 10.0 * Math.pow(-1.0, i % 3));
            class_243 explosionPos = currentPos.method_1019(offset);
            int delay = 15 + i * 3;
            list.add(new ExplosiveSwordAdditionalDto(context, currentPos, explosionPos, delay));
        }
        additionalExplosions.put(player.method_5667(), list);
    }

    private static void checkAndDamageNearby(class_1657 player, ExplosiveSwordDto dto, ExplosiveSwordSkillContext context) {
        class_1937 world = player.method_73183();
        class_238 hitbox = new class_238(dto.getCenter().method_1023(0.7, 0.7, 0.7), dto.getCenter().method_1031(0.7, 0.7, 0.7));
        for (class_1309 target : world.method_8390(class_1309.class, hitbox, e -> ExplosiveSwordTracker.isDamageableEntity((class_1309)player, e))) {
            DamageUtil.damageTargetWithElement(player, target, context.getPassDamage());
            world.method_43128(null, target.method_23317(), target.method_23318(), target.method_23321(), class_3417.field_14940, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    private static void explode(class_1657 player, class_243 pos, ExplosiveSwordSkillContext context) {
        class_1937 world = player.method_73183();
        world.method_60511(null, pos.field_1352, pos.field_1351, pos.field_1350, (class_6880)class_3417.field_15152, class_3419.field_15248, 2.0f, 1.6f);
        ((class_3218)player.method_73183()).method_65096((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351, pos.field_1350, 20 + (int)(context.getExplosiveArea() * 2.0), 1.0, 1.0, 1.0, 0.1);
        ExplosiveSwordTracker.makeExplosiveEffect(player, pos, context);
        class_238 explosionBox = new class_238(pos.method_1023(context.getExplosiveArea() / 1.7, context.getExplosiveArea() / 1.7, context.getExplosiveArea() / 1.7), pos.method_1031(context.getExplosiveArea() / 1.7, context.getExplosiveArea() / 1.7, context.getExplosiveArea() / 1.7));
        for (class_1309 target : world.method_8390(class_1309.class, explosionBox, e -> ExplosiveSwordTracker.isDamageableEntity((class_1309)player, e))) {
            DamageUtil.damageTargetWithElement(player, target, context.getDamage());
        }
    }

    private static void makeExplosiveEffect(class_1657 player, class_243 pos, ExplosiveSwordSkillContext context) {
        ((class_3218)player.method_73183()).method_65096((class_2394)class_2398.field_11221, pos.field_1352, pos.field_1351, pos.field_1350, (int)context.getExplosiveArea() / 2, 0.5, 0.5, 0.5, 1.0);
        ((class_3218)player.method_73183()).method_65096((class_2394)class_2398.field_11240, pos.field_1352, pos.field_1351, pos.field_1350, 20, 0.0, 0.0, 0.0, 1.0);
        ((class_3218)player.method_73183()).method_65096((class_2394)class_2398.field_22246, pos.field_1352, pos.field_1351, pos.field_1350, (int)(20.0 + context.getExplosiveArea() * 2.0), 0.0, 0.0, 0.0, 1.0);
        for (int i = 0; i < 8; ++i) {
            int direction = i >= 6 ? 1 : -1;
            ((class_3218)player.method_73183()).method_65096((class_2394)class_2398.field_11221, pos.method_10216() + (double)direction * context.getExplosiveArea() / 2.5 * Math.sin(i * 45), pos.method_10214(), pos.method_10215() + (double)direction * context.getExplosiveArea() / 2.5 * Math.cos(i * 45), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void performAdditionalExplosion(class_1657 player, class_243 explosionPos, ExplosiveSwordSkillContext context) {
        class_1937 world = player.method_73183();
        ((class_3218)world).method_65096((class_2394)class_2398.field_22246, explosionPos.field_1352, explosionPos.field_1351, explosionPos.field_1350, 10, 0.2, 0.2, 0.2, 0.5);
        ((class_3218)world).method_65096((class_2394)class_2398.field_11236, explosionPos.field_1352, explosionPos.field_1351, explosionPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        world.method_60511(null, explosionPos.field_1352, explosionPos.field_1351, explosionPos.field_1350, (class_6880)class_3417.field_15152, class_3419.field_15248, 1.2f, 2.0f);
        class_238 box = new class_238(explosionPos.method_1023(context.getExplosiveArea() / 5.0, context.getExplosiveArea() / 5.0, context.getExplosiveArea() / 5.0), explosionPos.method_1031(context.getExplosiveArea() / 5.0, context.getExplosiveArea() / 5.0, context.getExplosiveArea() / 5.0));
        for (class_1309 target : world.method_8390(class_1309.class, box, e -> ExplosiveSwordTracker.isDamageableEntity((class_1309)player, e))) {
            DamageUtil.damageTargetWithElement(player, target, context.getAdditionalDamage());
        }
    }

    private static void spawnParticlesOfSword(class_3218 world, PlayerRpgComponent comp, class_243 pos) {
        FireElementSkillContext fireContext = (FireElementSkillContext)AbilityContextsByLevelConfig.getInstance().getAbilityContext(Ability.FIRE_ELEMENT_SKILL, comp.getAbilities().get(Ability.FIRE_ELEMENT_SKILL), new TypeToken<FireElementSkillContext>(){}.getType());
        IceElementSkillContext iceContext = (IceElementSkillContext)AbilityContextsByLevelConfig.getInstance().getAbilityContext(Ability.ICE_ELEMENT_SKILL, comp.getAbilities().get(Ability.ICE_ELEMENT_SKILL), new TypeToken<IceElementSkillContext>(){}.getType());
        if (fireContext != null) {
            world.method_65096((class_2394)class_2398.field_11240, pos.method_10216(), pos.method_10214() + 0.2, pos.method_10215(), 3, 0.0, 0.0, 0.0, 0.0);
        } else if (iceContext != null) {
            world.method_65096((class_2394)class_2398.field_28013, pos.method_10216(), pos.method_10214() + 0.2, pos.method_10215(), 3, 0.0, 0.0, 0.0, 0.0);
        } else {
            world.method_65096((class_2394)class_2398.field_11205, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, 3, 0.1, 0.1, 0.1, 0.1);
        }
    }
}

