/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.util;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.ability.context.ExplosiveElementSkillContext;
import com.hwijinrpg.ability.context.FireElementSkillContext;
import com.hwijinrpg.ability.context.IceElementSkillContext;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.config.AbilityContextsByLevelConfig;
import com.hwijinrpg.util.DelayedTaskUtil;
import com.hwijinrpg.util.VectorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class ElementAbilityUtil {
    private static final Map<UUID, List<class_3545<String, Double>>> frozenTargets = new ConcurrentHashMap<UUID, List<class_3545<String, Double>>>();

    public static double applyElementAndGetElementDamage(class_1657 player, class_1309 target) {
        PlayerRpgComponent comp = (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player);
        class_3218 world = (class_3218)target.method_73183();
        double totalDamage = 0.0;
        FireElementSkillContext fire = (FireElementSkillContext)AbilityContextsByLevelConfig.getInstance().getAbilityContext(Ability.FIRE_ELEMENT_SKILL, comp.getAbilities().get(Ability.FIRE_ELEMENT_SKILL), new TypeToken<FireElementSkillContext>(){}.getType());
        IceElementSkillContext ice = (IceElementSkillContext)AbilityContextsByLevelConfig.getInstance().getAbilityContext(Ability.ICE_ELEMENT_SKILL, comp.getAbilities().get(Ability.ICE_ELEMENT_SKILL), new TypeToken<IceElementSkillContext>(){}.getType());
        ExplosiveElementSkillContext explosive = (ExplosiveElementSkillContext)AbilityContextsByLevelConfig.getInstance().getAbilityContext(Ability.EXPLOSIVE_ELEMENT_SKILL, comp.getAbilities().get(Ability.EXPLOSIVE_ELEMENT_SKILL), new TypeToken<ExplosiveElementSkillContext>(){}.getType());
        if (fire != null) {
            ElementAbilityUtil.handleFireElementAttack(world, target, fire);
            totalDamage += fire.getDamage();
        }
        if (ice != null) {
            ElementAbilityUtil.handleIceElementAttack(world, target, ice);
            totalDamage += ice.getDamage();
        }
        if (explosive != null) {
            ElementAbilityUtil.handleExplosiveElementAttack(world, player, target, explosive);
            totalDamage += explosive.getDamage();
        }
        return totalDamage;
    }

    private static void handleFireElementAttack(class_3218 world, class_1309 target, FireElementSkillContext ctx) {
        target.method_5639((float)((int)Math.max(1L, Math.round(ctx.getBurningSeconds()))));
        world.method_8396(null, class_2338.method_49638((class_2374)target.method_73189()), class_3417.field_14623, class_3419.field_15248, 0.8f, 0.8f);
    }

    private static void handleIceElementAttack(class_3218 world, class_1309 target, IceElementSkillContext ctx) {
        class_1324 inst = target.method_5996(class_5134.field_23719);
        if (inst == null) {
            return;
        }
        int freezingTicks = (int)(ctx.getFreezingSeconds() * 20.0);
        target.method_32317(Math.max(target.method_32312(), freezingTicks));
        frozenTargets.putIfAbsent(target.method_5667(), new ArrayList());
        List<class_3545<String, Double>> frozenContext = frozenTargets.get(target.method_5667());
        double previousBaseValue = inst.method_6201();
        if (frozenContext.isEmpty()) {
            inst.method_6192(previousBaseValue * (1.0 - ctx.getSlowAmount()));
        }
        String traceId = UUID.randomUUID().toString();
        frozenContext.add((class_3545<String, Double>)new class_3545((Object)traceId, (Object)previousBaseValue));
        world.method_8396(null, class_2338.method_49638((class_2374)target.method_73189()), class_3417.field_27853, class_3419.field_15248, 1.2f, 1.5f);
        world.method_8396(null, class_2338.method_49638((class_2374)target.method_73189()), class_3417.field_15081, class_3419.field_15248, 1.0f, 2.0f);
        int steps = Math.max(1, (int)Math.ceil(ctx.getFreezingSeconds() / 0.1));
        for (int i = 0; i < steps; ++i) {
            int delay = i * 2 + 1;
            DelayedTaskUtil.runLater(delay, () -> {
                class_243 loc = VectorUtil.getMiddlePos(target);
                world.method_65096((class_2394)class_2398.field_28013, loc.field_1352, loc.field_1351, loc.field_1350, 5, 0.0, 0.0, 0.0, 0.01);
            });
        }
        DelayedTaskUtil.runLater(freezingTicks, () -> {
            class_1324 inst2 = target.method_5996(class_5134.field_23719);
            if (inst2 != null && !frozenContext.isEmpty() && Objects.equals(((class_3545)frozenContext.getLast()).method_15442(), traceId)) {
                inst2.method_6192(((Double)((class_3545)frozenContext.getFirst()).method_15441()).doubleValue());
                frozenTargets.remove(target.method_5667());
            }
        });
    }

    private static void handleExplosiveElementAttack(class_3218 world, class_1657 player, class_1309 target, ExplosiveElementSkillContext ctx) {
        class_243 mid = VectorUtil.getMiddlePos(target);
        world.method_65096((class_2394)class_2398.field_11236, mid.field_1352, mid.field_1351, mid.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        world.method_60511(null, mid.field_1352, mid.field_1351, mid.field_1350, (class_6880)class_3417.field_15152, class_3419.field_15248, 0.8f, 2.0f);
        double r = ctx.getExplosionRadius();
        class_238 box = new class_238(mid.method_1031(-r, -r, -r), mid.method_1031(r, r, r));
        world.method_8333((class_1297)player, box, e -> {
            class_1309 livingEntity;
            return e instanceof class_1309 && !Objects.equals(livingEntity = (class_1309)e, target);
        }).forEach(e -> e.method_64397((class_3218)player.method_73183(), player.method_48923().method_48802(player), (float)ctx.getDamage()));
    }
}

