/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.util;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.ability.context.IncreaseBlockBreakSpeedContext;
import com.hwijinrpg.ability.context.IncreaseHpContext;
import com.hwijinrpg.ability.context.IncreaseMovementSpeedContext;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.AbilityContextsByLevelConfig;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class PersistentAbilityUtil {
    public static void handleIncreaseHp(class_3222 player, PlayerRpgComponent comp) {
        class_1324 attribute = player.method_5996(class_5134.field_23716);
        if (attribute == null) {
            return;
        }
        Integer abilityLevel = comp.getAbilities().get(Ability.INCREASE_HP);
        class_2960 identifier = class_2960.method_60654((String)Ability.INCREASE_HP.name().toLowerCase());
        float originalHealth = player.method_6032();
        attribute.method_6200(identifier);
        if (abilityLevel > 0) {
            IncreaseHpContext context = (IncreaseHpContext)AbilityContextsByLevelConfig.getInstance().getAbilityContext(Ability.INCREASE_HP, abilityLevel, new TypeToken<IncreaseHpContext>(){}.getType());
            attribute.method_26835(new class_1322(identifier, (double)(context.getAmount() - 20), class_1322.class_1323.field_6328));
            if (player.method_6063() >= originalHealth) {
                player.method_6033(originalHealth);
            }
        }
    }

    public static void handleMovementSpeedAndJumpStrength(class_3222 player, PlayerRpgComponent comp) {
        class_1324 movementSpeedAttribute = player.method_5996(class_5134.field_23719);
        class_1324 jumpStrengthAttribute = player.method_5996(class_5134.field_23728);
        class_1324 safeFallDistanceAttribute = player.method_5996(class_5134.field_49079);
        if (movementSpeedAttribute == null || jumpStrengthAttribute == null || safeFallDistanceAttribute == null) {
            return;
        }
        Integer abilityLevel = comp.getAbilities().get(Ability.INCREASE_MOVEMENT_SPEED_AND_JUMP_STRENGTH);
        class_2960 identifier = class_2960.method_60654((String)Ability.INCREASE_MOVEMENT_SPEED_AND_JUMP_STRENGTH.name().toLowerCase());
        movementSpeedAttribute.method_6200(identifier);
        jumpStrengthAttribute.method_6200(identifier);
        safeFallDistanceAttribute.method_6200(identifier);
        if (abilityLevel > 0) {
            IncreaseMovementSpeedContext context = (IncreaseMovementSpeedContext)AbilityContextsByLevelConfig.getInstance().getAbilityContext(Ability.INCREASE_MOVEMENT_SPEED_AND_JUMP_STRENGTH, abilityLevel, new TypeToken<IncreaseMovementSpeedContext>(){}.getType());
            movementSpeedAttribute.method_26835(new class_1322(identifier, context.getMovementSpeedIncreasedAmount(), class_1322.class_1323.field_6330));
            jumpStrengthAttribute.method_26835(new class_1322(identifier, context.getJumpStrengthIncreasedAmount(), class_1322.class_1323.field_6330));
            safeFallDistanceAttribute.method_26835(new class_1322(identifier, context.getJumpStrengthIncreasedAmount() * 3.4, class_1322.class_1323.field_6330));
        }
    }

    public static void handleBlockBreakSpeed(class_3222 player, PlayerRpgComponent comp) {
        class_1324 attribute = player.method_5996(class_5134.field_49076);
        if (attribute == null) {
            return;
        }
        Integer abilityLevel = comp.getAbilities().get(Ability.INCREASE_BLOCK_BREAK_SPEED);
        class_2960 identifier = class_2960.method_60654((String)Ability.INCREASE_BLOCK_BREAK_SPEED.name().toLowerCase());
        attribute.method_6200(identifier);
        if (abilityLevel > 0) {
            IncreaseBlockBreakSpeedContext context = (IncreaseBlockBreakSpeedContext)AbilityContextsByLevelConfig.getInstance().getAbilityContext(Ability.INCREASE_BLOCK_BREAK_SPEED, abilityLevel, new TypeToken<IncreaseBlockBreakSpeedContext>(){}.getType());
            attribute.method_26835(new class_1322(identifier, context.getAmount(), class_1322.class_1323.field_6330));
        }
    }

    public static void handleResetAbility(class_3222 player, PlayerRpgComponent comp) {
        PersistentAbilityUtil.handleIncreaseHp(player, comp);
        PersistentAbilityUtil.handleMovementSpeedAndJumpStrength(player, comp);
        PersistentAbilityUtil.handleBlockBreakSpeed(player, comp);
    }
}

