/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.ability.tracker;

import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.skill.archer.arrowrain.ArrowRainDto;
import com.hwijinrpg.skill.archer.arrowrain.ArrowRainTracker;
import com.hwijinrpg.skill.archer.chainshot.ChainShotTracker;
import com.hwijinrpg.skill.archer.gravityarrow.GravityArrowTracker;
import com.hwijinrpg.skill.archer.multishot.MultiShotTracker;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1676;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class AbilityTracker {
    public static void tick(MinecraftServer server) {
        AbilityTracker.handleElementAbility(server);
    }

    private static void handleElementAbility(MinecraftServer server) {
        AbilityTracker.handleFireElement(server);
    }

    private static void handleFireElement(MinecraftServer server) {
        Set<UUID> multiShotArrowUuids = MultiShotTracker.firedArrows.keySet();
        Set<UUID> chainShotArrowUuids = ChainShotTracker.firedArrows.keySet();
        Set arrowRainArrowUuids = Stream.concat(ArrowRainTracker.firedArrows.keySet().stream(), ArrowRainTracker.firedArrows.values().stream().map(ArrowRainDto::getRainedArrows).flatMap(Collection::stream).map(class_1297::method_5667)).collect(Collectors.toSet());
        Set<UUID> gravityArrowArrowUuids = GravityArrowTracker.firedArrows.keySet();
        Set<class_1667> arrows = Stream.concat(Stream.concat(multiShotArrowUuids.stream(), chainShotArrowUuids.stream()), Stream.concat(arrowRainArrowUuids.stream(), gravityArrowArrowUuids.stream())).map(uuid -> AbilityTracker.findArrowByUuid(server, uuid)).filter(Objects::nonNull).filter(arrow -> arrow.field_6012 < 120).filter(arrow -> arrow.method_24921() instanceof class_1657).collect(Collectors.toSet());
        Map playerCompMap = arrows.stream().map(class_1676::method_24921).filter(Objects::nonNull).distinct().map(e -> (class_1657)e).collect(Collectors.toMap(Function.identity(), p -> (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get(p)));
        arrows.forEach(arrow -> {
            PlayerRpgComponent comp = (PlayerRpgComponent)playerCompMap.get((class_1657)arrow.method_24921());
            if (comp != null && comp.getAbilities().get(Ability.FIRE_ELEMENT_SKILL) > 0) {
                ((class_3218)arrow.method_73183()).method_65096((class_2394)class_2398.field_11240, arrow.method_23317(), arrow.method_23318(), arrow.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (comp != null && comp.getAbilities().get(Ability.ICE_ELEMENT_SKILL) > 0) {
                ((class_3218)arrow.method_73183()).method_65096((class_2394)class_2398.field_28013, arrow.method_23317(), arrow.method_23318(), arrow.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        });
    }

    private static class_1667 findArrowByUuid(MinecraftServer server, UUID uuid) {
        for (class_3218 world : server.method_3738()) {
            for (class_1297 entity : world.method_27909()) {
                if (!(entity instanceof class_1667)) continue;
                class_1667 arrow = (class_1667)entity;
                if (!entity.method_5667().equals(uuid)) continue;
                return arrow;
            }
        }
        return null;
    }
}

