/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.event;

import com.hwijinrpg.holder.PlayerDataHolder;
import com.hwijinrpg.holder.ServerDataHolder;
import com.hwijinrpg.skill.Skill;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.hud.Hud;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ClientTickHandler {
    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            ClientTickHandler.handleSkillCoolTime();
            ClientTickHandler.showSkillCoolTime(client);
        });
    }

    private static void handleSkillCoolTime() {
        PlayerDataHolder.skillCoolTimeByTicks.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).forEach(entry -> PlayerDataHolder.skillCoolTimeByTicks.put((Skill)entry.getKey(), (Integer)entry.getValue() - 1));
    }

    private static void showSkillCoolTime(class_310 client) {
        class_2960 skillCoolTimeIdentifier = class_2960.method_60655((String)"hwijinrpg", (String)"skill_cool_time_hud");
        if (client.field_1687 != null && client.field_1724 != null) {
            Hud.remove((class_2960)skillCoolTimeIdentifier);
            ClientTickHandler.showHuds(skillCoolTimeIdentifier);
        }
    }

    private static void showHuds(class_2960 skillCoolTimeIdentifier) {
        Hud.add((class_2960)skillCoolTimeIdentifier, () -> {
            FlowLayout root = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fill((int)50)).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP).positioning(Positioning.relative((int)94, (int)1));
            root.padding(Insets.of((int)2));
            Skill selected = PlayerDataHolder.currentSkill;
            if (selected != null) {
                FlowLayout header = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).horizontalAlignment(HorizontalAlignment.RIGHT).verticalAlignment(VerticalAlignment.CENTER);
                header.gap(2);
                header.padding(Insets.of((int)3, (int)3, (int)3, (int)1));
                header.child((Component)Components.label((class_2561)class_2561.method_43471((String)"hud.current_skill")));
                header.child(Components.item((class_1799)selected.getIconItem()).sizing(Sizing.fixed((int)10), Sizing.fixed((int)10)));
                header.child(Components.label((class_2561)class_2561.method_43471((String)selected.getDisplayNameKey())).shadow(true).sizing(Sizing.content(), Sizing.content()));
                root.child((Component)header.margins(Insets.bottom((int)4)));
            }
            for (Skill skill : Skill.values()) {
                int ticks = PlayerDataHolder.skillCoolTimeByTicks.getOrDefault(skill, 0);
                if (ticks <= 0) continue;
                FlowLayout row = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).horizontalAlignment(HorizontalAlignment.RIGHT).verticalAlignment(VerticalAlignment.CENTER);
                row.gap(3);
                row.child(Components.item((class_1799)skill.getIconItem()).sizing(Sizing.fixed((int)10), Sizing.fixed((int)10)));
                row.child(Components.label((class_2561)class_2561.method_43471((String)skill.getDisplayNameKey())).shadow(true).sizing(Sizing.content(), Sizing.content()));
                FlowLayout progressContainer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)35), (Sizing)Sizing.fixed((int)8));
                progressContainer.child((Component)Components.box((Sizing)Sizing.fixed((int)35), (Sizing)Sizing.fixed((int)8)).color(Color.ofRgb((int)0x333333)).fill(true));
                int level = PlayerDataHolder.skills.getOrDefault(skill, 0);
                double maxTicks = ServerDataHolder.getSkillContexts(skill).get(level).getCoolTimeSeconds() * 20.0;
                double progress = Math.max(0.0, Math.min(1.0, (double)ticks / maxTicks));
                progressContainer.child((Component)Components.box((Sizing)Sizing.fixed((int)((int)(40.0 * progress))), (Sizing)Sizing.fixed((int)8)).color(Color.ofRgb((int)65280)).fill(true).positioning(Positioning.absolute((int)0, (int)0)));
                row.child((Component)progressContainer.margins(Insets.of((int)1, (int)1, (int)1, (int)0)));
                root.child((Component)row.margins(Insets.of((int)1)));
            }
            return root;
        });
    }
}

