/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.mage.astrafield;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.mage.astrafield.AstraFieldDto;
import com.hwijinrpg.skill.mage.astrafield.AstraFieldSkillContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class AstraFieldTracker {
    private static final Map<UUID, AstraFieldDto> ticks = new HashMap<UUID, AstraFieldDto>();

    public static void start(class_3222 player) {
        ticks.put(player.method_5667(), new AstraFieldDto((class_1657)player));
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        AstraFieldSkillContext context = (AstraFieldSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.ASTRA_FIELD, comp.getSkills().get(Skill.ASTRA_FIELD), new TypeToken<AstraFieldSkillContext>(){}.getType());
        AstraFieldDto dto = ticks.get(player.method_5667());
        if (dto == null || context == null || dto.getTickPassed() >= context.getContinuanceSeconds() * 20) {
            AstraFieldTracker.cancel(player.method_5667());
            return;
        }
        AstraFieldTracker.drawMagicCircle((class_3218)world, context, dto.getCenter(), dto.getTickPassed());
        if (dto.getTickPassed() % 40 == 0) {
            world.method_43128(null, dto.getCenter().method_10216(), dto.getCenter().method_10214(), dto.getCenter().method_10215(), class_3417.field_15045, class_3419.field_15248, 0.7f, 1.8f);
            world.method_43128(null, dto.getCenter().method_10216(), dto.getCenter().method_10214(), dto.getCenter().method_10215(), class_3417.field_15193, class_3419.field_15248, 0.2f, 1.8f);
        }
        if ((float)dto.getTickPassed() % (20.0f * context.getFeedHungerPeriodSeconds()) == 0.0f) {
            AstraFieldTracker.restoreHunger((class_3218)world, dto.getCenter(), context.getRadius());
        }
        if ((float)dto.getTickPassed() % (20.0f * context.getHealPeriodSeconds()) == 0.0f) {
            AstraFieldTracker.restoreHealth((class_3218)world, dto.getCenter(), context.getRadius());
        }
        if (dto.getTickPassed() % 40 == 0) {
            AstraFieldTracker.damageEnemies(dto.getCenter(), context.getRadius());
        }
        dto.incrementTick();
    }

    private static void cancel(UUID uuid) {
        ticks.remove(uuid);
    }

    public static void drawMagicCircle(class_3218 world, AstraFieldSkillContext context, class_243 center, int tickPassed) {
        int i;
        if (tickPassed % 5 != 0) {
            return;
        }
        double timeFactor = (double)tickPassed / 20.0;
        double radius = context.getRadius();
        int outerParticles = (int)(radius * 12.0);
        for (int i2 = 0; i2 < outerParticles; ++i2) {
            double angle = Math.PI * 2 * (double)i2 / (double)outerParticles + timeFactor * 0.3;
            double x = center.field_1352 + radius * Math.cos(angle);
            double z = center.field_1350 + radius * Math.sin(angle);
            world.method_65096((class_2394)class_2398.field_29645, x, center.field_1351 + 0.2, z, 1, 0.01, 0.01, 0.01, 0.01);
        }
        int starPoints = 5;
        for (i = 0; i < starPoints; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)starPoints - timeFactor * 1.5;
            double x = center.field_1352 + radius * 0.7 * Math.cos(angle);
            double z = center.field_1350 + radius * 0.7 * Math.sin(angle);
            class_2390 dust = new class_2390(65280, 1.0f);
            world.method_65096((class_2394)dust, x, center.field_1351 + 0.1, z, 1, 0.01, 0.01, 0.01, 0.01);
        }
        if (tickPassed % 10 == 0) {
            world.method_65096((class_2394)class_2398.field_11215, center.field_1352, center.field_1351 + 0.5, center.field_1350, 50, radius * 0.5, 0.5, radius * 0.5, 0.05);
        }
        if (tickPassed % 20 == 0) {
            for (i = 0; i < 4; ++i) {
                double randomAngle = Math.random() * 2.0 * Math.PI;
                double randomRadius = Math.random() * radius * 0.8;
                double x = center.field_1352 + randomRadius * Math.cos(randomAngle);
                double z = center.field_1350 + randomRadius * Math.sin(randomAngle);
                world.method_65096((class_2394)class_2398.field_11249, x, center.field_1351 + 0.3, z, 10, 0.2, 0.0, 0.2, 0.0);
            }
        }
        if (tickPassed % 15 == 0) {
            world.method_65096((class_2394)class_2398.field_11205, center.field_1352, center.field_1351 + 0.3, center.field_1350, 30, radius * 0.7, 0.1, radius * 0.7, 0.05);
        }
        int orbParticles = 5;
        for (int i3 = 0; i3 < orbParticles; ++i3) {
            double angle = Math.PI * 2 * (double)i3 / (double)orbParticles + timeFactor * 0.8;
            double x = center.field_1352 + radius * 1.1 * Math.cos(angle);
            double z = center.field_1350 + radius * 1.1 * Math.sin(angle);
            double yOffset = 0.5 + Math.sin(timeFactor + (double)i3) * 0.3;
            world.method_65096((class_2394)class_2398.field_22246, x, center.field_1351 + yOffset, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void restoreHunger(class_3218 world, class_243 center, float radius) {
        for (class_3222 player : world.method_18456()) {
            if (!(player.method_73189().method_1022(center) <= (double)radius)) continue;
            int newFoodLevel = Math.min(player.method_7344().method_7586() + 1, 20);
            player.method_7344().method_7580(newFoodLevel);
            world.method_65096((class_2394)class_2398.field_11201, player.method_23317(), player.method_23318() + 1.5, player.method_23321(), 3, 0.3, 0.3, 0.3, 0.0);
        }
    }

    public static void restoreHealth(class_3218 world, class_243 center, float radius) {
        for (class_3222 player : world.method_18456()) {
            if (!(player.method_73189().method_1022(center) <= (double)radius)) continue;
            float maxHealth = player.method_6063();
            float newHealth = Math.min(player.method_6032() + 1.0f, maxHealth);
            player.method_6033(newHealth);
            world.method_65096((class_2394)class_2398.field_11211, player.method_23317(), player.method_23318() + 1.5, player.method_23321(), 3, 0.3, 0.3, 0.3, 0.0);
        }
    }

    private static void damageEnemies(class_243 center, float radius) {
    }
}

