/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.component;

import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.config.AbilityContextsByLevelConfig;
import com.hwijinrpg.config.ExperienceMaxAccumulatedAmountPerDayConfig;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.enumeration.ExperienceType;
import com.hwijinrpg.interfaces.PlayerData;
import com.hwijinrpg.job.Job;
import com.hwijinrpg.skill.Skill;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.ladysnake.cca.api.v3.component.Component;

public class PlayerRpgComponent
implements Component,
PlayerData {
    private Map<ExperienceType, Double> accumulatedExps = Arrays.stream(ExperienceType.values()).collect(Collectors.toMap(Function.identity(), experienceType -> 0.0));
    private Map<Ability, Integer> abilities = Arrays.stream(Ability.values()).collect(Collectors.toMap(Function.identity(), ability -> 0));
    private Map<Skill, Integer> skills = Arrays.stream(Skill.values()).collect(Collectors.toMap(Function.identity(), skill -> 0));
    private Map<Skill, Integer> skillCoolTimeByTicks = Arrays.stream(Skill.values()).collect(Collectors.toMap(Function.identity(), skill -> 0));
    private LocalDate lastResetDate = LocalDate.now();
    private int ap = 0;
    private int sp = 0;
    private int level = 1;
    private double experience = 0.0;
    private Skill currentSkill = null;
    private Job job = Job.BEGINNER;

    public double getAccumulatedExps(ExperienceType type) {
        return this.accumulatedExps.getOrDefault(type, 0.0);
    }

    public void addExperienceWithLimit(class_3222 player, ExperienceType type, double amount) {
        double limit;
        double current = this.getAccumulatedExps(type);
        if (current >= (limit = ExperienceMaxAccumulatedAmountPerDayConfig.getInstance().getMaxAccumulatedAmountPerDay(type))) {
            return;
        }
        double allowed = Math.min(amount, limit - current);
        this.accumulatedExps.put(type, current + allowed);
        this.addExperience(player, allowed);
    }

    private void addExperience(class_3222 player, double amount) {
        this.experience += amount;
        while (this.experience >= (double)this.getExpToNextLevel()) {
            this.handleLevelUp(player);
        }
    }

    private void handleLevelUp(class_3222 currentPlayer) {
        this.experience -= (double)this.getExpToNextLevel();
        ++this.level;
        ++this.sp;
        if (this.level % 5 == 0) {
            ++this.ap;
        }
        for (class_3222 serverPlayer : currentPlayer.method_5682().method_3760().method_14571()) {
            serverPlayer.method_7353((class_2561)class_2561.method_43469((String)"level_up", (Object[])new Object[]{currentPlayer.method_5476(), this.level}).method_54663(-16711936), false);
        }
        currentPlayer.method_51469().method_43128(null, currentPlayer.method_23317(), currentPlayer.method_23318(), currentPlayer.method_23321(), class_3417.field_14709, class_3419.field_15248, 1.0f, 1.5f);
    }

    public int getExpToNextLevel() {
        return 20 + (this.level - 1) * 10;
    }

    public void resetAbilitiesAndAp() {
        this.initAbilities();
        this.ap = this.level / 5;
    }

    public void resetSkillsAndSp() {
        this.initSkills();
        this.initSkillCoolTimes();
        this.sp = this.level - 1;
        this.currentSkill = null;
    }

    public void resetJob() {
        this.job = Job.BEGINNER;
    }

    public void initAccumulatedExps() {
        this.accumulatedExps = Arrays.stream(ExperienceType.values()).collect(Collectors.toMap(Function.identity(), experienceType -> 0.0));
    }

    private void initAbilities() {
        this.abilities = Arrays.stream(Ability.values()).collect(Collectors.toMap(Function.identity(), ability -> 0));
    }

    private void initSkills() {
        this.skills = Arrays.stream(Skill.values()).collect(Collectors.toMap(Function.identity(), skill -> 0));
    }

    private void initSkillCoolTimes() {
        this.skillCoolTimeByTicks = Arrays.stream(Skill.values()).collect(Collectors.toMap(Function.identity(), skill -> 0));
    }

    public void levelUpAbility(Ability ability) {
        this.abilities.put(ability, this.abilities.getOrDefault(ability, 0) + 1);
        this.ap -= AbilityContextsByLevelConfig.getInstance().getSimpleAbilityContexts(ability).get(this.abilities.get(ability)).getRequiredAp();
    }

    public void levelUpSkill(Skill skill) {
        this.skills.put(skill, this.skills.getOrDefault(skill, 0) + 1);
        this.sp -= SkillContextsByLevelConfig.getInstance().getSimpleSkillContexts(skill).get(this.skills.get(skill)).getRequiredSp();
    }

    public boolean isCoolTime(Skill skill) {
        return this.skillCoolTimeByTicks.getOrDefault(skill, 0) > 0;
    }

    public boolean isNotCoolTime(Skill skill) {
        return !this.isCoolTime(skill);
    }

    public void writeData(class_11372 out) {
        out.method_71465("ap", this.ap);
        out.method_71465("sp", this.sp);
        out.method_71465("level", this.level);
        out.method_71463("experience", this.experience);
        out.method_71469("lastResetDate", this.lastResetDate.toString());
        out.method_71469("job", this.job.name());
        out.method_71469("currentSkill", this.currentSkill == null ? "" : this.currentSkill.name());
        class_11372 expMap = out.method_71461("accumulatedExps");
        for (Map.Entry<ExperienceType, Double> entry : this.accumulatedExps.entrySet()) {
            expMap.method_71463(entry.getKey().name(), entry.getValue().doubleValue());
        }
        class_11372 abilityMap = out.method_71461("abilities");
        for (Map.Entry<Ability, Integer> entry : this.abilities.entrySet()) {
            abilityMap.method_71465(entry.getKey().name(), entry.getValue().intValue());
        }
        class_11372 class_113722 = out.method_71461("skills");
        for (Map.Entry<Skill, Integer> entry : this.skills.entrySet()) {
            class_113722.method_71465(entry.getKey().name(), entry.getValue().intValue());
        }
        class_11372 class_113723 = out.method_71461("skillCoolTimeByTicks");
        for (Map.Entry<Skill, Integer> e : this.skillCoolTimeByTicks.entrySet()) {
            class_113723.method_71465(e.getKey().name(), e.getValue().intValue());
        }
    }

    public void readData(class_11368 in) {
        this.ap = in.method_71424("ap", 0);
        this.sp = in.method_71424("sp", 0);
        this.level = in.method_71424("level", 1);
        this.experience = in.method_71422("experience", 0.0);
        this.lastResetDate = LocalDate.parse(in.method_71428("lastResetDate", LocalDate.now().toString()));
        String jobStr = in.method_71428("job", Job.BEGINNER.name());
        this.job = Job.valueOf(jobStr);
        String cs = in.method_71428("currentSkill", "");
        this.currentSkill = cs.isEmpty() ? null : Skill.valueOf(cs);
        this.accumulatedExps.clear();
        in.method_71420("accumulatedExps").ifPresent(rv -> {
            for (ExperienceType t : ExperienceType.values()) {
                this.accumulatedExps.put(t, rv.method_71422(t.name(), 0.0));
            }
        });
        this.abilities.clear();
        in.method_71420("abilities").ifPresent(rv -> {
            for (Ability a : Ability.values()) {
                this.abilities.put(a, rv.method_71424(a.name(), 0));
            }
        });
        this.skills.clear();
        in.method_71420("skills").ifPresent(rv -> {
            for (Skill s : Skill.values()) {
                this.skills.put(s, rv.method_71424(s.name(), 0));
            }
        });
        this.skillCoolTimeByTicks.clear();
        in.method_71420("skillCoolTimeByTicks").ifPresent(rv -> {
            for (Skill s : Skill.values()) {
                this.skillCoolTimeByTicks.put(s, rv.method_71424(s.name(), 0));
            }
        });
    }

    public Map<ExperienceType, Double> getAccumulatedExps() {
        return this.accumulatedExps;
    }

    @Override
    public Map<Ability, Integer> getAbilities() {
        return this.abilities;
    }

    @Override
    public Map<Skill, Integer> getSkills() {
        return this.skills;
    }

    public Map<Skill, Integer> getSkillCoolTimeByTicks() {
        return this.skillCoolTimeByTicks;
    }

    public LocalDate getLastResetDate() {
        return this.lastResetDate;
    }

    @Override
    public int getAp() {
        return this.ap;
    }

    @Override
    public int getSp() {
        return this.sp;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public double getExperience() {
        return this.experience;
    }

    public Skill getCurrentSkill() {
        return this.currentSkill;
    }

    @Override
    public Job getJob() {
        return this.job;
    }

    public void setLastResetDate(LocalDate lastResetDate) {
        this.lastResetDate = lastResetDate;
    }

    public void setCurrentSkill(Skill currentSkill) {
        this.currentSkill = currentSkill;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public static final class Fields {
        public static final String accumulatedExps = "accumulatedExps";
        public static final String abilities = "abilities";
        public static final String skills = "skills";
        public static final String skillCoolTimeByTicks = "skillCoolTimeByTicks";
        public static final String lastResetDate = "lastResetDate";
        public static final String ap = "ap";
        public static final String sp = "sp";
        public static final String level = "level";
        public static final String experience = "experience";
        public static final String currentSkill = "currentSkill";
        public static final String job = "job";
    }
}

